/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpAsgnNode
extends Node {
    private Node receiverNode;
    private Node valueNode;
    private String operatorName;
    private String variableName;

    public OpAsgnNode(SourcePosition position, Node receiverNode, Node valueNode, String variableName, String operatorName) {
        super(position);
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = this.adopt(receiverNode);
        this.valueNode = this.adopt(valueNode);
        this.operatorName = operatorName;
        this.variableName = variableName;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPASGNNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitOpAsgnNode(this);
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public Node getReceiver() {
        return this.receiverNode;
    }

    @Deprecated
    public Node getReceiverNode() {
        return this.getReceiver();
    }

    public void setReceiver(Node receiver) {
        this.receiverNode = this.adopt(receiver);
    }

    public Node getValue() {
        return this.valueNode;
    }

    @Deprecated
    public Node getValueNode() {
        return this.getValue();
    }

    public void setValue(Node value) {
        this.valueNode = this.adopt(value);
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.valueNode);
    }
}

