/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.options;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.jruby.truffle.Log;
import org.jruby.truffle.core.string.KCode;
import org.jruby.truffle.core.string.StringSupport;
import org.jruby.truffle.options.MainExitException;
import org.jruby.truffle.options.RubyInstanceConfig;
import org.jruby.truffle.options.Verbosity;

public class ArgumentProcessor {
    public static final String SEPARATOR = "(?<!jar:file|jar|file|classpath|uri:classloader|uri|http|https):";
    private final List<Argument> arguments;
    private int argumentIndex = 0;
    private boolean processArgv;
    private final boolean rubyOpts;
    final RubyInstanceConfig config;
    private boolean endOfArguments = false;
    private int characterIndex = 0;
    private static final Pattern VERSION_FLAG = Pattern.compile("^--[12]\\.[89012]$");
    private static final Set<String> KNOWN_PROPERTIES = new HashSet<String>(16, 1.0f);
    private static final List<String> KNOWN_PROPERTY_PREFIXES;
    private static final Map<String, BiFunction<ArgumentProcessor, Boolean, Boolean>> FEATURES;

    public ArgumentProcessor(String[] arguments, RubyInstanceConfig config) {
        this(arguments, true, false, false, config);
    }

    public ArgumentProcessor(String[] arguments, boolean processArgv, boolean dashed, boolean rubyOpts, RubyInstanceConfig config) {
        this.config = config;
        if (arguments != null && arguments.length > 0) {
            this.arguments = new ArrayList<Argument>(arguments.length);
            for (String argument : arguments) {
                this.arguments.add(new Argument(argument, dashed));
            }
        } else {
            this.arguments = new ArrayList<Argument>(0);
        }
        this.processArgv = processArgv;
        this.rubyOpts = rubyOpts;
    }

    public void processArguments() {
        this.processArguments(true);
    }

    public void processArguments(boolean inline) {
        ArgumentProcessor.checkProperties();
        while (this.argumentIndex < this.arguments.size() && this.isInterpreterArgument(this.arguments.get((int)this.argumentIndex).originalValue)) {
            this.processArgument();
            ++this.argumentIndex;
        }
        if (inline && !this.config.isInlineScript() && this.config.getScriptFileName() == null && !this.config.isForceStdin() && this.argumentIndex < this.arguments.size()) {
            this.config.setScriptFileName(this.arguments.get((int)this.argumentIndex).originalValue);
            ++this.argumentIndex;
        }
        if (this.processArgv) {
            this.processArgv();
        }
    }

    private void processArgv() {
        ArrayList<String> arglist = new ArrayList<String>();
        while (this.argumentIndex < this.arguments.size()) {
            String arg = this.arguments.get((int)this.argumentIndex).originalValue;
            if (this.config.isArgvGlobalsOn() && arg.startsWith("-")) {
                int split = (arg = arg.substring(1)).indexOf(61);
                if (split > 0) {
                    String key = arg.substring(0, split);
                    String val = arg.substring(split + 1);
                    String globalName = key.replace('-', '_');
                    this.config.getOptionGlobals().put(globalName, val);
                } else {
                    this.config.getOptionGlobals().put(arg, null);
                }
            } else {
                this.config.setArgvGlobalsOn(false);
                arglist.add(arg);
            }
            ++this.argumentIndex;
        }
        arglist.addAll(Arrays.asList(this.config.getArgv()));
        this.config.setArgv(arglist.toArray(new String[arglist.size()]));
    }

    private boolean isInterpreterArgument(String argument) {
        return argument.length() > 0 && (argument.charAt(0) == '-' || argument.charAt(0) == '+') && !this.endOfArguments;
    }

    private String getArgumentError(String additionalError) {
        return "jruby: invalid argument\n" + additionalError + "\n";
    }

    /*
     * WARNING - void declaration
     */
    private void processArgument() {
        String argument = this.arguments.get(this.argumentIndex).getDashedValue();
        if (argument.length() == 1) {
            this.endOfArguments = true;
            this.config.setForceStdin(true);
            return;
        }
        this.characterIndex = 1;
        block37: while (this.characterIndex < argument.length()) {
            switch (argument.charAt(this.characterIndex)) {
                case '0': {
                    this.disallowedInRubyOpts(argument);
                    String temp = this.grabOptionalValue();
                    if (null == temp) {
                        throw new UnsupportedOperationException();
                    }
                    if (temp.equals("0")) {
                        throw new UnsupportedOperationException();
                    }
                    if (temp.equals("777")) {
                        throw new UnsupportedOperationException();
                    }
                    try {
                        Integer.parseInt(temp, 8);
                        throw new UnsupportedOperationException();
                    }
                    catch (Exception e) {
                        MainExitException mee = new MainExitException(1, this.getArgumentError(" -0 must be followed by either 0, 777, or a valid octal value"));
                        mee.setUsageError(true);
                        throw mee;
                    }
                }
                case 'a': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setSplit(true);
                    break;
                }
                case 'c': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setShouldCheckSyntax(true);
                    break;
                }
                case 'C': {
                    this.disallowedInRubyOpts(argument);
                    try {
                        String saved = this.grabValue(this.getArgumentError(" -C must be followed by a directory expression"));
                        File base = new File(this.config.getCurrentDirectory());
                        File newDir = new File(saved);
                        if (saved.startsWith("uri:classloader:")) {
                            this.config.setCurrentDirectory(saved);
                        } else if (newDir.isAbsolute()) {
                            this.config.setCurrentDirectory(newDir.getCanonicalPath());
                        } else {
                            this.config.setCurrentDirectory(new File(base, newDir.getPath()).getCanonicalPath());
                        }
                        if (!new File(this.config.getCurrentDirectory()).isDirectory() && !this.config.getCurrentDirectory().startsWith("uri:classloader:")) {
                            throw new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                        }
                        break block37;
                    }
                    catch (IOException e) {
                        throw new MainExitException(1, this.getArgumentError(" -C must be followed by a valid directory"));
                    }
                }
                case 'd': {
                    this.config.setDebug(true);
                    this.config.setVerbosity(Verbosity.TRUE);
                    break;
                }
                case 'e': {
                    this.disallowedInRubyOpts(argument);
                    this.config.getInlineScript().append(this.grabValue(this.getArgumentError(" -e must be followed by an expression to report")));
                    this.config.getInlineScript().append('\n');
                    this.config.setHasInlineScript(true);
                    break block37;
                }
                case 'E': {
                    this.processEncodingOption(this.grabValue(this.getArgumentError("unknown encoding name")));
                    break block37;
                }
                case 'F': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setInputFieldSeparator(this.grabValue(this.getArgumentError(" -F must be followed by a pattern for input field separation")));
                    break block37;
                }
                case 'h': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setShouldPrintUsage(true);
                    this.config.setShouldRunInterpreter(false);
                    break;
                }
                case 'i': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setInPlaceBackupExtension(this.grabOptionalValue());
                    if (this.config.getInPlaceBackupExtension() != null) break block37;
                    this.config.setInPlaceBackupExtension("");
                    break block37;
                }
                case 'I': {
                    String s = this.grabValue(this.getArgumentError("-I must be followed by a directory name to add to lib path"));
                    String separator = File.pathSeparator;
                    if (":".equals(separator)) {
                        separator = SEPARATOR;
                    }
                    String[] ls = s.split(separator);
                    this.config.getLoadPaths().addAll(Arrays.asList(ls));
                    break block37;
                }
                case 'J': {
                    String js = this.grabOptionalValue();
                    this.config.getError().println("warning: " + argument + " argument ignored (launched in same VM?)");
                    if (!js.equals("-cp") && !js.equals("-classpath")) break block37;
                    while (this.grabOptionalValue() != null) {
                    }
                    this.grabValue(this.getArgumentError(" -J-cp must be followed by a path expression"));
                    break block37;
                }
                case 'K': {
                    String eArg = this.grabValue(this.getArgumentError("provide a value for -K"));
                    this.config.setKCode(KCode.create(eArg));
                    this.config.setSourceEncoding(this.config.getKCode().getEncoding().toString());
                    if (this.config.getExternalEncoding() != null) break;
                    this.config.setExternalEncoding(this.config.getKCode().getEncoding().toString());
                    break;
                }
                case 'l': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setProcessLineEnds(true);
                    break;
                }
                case 'n': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setAssumeLoop(true);
                    break;
                }
                case 'p': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setAssumePrinting(true);
                    this.config.setAssumeLoop(true);
                    break;
                }
                case 'r': {
                    this.config.getRequiredLibraries().add(this.grabValue(this.getArgumentError("-r must be followed by a package to require")));
                    break block37;
                }
                case 's': {
                    this.disallowedInRubyOpts(argument);
                    this.config.setArgvGlobalsOn(true);
                    break;
                }
                case 'G': {
                    throw new UnsupportedOperationException();
                }
                case 'S': {
                    this.disallowedInRubyOpts(argument);
                    this.runBinScript();
                    break block37;
                }
                case 'T': {
                    this.grabOptionalValue();
                    break block37;
                }
                case 'U': {
                    this.config.setInternalEncoding("UTF-8");
                    break;
                }
                case 'v': {
                    this.config.setVerbosity(Verbosity.TRUE);
                    this.config.setShowVersion(true);
                    break;
                }
                case 'w': {
                    this.config.setVerbosity(Verbosity.TRUE);
                    break;
                }
                case 'W': {
                    String temp = this.grabOptionalValue();
                    if (temp == null) {
                        this.config.setVerbosity(Verbosity.TRUE);
                        break block37;
                    }
                    if (temp.equals("0")) {
                        this.config.setVerbosity(Verbosity.NIL);
                        break block37;
                    }
                    if (temp.equals("1")) {
                        this.config.setVerbosity(Verbosity.FALSE);
                        break block37;
                    }
                    if (temp.equals("2")) {
                        this.config.setVerbosity(Verbosity.TRUE);
                        break block37;
                    }
                    MainExitException mee = new MainExitException(1, this.getArgumentError(" -W must be followed by either 0, 1, 2 or nothing"));
                    mee.setUsageError(true);
                    throw mee;
                }
                case 'x': {
                    this.disallowedInRubyOpts(argument);
                    try {
                        String saved = this.grabOptionalValue();
                        if (saved != null) {
                            File base = new File(this.config.getCurrentDirectory());
                            File file = new File(saved);
                            if (saved.startsWith("uri:classloader:")) {
                                this.config.setCurrentDirectory(saved);
                            } else if (file.isAbsolute()) {
                                this.config.setCurrentDirectory(file.getCanonicalPath());
                            } else {
                                this.config.setCurrentDirectory(new File(base, file.getPath()).getCanonicalPath());
                            }
                            if (!new File(this.config.getCurrentDirectory()).isDirectory() && !this.config.getCurrentDirectory().startsWith("uri:classloader:")) {
                                throw new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                            }
                        }
                        this.config.setXFlag(true);
                        break block37;
                    }
                    catch (IOException e) {
                        throw new MainExitException(1, this.getArgumentError(" -x must be followed by a valid directory"));
                    }
                }
                case 'X': {
                    this.disallowedInRubyOpts(argument);
                    String extendedOption = this.grabOptionalValue();
                    if (extendedOption == null) {
                        throw new MainExitException(0, "no extended options in Truffle");
                    }
                    if (extendedOption.equals("-C") || extendedOption.equals("-CIR")) {
                        throw new UnsupportedOperationException();
                    }
                    if (extendedOption.equals("+C") || extendedOption.equals("+CIR")) {
                        throw new UnsupportedOperationException();
                    }
                    if (extendedOption.equals("classic")) {
                        throw new UnsupportedOperationException();
                    }
                    if (extendedOption.equals("+T")) break block37;
                    if (extendedOption.endsWith("...")) {
                        throw new UnsupportedOperationException();
                    }
                    if (extendedOption.endsWith("?")) {
                        throw new UnsupportedOperationException();
                    }
                    if (extendedOption.startsWith("log=")) {
                        void var9_10;
                        String levelString = extendedOption.substring("log=".length());
                        if (levelString.equals("PERFORMANCE")) {
                            Level level = Log.PERFORMANCE;
                        } else {
                            Level level = Level.parse(levelString.toUpperCase());
                        }
                        Log.LOGGER.setLevel((Level)var9_10);
                        break block37;
                    }
                    MainExitException mee = new MainExitException(1, "jruby: invalid extended option " + extendedOption + " (-X will list valid options)\n");
                    mee.setUsageError(true);
                    throw mee;
                }
                case 'y': {
                    this.disallowedInRubyOpts(argument);
                    if (this.rubyOpts) break block37;
                    throw new UnsupportedOperationException();
                }
                case '-': {
                    if (argument.equals("--command") || argument.equals("--bin")) {
                        this.characterIndex = argument.length();
                        this.runBinScript();
                        break;
                    }
                    if (argument.equals("--compat")) {
                        this.characterIndex = argument.length();
                        this.grabValue(this.getArgumentError("--compat takes an argument, but will be ignored"));
                        this.config.getError().println("warning: " + argument + " ignored");
                        break block37;
                    }
                    if (argument.equals("--copyright")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShowCopyright(true);
                        this.config.setShouldRunInterpreter(false);
                        break block37;
                    }
                    if (argument.equals("--debug")) {
                        throw new UnsupportedOperationException();
                    }
                    if (argument.startsWith("--debug=")) {
                        throw new UnsupportedOperationException();
                    }
                    if (argument.equals("--jdb")) {
                        this.config.setDebug(true);
                        this.config.setVerbosity(Verbosity.TRUE);
                        break;
                    }
                    if (argument.equals("--help")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShouldPrintUsage(true);
                        this.config.setShouldRunInterpreter(false);
                        break;
                    }
                    if (argument.equals("--version")) {
                        this.disallowedInRubyOpts(argument);
                        this.config.setShowVersion(true);
                        this.config.setShouldRunInterpreter(false);
                        break block37;
                    }
                    if (argument.equals("--fast")) {
                        throw new UnsupportedOperationException();
                    }
                    if (argument.startsWith("--profile")) {
                        throw new UnsupportedOperationException();
                    }
                    if (VERSION_FLAG.matcher(argument).matches()) {
                        this.config.getError().println("warning: " + argument + " ignored");
                        break block37;
                    }
                    if (argument.equals("--debug-frozen-string-literal")) {
                        throw new UnsupportedOperationException();
                    }
                    if (argument.startsWith("--disable")) {
                        int len = argument.length();
                        if (len == "--disable".length()) {
                            this.characterIndex = len;
                            String string = this.grabValue(this.getArgumentError("missing argument for --disable"), false);
                            argument = "--disable=" + string;
                        }
                        for (String disable : ArgumentProcessor.valueListFor(argument, "disable")) {
                            this.enableDisableFeature(disable, false);
                        }
                        break block37;
                    }
                    if (argument.startsWith("--enable")) {
                        int len = argument.length();
                        if (len == "--enable".length()) {
                            this.characterIndex = len;
                            String string = this.grabValue(this.getArgumentError("missing argument for --enable"), false);
                            argument = "--enable=" + string;
                        }
                        for (String enable : ArgumentProcessor.valueListFor(argument, "enable")) {
                            this.enableDisableFeature(enable, true);
                        }
                        break block37;
                    }
                    if (argument.equals("--gemfile")) {
                        throw new UnsupportedOperationException();
                    }
                    if (argument.equals("--dump")) {
                        this.characterIndex = argument.length();
                        String error = "--dump only supports [version, copyright, usage, yydebug, syntax, insns] on JRuby";
                        String string = this.grabValue(this.getArgumentError(error));
                        if (string.equals("version")) {
                            this.config.setShowVersion(true);
                            this.config.setShouldRunInterpreter(false);
                            break block37;
                        }
                        if (string.equals("copyright")) {
                            this.config.setShowCopyright(true);
                            this.config.setShouldRunInterpreter(false);
                            break block37;
                        }
                        if (string.equals("usage")) {
                            this.config.setShouldPrintUsage(true);
                            this.config.setShouldRunInterpreter(false);
                            break block37;
                        }
                        if (string.equals("syntax")) {
                            this.config.setShouldCheckSyntax(true);
                            break;
                        }
                        MainExitException mee = new MainExitException(1, error);
                        mee.setUsageError(true);
                        throw mee;
                    }
                    if (argument.equals("--dev")) {
                        throw new UnsupportedOperationException();
                    }
                    if (argument.equals("--server") || argument.equals("--client")) break block37;
                    if (argument.equals("--verbose")) {
                        this.config.setVerbosity(Verbosity.TRUE);
                        break block37;
                    }
                    if (argument.equals("--yydebug")) {
                        this.disallowedInRubyOpts(argument);
                        if (!this.rubyOpts) {
                            throw new UnsupportedOperationException();
                        }
                    } else if (argument.equals("--")) {
                        this.endOfArguments = true;
                        break;
                    }
                    throw new MainExitException(1, "jruby: unknown option " + argument);
                }
                default: {
                    throw new MainExitException(1, "jruby: unknown option " + argument);
                }
            }
            ++this.characterIndex;
        }
    }

    private void enableDisableFeature(String name, boolean enable) {
        BiFunction<ArgumentProcessor, Boolean, Boolean> feature = FEATURES.get(name);
        if (feature == null) {
            this.config.getError().println("warning: unknown argument for --" + (enable ? "enable" : "disable") + ": `" + name + "'");
        } else {
            feature.apply(this, enable);
        }
    }

    private static String[] valueListFor(String argument, String key) {
        int length = key.length() + 3;
        String[] values = argument.substring(length).split(",");
        if (values.length == 0) {
            ArgumentProcessor.errorMissingEquals(key);
        }
        return values;
    }

    private void disallowedInRubyOpts(CharSequence option) {
        if (this.rubyOpts) {
            throw new MainExitException(1, "jruby: invalid switch in RUBYOPT: " + option + " (RuntimeError)");
        }
    }

    private static void errorMissingEquals(String label) {
        MainExitException mee = new MainExitException(1, "missing argument for --" + label + "\n");
        mee.setUsageError(true);
        throw mee;
    }

    private void processEncodingOption(String value) {
        List<String> encodings = StringSupport.split(value, ':', 3);
        switch (encodings.size()) {
            case 3: {
                throw new MainExitException(1, "extra argument for -E: " + encodings.get(2));
            }
            case 2: {
                this.config.setInternalEncoding(encodings.get(1));
            }
            case 1: {
                this.config.setExternalEncoding(encodings.get(0));
            }
        }
    }

    private void runBinScript() {
        String scriptName = this.grabValue("jruby: provide a bin script to execute");
        this.config.setUsePathScript(scriptName);
        this.endOfArguments = true;
    }

    private String grabValue(String errorMessage) {
        return this.grabValue(errorMessage, true);
    }

    private String grabValue(String errorMessage, boolean usageError) {
        String optValue = this.grabOptionalValue();
        if (optValue != null) {
            return optValue;
        }
        ++this.argumentIndex;
        if (this.argumentIndex < this.arguments.size()) {
            return this.arguments.get((int)this.argumentIndex).originalValue;
        }
        MainExitException mee = new MainExitException(1, errorMessage);
        if (usageError) {
            mee.setUsageError(true);
        }
        throw mee;
    }

    private String grabOptionalValue() {
        ++this.characterIndex;
        String argValue = this.arguments.get((int)this.argumentIndex).originalValue;
        if (this.characterIndex < argValue.length()) {
            return argValue.substring(this.characterIndex);
        }
        return null;
    }

    private static void checkProperties() {
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith("jruby.") || propertyName.startsWith("jruby.truffle.") || ArgumentProcessor.isPropertySupported(propertyName)) continue;
            System.err.println("jruby: warning: unknown property " + propertyName);
        }
    }

    private static boolean isPropertySupported(String propertyName) {
        if (KNOWN_PROPERTIES.contains(propertyName)) {
            return true;
        }
        for (String prefix : KNOWN_PROPERTY_PREFIXES) {
            if (!propertyName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static {
        KNOWN_PROPERTIES.add("jruby.home");
        KNOWN_PROPERTIES.add("jruby.script");
        KNOWN_PROPERTIES.add("jruby.shell");
        KNOWN_PROPERTIES.add("jruby.lib");
        KNOWN_PROPERTIES.add("jruby.bindir");
        KNOWN_PROPERTIES.add("jruby.jar");
        KNOWN_PROPERTIES.add("jruby.compat.version");
        KNOWN_PROPERTIES.add("jruby.reflection");
        KNOWN_PROPERTIES.add("jruby.thread.pool.enabled");
        KNOWN_PROPERTIES.add("jruby.memory.max");
        KNOWN_PROPERTIES.add("jruby.stack.max");
        KNOWN_PROPERTY_PREFIXES = new ArrayList<String>(4);
        KNOWN_PROPERTY_PREFIXES.add("jruby.openssl.");
        HashMap<String, BiFunction<ArgumentProcessor, Boolean, Boolean>> features = new HashMap<String, BiFunction<ArgumentProcessor, Boolean, Boolean>>(12, 1.0f);
        features.put("all", new BiFunction<ArgumentProcessor, Boolean, Boolean>(){

            @Override
            public Boolean apply(ArgumentProcessor processor, Boolean enable) {
                for (Map.Entry entry : FEATURES.entrySet()) {
                    if (((String)entry.getKey()).equals("all")) continue;
                    ((BiFunction)entry.getValue()).apply(processor, enable);
                }
                return true;
            }
        });
        features.put("gem", new BiFunction<ArgumentProcessor, Boolean, Boolean>(){

            @Override
            public Boolean apply(ArgumentProcessor processor, Boolean enable) {
                processor.config.setDisableGems(enable == false);
                return true;
            }
        });
        features.put("gems", new BiFunction<ArgumentProcessor, Boolean, Boolean>(){

            @Override
            public Boolean apply(ArgumentProcessor processor, Boolean enable) {
                processor.config.setDisableGems(enable == false);
                return true;
            }
        });
        BiFunction<ArgumentProcessor, Boolean, Boolean> function2 = new BiFunction<ArgumentProcessor, Boolean, Boolean>(){

            @Override
            public Boolean apply(ArgumentProcessor processor, Boolean enable) {
                processor.config.setFrozenStringLiteral(enable);
                return true;
            }
        };
        features.put("frozen-string-literal", function2);
        features.put("frozen_string_literal", function2);
        FEATURES = features;
    }

    private static final class Argument {
        final String originalValue;
        private String dashedValue;

        Argument(String value, boolean dashed) {
            this.originalValue = value;
            this.dashedValue = dashed ? null : value;
        }

        final String getDashedValue() {
            String dashedValue = this.dashedValue;
            if (dashedValue == null) {
                String value = this.originalValue;
                this.dashedValue = dashedValue = !value.startsWith("-") ? '-' + value : value;
            }
            return dashedValue;
        }

        public String toString() {
            return this.getDashedValue();
        }
    }
}

