/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.methods.CallBoundMethodNode;

@GeneratedBy(value=CallBoundMethodNode.class)
public final class CallBoundMethodNodeGen
extends CallBoundMethodNode {
    @Node.Child
    private RubyNode method_;
    @Node.Child
    private RubyNode arguments_;
    @Node.Child
    private RubyNode block_;
    @CompilerDirectives.CompilationFinal
    private boolean seenUnsupported0;

    private CallBoundMethodNodeGen(RubyNode method, RubyNode arguments, RubyNode block) {
        this.method_ = method;
        this.arguments_ = arguments;
        this.block_ = block;
    }

    public NodeCost getCost() {
        return NodeCost.MONOMORPHIC;
    }

    @Override
    public Object executeCallBoundMethod(VirtualFrame frameValue, DynamicObject methodValue, Object[] argumentsValue, Object blockValue) {
        return this.call(frameValue, methodValue, argumentsValue, blockValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        Object[] argumentsValue_;
        DynamicObject methodValue_;
        try {
            methodValue_ = this.method_.executeDynamicObject(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object argumentsValue = this.arguments_.execute(frameValue);
            Object blockValue = this.block_.execute(frameValue);
            throw this.unsupported(ex.getResult(), argumentsValue, blockValue);
        }
        try {
            argumentsValue_ = this.arguments_.executeObjectArray(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object blockValue = this.block_.execute(frameValue);
            throw this.unsupported(methodValue_, ex.getResult(), blockValue);
        }
        Object blockValue_ = this.block_.execute(frameValue);
        return this.call(frameValue, methodValue_, argumentsValue_, blockValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private UnsupportedSpecializationException unsupported(Object methodValue, Object argumentsValue, Object blockValue) {
        if (!this.seenUnsupported0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.seenUnsupported0 = true;
        }
        return new UnsupportedSpecializationException((Node)this, new Node[]{this.method_, this.arguments_, this.block_}, new Object[]{methodValue, argumentsValue, blockValue});
    }

    public static CallBoundMethodNode create(RubyNode method, RubyNode arguments, RubyNode block) {
        return new CallBoundMethodNodeGen(method, arguments, block);
    }
}

