/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.Visibility;
import org.jruby.truffle.language.methods.AddMethodNode;
import org.jruby.truffle.language.methods.InternalMethod;

@GeneratedBy(value=AddMethodNode.class)
public final class AddMethodNodeGen
extends AddMethodNode {
    @Node.Child
    private RubyNode moduleNode_;
    @Node.Child
    private RubyNode methodNode_;
    @Node.Child
    private RubyNode visibilityNode_;
    @CompilerDirectives.CompilationFinal
    private boolean seenUnsupported0;

    private AddMethodNodeGen(boolean ignoreNameVisibility, boolean isLiteralDef, RubyNode moduleNode, RubyNode methodNode, RubyNode visibilityNode) {
        super(ignoreNameVisibility, isLiteralDef);
        this.moduleNode_ = moduleNode;
        this.methodNode_ = methodNode;
        this.visibilityNode_ = visibilityNode;
    }

    public NodeCost getCost() {
        return NodeCost.MONOMORPHIC;
    }

    @Override
    public DynamicObject executeAddMethod(DynamicObject moduleNodeValue, InternalMethod methodNodeValue, Visibility visibilityNodeValue) {
        if (RubyGuards.isRubyModule(moduleNodeValue)) {
            return this.addMethod(moduleNodeValue, methodNodeValue, visibilityNodeValue);
        }
        throw this.unsupported(moduleNodeValue, methodNodeValue, (Object)visibilityNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        Visibility visibilityNodeValue_;
        InternalMethod methodNodeValue_;
        DynamicObject moduleNodeValue_;
        try {
            moduleNodeValue_ = this.moduleNode_.executeDynamicObject(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object methodNodeValue = this.methodNode_.execute(frameValue);
            Object visibilityNodeValue = this.visibilityNode_.execute(frameValue);
            throw this.unsupported(ex.getResult(), methodNodeValue, visibilityNodeValue);
        }
        try {
            methodNodeValue_ = AddMethodNodeGen.expectInternalMethod(this.methodNode_.execute(frameValue));
        }
        catch (UnexpectedResultException ex) {
            Object visibilityNodeValue = this.visibilityNode_.execute(frameValue);
            throw this.unsupported(moduleNodeValue_, ex.getResult(), visibilityNodeValue);
        }
        try {
            visibilityNodeValue_ = AddMethodNodeGen.expectVisibility(this.visibilityNode_.execute(frameValue));
        }
        catch (UnexpectedResultException ex) {
            throw this.unsupported(moduleNodeValue_, methodNodeValue_, ex.getResult());
        }
        if (RubyGuards.isRubyModule(moduleNodeValue_)) {
            return this.addMethod(moduleNodeValue_, methodNodeValue_, visibilityNodeValue_);
        }
        throw this.unsupported(moduleNodeValue_, methodNodeValue_, (Object)visibilityNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private UnsupportedSpecializationException unsupported(Object moduleNodeValue, Object methodNodeValue, Object visibilityNodeValue) {
        if (!this.seenUnsupported0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.seenUnsupported0 = true;
        }
        return new UnsupportedSpecializationException((Node)this, new Node[]{this.moduleNode_, this.methodNode_, this.visibilityNode_}, new Object[]{moduleNodeValue, methodNodeValue, visibilityNodeValue});
    }

    private static InternalMethod expectInternalMethod(Object value) throws UnexpectedResultException {
        if (value instanceof InternalMethod) {
            return (InternalMethod)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static Visibility expectVisibility(Object value) throws UnexpectedResultException {
        if (value instanceof Visibility) {
            return (Visibility)((Object)value);
        }
        throw new UnexpectedResultException(value);
    }

    public static AddMethodNode create(boolean ignoreNameVisibility, boolean isLiteralDef, RubyNode moduleNode, RubyNode methodNode, RubyNode visibilityNode) {
        return new AddMethodNodeGen(ignoreNameVisibility, isLiteralDef, moduleNode, methodNode, visibilityNode);
    }
}

