/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.time;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.core.time.GetTimeZoneNode;
import org.jruby.truffle.core.time.GetTimeZoneNodeGen;
import org.jruby.truffle.core.time.RubyDateFormatter;
import org.jruby.truffle.core.time.TimeNodesFactory;
import org.jruby.truffle.core.time.TimeZoneAndName;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.Visibility;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.parser.Helpers;

@CoreClass(value="Time")
public abstract class TimeNodes {
    private static final ZonedDateTime ZERO = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneId.systemDefault());
    private static final ZoneId UTC = ZoneId.of("UTC");

    public static class TimeZoneParser {
        private static final Pattern TZ_PATTERN = Pattern.compile("([^-\\+\\d]+)?([\\+-]?)(\\d+)(?::(\\d+))?(?::(\\d+))?");
        private static final Map<String, String> LONG_TZNAME = Helpers.map("MET", "CET", "ROC", "Asia/Taipei", "WET", "Europe/Lisbon");

        public static String getShortZoneName(DynamicObject time, ZoneId zone) {
            ZonedDateTime dateTime = Layouts.TIME.getDateTime(time);
            return TimeZoneParser.getShortZoneName(dateTime, zone);
        }

        @CompilerDirectives.TruffleBoundary
        public static String getShortZoneName(ZonedDateTime dateTime, ZoneId zone) {
            String name = zone.getDisplayName(TextStyle.SHORT, Locale.ENGLISH);
            boolean summer = zone.getRules().isDaylightSavings(dateTime.toInstant());
            switch (name) {
                case "AT": {
                    if (summer) {
                        name = "ADT";
                        break;
                    }
                    name = "AST";
                    break;
                }
                case "ET": {
                    if (summer) {
                        name = "EDT";
                        break;
                    }
                    name = "EST";
                    break;
                }
                case "CT": {
                    if (summer) {
                        name = "CDT";
                        break;
                    }
                    name = "CST";
                    break;
                }
                case "CET": {
                    if (!summer) break;
                    name = "CEST";
                }
            }
            return name;
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        public static TimeZoneAndName parse(RubyNode node, String zoneString) {
            String zone = zoneString;
            String upZone = zone.toUpperCase(Locale.ENGLISH);
            Matcher tzMatcher = TZ_PATTERN.matcher(zone);
            if (tzMatcher.matches()) {
                String name = tzMatcher.group(1);
                String sign = tzMatcher.group(2);
                String hours = tzMatcher.group(3);
                String minutes = tzMatcher.group(4);
                String seconds = tzMatcher.group(5);
                if (name == null) {
                    name = "";
                }
                return TimeZoneParser.getTimeZoneFromHHMM(node, name, sign.equals("-"), hours, minutes, seconds);
            }
            if (LONG_TZNAME.containsKey(upZone)) {
                zone = LONG_TZNAME.get(upZone);
            } else if (upZone.equals("UTC") || upZone.equals("GMT")) {
                zone = "Etc/" + upZone;
            }
            try {
                return new TimeZoneAndName(ZoneId.of(zone), null);
            }
            catch (IllegalArgumentException e) {
                return new TimeZoneAndName(UTC, null);
            }
        }

        private static TimeZoneAndName getTimeZoneFromHHMM(RubyNode node, String name, boolean positive, String hours, String minutes, String seconds) {
            int h = Integer.parseInt(hours);
            int m = 0;
            int s = 0;
            if (minutes != null) {
                m = Integer.parseInt(minutes);
            }
            if (seconds != null) {
                s = Integer.parseInt(seconds);
            }
            if (h > 23 || m > 59) {
                throw new RaiseException(node.getContext().getCoreExceptions().argumentError("utc_offset out of range", (Node)node));
            }
            int offset = (positive ? 1 : -1) * (h * 3600 + m * 60 + s) * 1000;
            return TimeZoneParser.timeZoneWithOffset(node, name, offset);
        }

        private static TimeZoneAndName timeZoneWithOffset(RubyNode node, String zoneName, int offset) {
            ZoneId zone;
            try {
                zone = ZoneId.ofOffset("", ZoneOffset.ofTotalSeconds(offset / 1000));
            }
            catch (DateTimeException e) {
                throw new RaiseException(node.getContext().getCoreExceptions().argumentError(e.getMessage(), (Node)node));
            }
            if (zoneName.isEmpty()) {
                return new TimeZoneAndName(zone, null);
            }
            return new TimeZoneAndName(zone, zoneName);
        }
    }

    @Primitive(name="time_utc_offset")
    public static abstract class TimeUTCOffsetPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object timeUTCOffset(DynamicObject time) {
            return Layouts.TIME.getDateTime(time).getOffset().getTotalSeconds();
        }
    }

    @Primitive(name="time_set_nseconds", lowerFixnum={1})
    public static abstract class TimeSetNSecondsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public long timeSetNSeconds(DynamicObject time, int nanoseconds) {
            ZonedDateTime dateTime = Layouts.TIME.getDateTime(time);
            Layouts.TIME.setDateTime(time, dateTime.plusNanos(nanoseconds - dateTime.getNano()));
            return nanoseconds;
        }
    }

    @Primitive(name="time_nseconds")
    public static abstract class TimeNSecondsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public long timeNSeconds(DynamicObject time) {
            return Layouts.TIME.getDateTime(time).getNano();
        }
    }

    @Primitive(name="time_s_from_array", needsSelf=true, lowerFixnum={1, 2, 3, 4, 5, 6, 7, 8})
    public static abstract class TimeSFromArrayPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization(guards={"!fromutc", "!isNil(utcoffset)"})
        public DynamicObject timeSFromArray(VirtualFrame frame, DynamicObject timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, DynamicObject utcoffset, @Cached(value="new()") SnippetNode snippetNode) {
            TimeZoneAndName zoneAndName = !fromutc && utcoffset == this.nil() ? this.getTimeZoneNode.executeGetTimeZone(frame) : null;
            int millis = TimeSFromArrayPrimitiveNode.cast(snippetNode.execute(frame, "(offset * 1000).to_i", "offset", utcoffset));
            return this.buildTime(timeClass, sec, min, hour, mday, month, year, nsec, isdst, fromutc, utcoffset, zoneAndName, millis);
        }

        @Specialization(guards={"(fromutc || !isDynamicObject(utcoffset)) || isNil(utcoffset)"})
        public DynamicObject timeSFromArray(VirtualFrame frame, DynamicObject timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, Object utcoffset) {
            TimeZoneAndName zoneAndName = !fromutc && utcoffset == this.nil() ? this.getTimeZoneNode.executeGetTimeZone(frame) : null;
            return this.buildTime(timeClass, sec, min, hour, mday, month, year, nsec, isdst, fromutc, utcoffset, zoneAndName, -1);
        }

        @Specialization(guards={"!isInteger(sec) || !isInteger(nsec)"})
        public DynamicObject timeSFromArrayFallback(VirtualFrame frame, DynamicObject timeClass, Object sec, int min, int hour, int mday, int month, int year, Object nsec, int isdst, boolean fromutc, Object utcoffset) {
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject buildTime(DynamicObject timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, Object utcoffset, TimeZoneAndName envZone, int zoneOffsetMillis) {
            DynamicObject zoneToStore;
            boolean relativeOffset;
            ZoneId zone;
            ZonedDateTime dt;
            block10: {
                if (sec < 0 || sec > 59 || min < 0 || min > 59 || hour < 0 || hour > 23 || mday < 1 || mday > 31 || month < 1 || month > 12) {
                    throw new RaiseException(this.coreExceptions().argumentErrorOutOfRange(this));
                }
                dt = ZonedDateTime.of(year, 1, 1, 0, 0, 0, 0, UTC);
                dt = dt.plusMonths(month - 1).plusDays(mday - 1).plusHours(hour).plusMinutes(min).plusSeconds(sec).plusNanos(nsec);
                try {
                    if (fromutc) {
                        zone = UTC;
                        relativeOffset = false;
                        zoneToStore = this.nil();
                        break block10;
                    }
                    if (utcoffset == this.nil()) {
                        zone = envZone.getZone();
                        zoneToStore = envZone.getNameAsRubyObject(this.getContext());
                        relativeOffset = false;
                        break block10;
                    }
                    if (utcoffset instanceof Integer) {
                        zone = ZoneId.ofOffset("", ZoneOffset.ofTotalSeconds((Integer)utcoffset));
                        relativeOffset = true;
                        zoneToStore = this.nil();
                        break block10;
                    }
                    if (utcoffset instanceof Long) {
                        zone = ZoneId.ofOffset("", ZoneOffset.ofTotalSeconds((int)((Long)utcoffset).longValue()));
                        relativeOffset = true;
                        zoneToStore = this.nil();
                        break block10;
                    }
                    if (utcoffset instanceof DynamicObject) {
                        zone = ZoneId.ofOffset("", ZoneOffset.ofTotalSeconds(zoneOffsetMillis / 1000));
                        relativeOffset = true;
                        zoneToStore = this.nil();
                        break block10;
                    }
                    throw new UnsupportedOperationException(StringUtils.format("%s %s %s %s", isdst, fromutc, utcoffset, utcoffset.getClass()));
                }
                catch (DateTimeException e) {
                    throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), (Node)this));
                }
            }
            dt = dt.withZoneSameLocal(zone);
            if (isdst == 0) {
                dt = dt.withLaterOffsetAtOverlap();
            }
            if (isdst == 1) {
                dt = dt.withEarlierOffsetAtOverlap();
            }
            return this.allocateObjectNode.allocate(timeClass, Layouts.TIME.build(dt, zoneToStore, utcoffset, relativeOffset, fromutc));
        }

        private static int cast(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Long) {
                return (int)((Long)value).longValue();
            }
            throw new UnsupportedOperationException("Can't cast " + value.getClass());
        }
    }

    @Primitive(name="time_strftime")
    public static abstract class TimeStrftimePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(format)"})
        public DynamicObject timeStrftime(DynamicObject time, DynamicObject format) {
            RubyDateFormatter rdf = new RubyDateFormatter(this.getContext(), this);
            List<RubyDateFormatter.Token> pattern = rdf.compilePattern(StringOperations.rope(format), false);
            return this.createString(rdf.formatToByteList(pattern, Layouts.TIME.getDateTime(time)));
        }
    }

    @Primitive(name="time_decompose")
    public static abstract class TimeDecomposePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject timeDecompose(DynamicObject time) {
            Object zone;
            ZonedDateTime dateTime = Layouts.TIME.getDateTime(time);
            int sec = dateTime.getSecond();
            int min = dateTime.getMinute();
            int hour = dateTime.getHour();
            int day = dateTime.getDayOfMonth();
            int month = dateTime.getMonthValue();
            int year = dateTime.getYear();
            int wday = dateTime.getDayOfWeek().getValue();
            if (wday == 7) {
                wday = 0;
            }
            int yday = dateTime.getDayOfYear();
            boolean isdst = dateTime.getZone().getRules().isDaylightSavings(dateTime.toInstant());
            if (Layouts.TIME.getRelativeOffset(time)) {
                zone = this.nil();
            } else {
                Object timeZone = Layouts.TIME.getZone(time);
                if (timeZone == this.nil()) {
                    String zoneString = TimeZoneParser.getShortZoneName(dateTime, dateTime.getZone());
                    zone = this.createString(StringOperations.encodeRope(zoneString, (Encoding)UTF8Encoding.INSTANCE));
                } else {
                    zone = timeZone;
                }
            }
            Object[] decomposed = new Object[]{sec, min, hour, day, month, year, wday, yday, isdst, zone};
            return this.createArray(decomposed, decomposed.length);
        }
    }

    @Primitive(name="time_useconds")
    public static abstract class TimeUSecondsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public long timeUSeconds(DynamicObject time) {
            return Layouts.TIME.getDateTime(time).getNano() / 1000;
        }
    }

    @Primitive(name="time_seconds")
    public static abstract class TimeSecondsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public long timeSeconds(DynamicObject time) {
            return Layouts.TIME.getDateTime(time).toInstant().getEpochSecond();
        }
    }

    @Primitive(name="time_s_specific", lowerFixnum={2})
    public static abstract class TimeSSpecificPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization(guards={"isUTC"})
        public DynamicObject timeSSpecificUTC(DynamicObject timeClass, long seconds, int nanoseconds, boolean isUTC, Object offset) {
            return this.allocateObjectNode.allocate(timeClass, Layouts.TIME.build(this.getDateTime(seconds, nanoseconds, UTC), this.nil(), this.nil(), false, isUTC));
        }

        @Specialization(guards={"!isUTC", "isNil(offset)"})
        public DynamicObject timeSSpecific(VirtualFrame frame, DynamicObject timeClass, long seconds, int nanoseconds, boolean isUTC, Object offset) {
            TimeZoneAndName zoneName = this.getTimeZoneNode.executeGetTimeZone(frame);
            return this.allocateObjectNode.allocate(timeClass, Layouts.TIME.build(this.getDateTime(seconds, nanoseconds, zoneName.getZone()), this.nil(), offset, false, isUTC));
        }

        @Specialization(guards={"!isUTC"})
        public DynamicObject timeSSpecific(VirtualFrame frame, DynamicObject timeClass, long seconds, int nanoseconds, boolean isUTC, long offset) {
            ZoneId timeZone = ZoneId.ofOffset("", ZoneOffset.ofTotalSeconds((int)offset));
            return this.allocateObjectNode.allocate(timeClass, Layouts.TIME.build(this.getDateTime(seconds, nanoseconds, timeZone), this.nil(), this.nil(), false, isUTC));
        }

        @CompilerDirectives.TruffleBoundary
        private ZonedDateTime getDateTime(long seconds, int nanoseconds, ZoneId timeZone) {
            try {
                return ZonedDateTime.ofInstant(Instant.ofEpochSecond(seconds, nanoseconds), timeZone);
            }
            catch (DateTimeException e) {
                String message = StringUtils.format("UNIX epoch + %d seconds out of range for Time (java.time limitation)", seconds);
                throw new RaiseException(this.coreExceptions().rangeError(message, (Node)this));
            }
        }
    }

    @Primitive(name="time_s_now")
    public static abstract class TimeSNowPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();
        @Node.Child
        private GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();

        @Specialization
        public DynamicObject timeSNow(VirtualFrame frame, DynamicObject timeClass) {
            TimeZoneAndName zoneName = this.getTimeZoneNode.executeGetTimeZone(frame);
            return this.allocateObjectNode.allocate(timeClass, Layouts.TIME.build(this.now(zoneName.getZone()), this.nil(), this.nil(), false, false));
        }

        @CompilerDirectives.TruffleBoundary
        private ZonedDateTime now(ZoneId timeZone) {
            return ZonedDateTime.now(timeZone);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, Layouts.TIME.build(ZERO, this.coreLibrary().getNilObject(), 0, false, false));
        }
    }

    @CoreMethod(names={"internal_offset"})
    public static abstract class InternalOffsetCoreNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private InternalOffsetNode internalOffsetNode = TimeNodesFactory.InternalOffsetNodeFactory.create(null);

        @Specialization
        public Object allocate(DynamicObject time) {
            return this.internalOffsetNode.internalOffset(time);
        }
    }

    @CoreMethod(names={"gmt?"})
    public static abstract class GmtNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private InternalGMTNode internalGMTNode = TimeNodesFactory.InternalGMTNodeFactory.create(null);

        @Specialization
        public boolean allocate(DynamicObject time) {
            return this.internalGMTNode.internalGMT(time);
        }
    }

    @CoreMethod(names={"gmtime"})
    public static abstract class GmTimeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject localtime(DynamicObject time) {
            ZonedDateTime dateTime = Layouts.TIME.getDateTime(time);
            Layouts.TIME.setIsUtc(time, true);
            Layouts.TIME.setRelativeOffset(time, false);
            Layouts.TIME.setZone(time, this.create7BitString(this.getUTCDisplayName(), (Encoding)USASCIIEncoding.INSTANCE));
            Layouts.TIME.setDateTime(time, this.inUTC(dateTime));
            return time;
        }

        @CompilerDirectives.TruffleBoundary
        private String getUTCDisplayName() {
            return UTC.getDisplayName(TextStyle.NARROW, Locale.ENGLISH);
        }

        @CompilerDirectives.TruffleBoundary
        private ZonedDateTime inUTC(ZonedDateTime dateTime) {
            return dateTime.withZoneSameInstant(UTC);
        }
    }

    @CoreMethod(names={"dup_internal"}, required=1, visibility=Visibility.PROTECTED)
    public static abstract class DupInternalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject dup(DynamicObject time, DynamicObject klass) {
            return this.allocateObjectNode.allocate(klass, Layouts.TIME.build(Layouts.TIME.getDateTime(time), Layouts.TIME.getZone(time), Layouts.TIME.getOffset(time), Layouts.TIME.getRelativeOffset(time), Layouts.TIME.getIsUtc(time)));
        }
    }

    @CoreMethod(names={"add_internal!"}, required=2, visibility=Visibility.PROTECTED)
    public static abstract class AddInternalNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject addInternal(DynamicObject time, long seconds, long nanoSeconds) {
            ZonedDateTime dateTime = Layouts.TIME.getDateTime(time);
            Layouts.TIME.setDateTime(time, dateTime.plusSeconds(seconds).plusNanos(nanoSeconds));
            return time;
        }
    }

    @CoreMethod(names={"localtime_internal"}, optional=1)
    public static abstract class LocalTimeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GetTimeZoneNode getTimeZoneNode = GetTimeZoneNodeGen.create();

        @Specialization
        public DynamicObject localtime(VirtualFrame frame, DynamicObject time, NotProvided offset) {
            TimeZoneAndName timeZoneAndName = this.getTimeZoneNode.executeGetTimeZone(frame);
            ZoneId dateTimeZone = timeZoneAndName.getZone();
            String shortZoneName = TimeZoneParser.getShortZoneName(time, dateTimeZone);
            DynamicObject zone = this.createString(StringOperations.encodeRope(shortZoneName, (Encoding)UTF8Encoding.INSTANCE));
            ZonedDateTime dateTime = Layouts.TIME.getDateTime(time);
            Layouts.TIME.setIsUtc(time, false);
            Layouts.TIME.setRelativeOffset(time, false);
            Layouts.TIME.setZone(time, zone);
            Layouts.TIME.setDateTime(time, this.withZone(dateTime, dateTimeZone));
            return time;
        }

        @Specialization
        public DynamicObject localtime(DynamicObject time, long offset) {
            ZonedDateTime dateTime = Layouts.TIME.getDateTime(time);
            ZoneId zone = this.getDateTimeZone((int)offset);
            Layouts.TIME.setIsUtc(time, false);
            Layouts.TIME.setRelativeOffset(time, true);
            Layouts.TIME.setZone(time, this.nil());
            Layouts.TIME.setDateTime(time, this.withZone(dateTime, zone));
            return time;
        }

        @CompilerDirectives.TruffleBoundary
        public ZoneId getDateTimeZone(int offset) {
            try {
                return ZoneId.ofOffset("", ZoneOffset.ofTotalSeconds(offset));
            }
            catch (DateTimeException e) {
                throw new RaiseException(this.getContext().getCoreExceptions().argumentError(e.getMessage(), (Node)this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private ZonedDateTime withZone(ZonedDateTime dateTime, ZoneId zone) {
            return dateTime.withZoneSameInstant(zone);
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class InternalOffsetNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object internalOffset(DynamicObject time) {
            Object offset = Layouts.TIME.getOffset(time);
            if (offset == this.nil()) {
                ZonedDateTime dateTime = Layouts.TIME.getDateTime(time);
                return dateTime.getOffset().getTotalSeconds();
            }
            return offset;
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class InternalGMTNode
    extends CoreMethodNode {
        @Specialization
        public boolean internalGMT(DynamicObject time) {
            return Layouts.TIME.getIsUtc(time);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyTime(from)"})
        public Object initializeCopy(DynamicObject self, DynamicObject from) {
            Layouts.TIME.setDateTime(self, Layouts.TIME.getDateTime(from));
            Layouts.TIME.setOffset(self, Layouts.TIME.getOffset(from));
            Layouts.TIME.setRelativeOffset(self, Layouts.TIME.getRelativeOffset(from));
            return self;
        }
    }
}

