/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;

@NodeChildren(value={@NodeChild(value="key"), @NodeChild(value="compareByIdentity")})
public abstract class FreezeHashKeyIfNeededNode
extends RubyNode {
    @Node.Child
    private IsFrozenNode isFrozenNode;
    @Node.Child
    private CallDispatchHeadNode dupNode;
    @Node.Child
    private CallDispatchHeadNode freezeNode;

    public abstract Object executeFreezeIfNeeded(VirtualFrame var1, Object var2, boolean var3);

    @Specialization(guards={"isRubyString(string)", "isFrozen(string)"})
    Object alreadyFrozen(DynamicObject string, boolean compareByIdentity) {
        return string;
    }

    @Specialization(guards={"isRubyString(string)", "!isFrozen(string)", "!compareByIdentity"})
    Object dupAndFreeze(VirtualFrame frame, DynamicObject string, boolean compareByIdentity) {
        return this.freeze(frame, this.dup(frame, string));
    }

    @Specialization(guards={"isRubyString(string)", "!isFrozen(string)", "compareByIdentity"})
    Object compareByIdentity(VirtualFrame frame, DynamicObject string, boolean compareByIdentity) {
        return string;
    }

    @Specialization(guards={"!isRubyString(value)"})
    Object passThrough(Object value, boolean compareByIdentity) {
        return value;
    }

    protected boolean isFrozen(Object value) {
        if (this.isFrozenNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(null));
        }
        return this.isFrozenNode.executeIsFrozen(value);
    }

    private Object dup(VirtualFrame frame, Object value) {
        if (this.dupNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.dupNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall());
        }
        return this.dupNode.call(frame, value, "dup", new Object[0]);
    }

    private Object freeze(VirtualFrame frame, Object value) {
        if (this.freezeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.freezeNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall());
        }
        return this.freezeNode.call(frame, value, "freeze", new Object[0]);
    }
}

