/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;

public class RaiseIfFrozenNode
extends RubyNode {
    private final BranchProfile errorProfile = BranchProfile.create();
    @Node.Child
    private RubyNode child;
    @Node.Child
    private IsFrozenNode isFrozenNode = IsFrozenNodeGen.create(null);

    public RaiseIfFrozenNode(RubyNode child) {
        this.child = child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result = this.child.execute(frame);
        if (this.isFrozenNode.executeIsFrozen(result)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().frozenError(result, this));
        }
        return result;
    }
}

