/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.scope;

import org.jruby.EvalType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.parser.scope.DummyDynamicScope;
import org.jruby.truffle.parser.scope.FourVarDynamicScope;
import org.jruby.truffle.parser.scope.ManyVarsDynamicScope;
import org.jruby.truffle.parser.scope.NoVarsDynamicScope;
import org.jruby.truffle.parser.scope.OneVarDynamicScope;
import org.jruby.truffle.parser.scope.StaticScope;
import org.jruby.truffle.parser.scope.ThreeVarDynamicScope;
import org.jruby.truffle.parser.scope.TwoVarDynamicScope;

public abstract class DynamicScope {
    protected final StaticScope staticScope;
    protected final DynamicScope parent;
    private EvalType evalType;
    private boolean lambda;

    protected DynamicScope(StaticScope staticScope, DynamicScope parent) {
        this.staticScope = staticScope;
        this.parent = parent;
        this.evalType = EvalType.NONE;
    }

    protected DynamicScope(StaticScope staticScope) {
        this(staticScope, null);
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope, DynamicScope parent) {
        switch (staticScope.getNumberOfVariables()) {
            case 0: {
                return new NoVarsDynamicScope(staticScope, parent);
            }
            case 1: {
                return new OneVarDynamicScope(staticScope, parent);
            }
            case 2: {
                return new TwoVarDynamicScope(staticScope, parent);
            }
            case 3: {
                return new ThreeVarDynamicScope(staticScope, parent);
            }
            case 4: {
                return new FourVarDynamicScope(staticScope, parent);
            }
        }
        return new ManyVarsDynamicScope(staticScope, parent);
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope, DynamicScope parent, EvalType evalType) {
        DynamicScope newScope = DynamicScope.newDynamicScope(staticScope, parent);
        newScope.setEvalType(evalType);
        return newScope;
    }

    public static DynamicScope newDummyScope(StaticScope staticScope, DynamicScope parent) {
        return new DummyDynamicScope(staticScope, parent);
    }

    public final DynamicScope getParentScope() {
        return this.parent;
    }

    @Deprecated
    public DynamicScope getNextCapturedScope() {
        return this.getParentScope();
    }

    public DynamicScope getNthParentScope(int n) {
        DynamicScope scope = this;
        for (int i = 0; i < n && scope != null; scope = scope.getParentScope(), ++i) {
        }
        return scope;
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope) {
        return DynamicScope.newDynamicScope(staticScope, null);
    }

    public DynamicScope getFlipScope() {
        if (this.staticScope.getLocalScope() == this.staticScope) {
            return this;
        }
        return this.parent.getFlipScope();
    }

    public final StaticScope getStaticScope() {
        return this.staticScope;
    }

    public final String[] getAllNamesInScope() {
        return this.staticScope.getAllNamesInScope();
    }

    public abstract void growIfNeeded();

    public abstract DynamicScope cloneScope();

    public abstract IRubyObject[] getValues();

    public abstract IRubyObject getValue(int var1, int var2);

    public abstract IRubyObject getValueOrNil(int var1, int var2, IRubyObject var3);

    public abstract IRubyObject getValueDepthZeroOrNil(int var1, IRubyObject var2);

    public abstract IRubyObject getValueZeroDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueOneDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueTwoDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueThreeDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject setValue(int var1, IRubyObject var2, int var3);

    public IRubyObject setValue(IRubyObject value, int offset, int depth) {
        return this.setValue(offset, value, depth);
    }

    public void setValueVoid(IRubyObject value, int offset, int depth) {
        this.setValue(offset, value, depth);
    }

    public abstract IRubyObject setValueDepthZero(IRubyObject var1, int var2);

    public void setValueDepthZeroVoid(IRubyObject value, int offset) {
        this.setValueDepthZero(value, offset);
    }

    public abstract IRubyObject setValueZeroDepthZero(IRubyObject var1);

    public void setValueZeroDepthZeroVoid(IRubyObject value) {
        this.setValueZeroDepthZero(value);
    }

    public abstract IRubyObject setValueOneDepthZero(IRubyObject var1);

    public void setValueOneDepthZeroVoid(IRubyObject value) {
        this.setValueOneDepthZero(value);
    }

    public abstract IRubyObject setValueTwoDepthZero(IRubyObject var1);

    public void setValueTwoDepthZeroVoid(IRubyObject value) {
        this.setValueTwoDepthZero(value);
    }

    public abstract IRubyObject setValueThreeDepthZero(IRubyObject var1);

    public void setValueThreeDepthZeroVoid(IRubyObject value) {
        this.setValueThreeDepthZero(value);
    }

    public String toString() {
        return this.toString(new StringBuffer(), "");
    }

    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope.isBlockScope() ? "block" : "local") + " [");
        int size = this.staticScope.getNumberOfVariables();
        IRubyObject[] variableValues = this.getValues();
        if (size != 0) {
            String[] names = this.staticScope.getVariables();
            for (int i = 0; i < size - 1; ++i) {
                buf.append(names[i]).append("=");
                if (variableValues[i] == null) {
                    buf.append("null");
                } else {
                    buf.append(variableValues[i]);
                }
                buf.append(",");
            }
            buf.append(names[size - 1]).append("=");
            assert (variableValues.length == names.length) : "V: " + variableValues.length + " != N: " + names.length + " for " + buf;
            if (variableValues[size - 1] == null) {
                buf.append("null");
            } else {
                buf.append(variableValues[size - 1]);
            }
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }

    public boolean inInstanceEval() {
        return this.evalType == EvalType.INSTANCE_EVAL;
    }

    public boolean inModuleEval() {
        return this.evalType == EvalType.MODULE_EVAL;
    }

    public boolean inBindingEval() {
        return this.evalType == EvalType.BINDING_EVAL;
    }

    public void setEvalType(EvalType evalType) {
        this.evalType = evalType == null ? EvalType.NONE : evalType;
    }

    public EvalType getEvalType() {
        return this.evalType;
    }

    public void clearEvalType() {
        this.evalType = EvalType.NONE;
    }

    public void setLambda(boolean lambda) {
        this.lambda = lambda;
    }

    public boolean isLambda() {
        return this.lambda;
    }
}

