/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.dispatch.CachedDispatchNode;
import org.jruby.truffle.language.dispatch.DispatchAction;
import org.jruby.truffle.language.dispatch.DispatchNode;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.objects.MetaClassNode;
import org.jruby.truffle.language.objects.MetaClassNodeGen;

public class CachedMethodMissingDispatchNode
extends CachedDispatchNode {
    private final DynamicObject expectedClass;
    private final Assumption unmodifiedAssumption;
    private final InternalMethod method;
    @Node.Child
    private MetaClassNode metaClassNode;
    @Node.Child
    private DirectCallNode callNode;

    public CachedMethodMissingDispatchNode(RubyContext context, Object cachedName, DispatchNode next, DynamicObject expectedClass, InternalMethod method, DispatchAction dispatchAction) {
        super(context, cachedName, next, dispatchAction);
        this.expectedClass = expectedClass;
        this.unmodifiedAssumption = Layouts.MODULE.getFields(expectedClass).getUnmodifiedAssumption();
        this.method = method;
        this.metaClassNode = MetaClassNodeGen.create(context, null, null);
        this.callNode = Truffle.getRuntime().createDirectCallNode(method.getCallTarget());
        if (this.callNode.isCallTargetCloningAllowed() && (this.getContext().getOptions().METHODMISSING_ALWAYS_CLONE || method.getSharedMethodInfo().shouldAlwaysClone())) {
            this.insert((Node)this.callNode);
            this.callNode.cloneCallTarget();
        }
        if (this.callNode.isInlinable() && this.getContext().getOptions().METHODMISSING_ALWAYS_INLINE) {
            this.insert((Node)this.callNode);
            this.callNode.forceInlining();
        }
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return this.guardName(methodName) && this.metaClassNode.executeMetaClass(receiver) == this.expectedClass;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object[] argumentsObjects) {
        try {
            this.unmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects, "class modified");
        }
        if (!this.guard(methodName, receiverObject)) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                Object[] modifiedArgumentsObjects = ArrayUtils.unshift(argumentsObjects, this.getCachedNameAsSymbol());
                return CachedMethodMissingDispatchNode.call(this.callNode, frame, this.method, receiverObject, blockObject, modifiedArgumentsObjects);
            }
            case RESPOND_TO_METHOD: {
                return false;
            }
        }
        throw new UnsupportedOperationException();
    }
}

