/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.printf;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatEncoding;
import org.jruby.truffle.core.format.FormatRootNode;
import org.jruby.truffle.core.format.printf.PrintfSimpleParser;
import org.jruby.truffle.core.format.printf.PrintfSimpleTreeBuilder;
import org.jruby.truffle.core.format.printf.SprintfConfig;
import org.jruby.truffle.language.RubyNode;

public class PrintfCompiler {
    private final RubyContext context;
    private final RubyNode currentNode;

    public PrintfCompiler(RubyContext context, RubyNode currentNode) {
        this.context = context;
        this.currentNode = currentNode;
    }

    public CallTarget compile(byte[] format) {
        PrintfSimpleParser parser = new PrintfSimpleParser(PrintfCompiler.bytesToChars(format));
        List<SprintfConfig> configs = parser.parse();
        PrintfSimpleTreeBuilder builder = new PrintfSimpleTreeBuilder(this.context, configs);
        return Truffle.getRuntime().createCallTarget((RootNode)new FormatRootNode(this.currentNode.getEncapsulatingSourceSection(), FormatEncoding.DEFAULT, builder.getNode()));
    }

    private static char[] bytesToChars(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int n = 0; n < bytes.length; ++n) {
            chars[n] = (char)bytes[n];
        }
        return chars;
    }
}

