/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;

public class ReadInstanceVariableNode
extends RubyNode {
    private final String name;
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private ReadObjectFieldNode readNode;
    @Node.Child
    private ReadObjectFieldNode readOrNullNode;
    private final ConditionProfile objectProfile = ConditionProfile.createBinaryProfile();

    public ReadInstanceVariableNode(RubyContext context, SourceSection sourceSection, String name, RubyNode receiver) {
        super(context, sourceSection);
        this.name = name;
        this.receiver = receiver;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object receiverObject = this.receiver.execute(frame);
        if (this.objectProfile.profile(receiverObject instanceof DynamicObject)) {
            return this.getReadNode().execute((DynamicObject)receiverObject);
        }
        return this.nil();
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object receiverObject = this.receiver.execute(frame);
        if (this.objectProfile.profile(receiverObject instanceof DynamicObject)) {
            if (this.getReadOrNullNode().execute((DynamicObject)receiverObject) == null) {
                return this.nil();
            }
            return this.coreStrings().INSTANCE_VARIABLE.createInstance();
        }
        return false;
    }

    private ReadObjectFieldNode getReadNode() {
        if (this.readNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readNode = (ReadObjectFieldNode)this.insert(ReadObjectFieldNodeGen.create(this.name, this.nil()));
        }
        return this.readNode;
    }

    private ReadObjectFieldNode getReadOrNullNode() {
        if (this.readOrNullNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readOrNullNode = (ReadObjectFieldNode)this.insert(ReadObjectFieldNodeGen.create(this.name, null));
        }
        return this.readOrNullNode;
    }
}

