/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.convert.ToIntegerNode;
import org.jruby.truffle.core.format.convert.ToIntegerNodeGen;
import org.jruby.truffle.core.format.read.SourceNode;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadIntegerNode
extends FormatNode {
    @Node.Child
    private ToIntegerNode toIntegerNode;
    private final ConditionProfile convertedTypeProfile = ConditionProfile.createBinaryProfile();

    public ReadIntegerNode(RubyContext context) {
        super(context);
    }

    @Specialization(guards={"isNull(source)"})
    public double read(VirtualFrame frame, Object source) {
        this.advanceSourcePosition(frame);
        throw new IllegalStateException();
    }

    @Specialization
    public int read(VirtualFrame frame, int[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public int read(VirtualFrame frame, long[] source) {
        return (int)source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public int read(VirtualFrame frame, double[] source) {
        return (int)source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public int read(VirtualFrame frame, Object[] source) {
        Object value;
        if (this.toIntegerNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toIntegerNode = (ToIntegerNode)this.insert(ToIntegerNodeGen.create(this.getContext(), null));
        }
        if (this.convertedTypeProfile.profile((value = this.toIntegerNode.executeToInteger(frame, source[this.advanceSourcePosition(frame)])) instanceof Long)) {
            return (int)((Long)value).longValue();
        }
        return (Integer)value;
    }
}

