/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.cast.IntegerCastNode;
import org.jruby.truffle.core.cast.IntegerCastNodeGen;
import org.jruby.truffle.core.kernel.AtExitManager;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.ExitException;
import org.jruby.truffle.language.control.RaiseException;

public class TopLevelRaiseHandler
extends RubyNode {
    @Node.Child
    private RubyNode body;
    @Node.Child
    private IntegerCastNode integerCastNode;

    public TopLevelRaiseHandler(RubyContext context, SourceSection sourceSection, RubyNode body) {
        super(context, sourceSection);
        this.body = body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject lastException = null;
        try {
            this.body.execute(frame);
        }
        catch (RaiseException e) {
            lastException = AtExitManager.handleAtExitException(this.getContext(), e);
            return lastException;
        }
        finally {
            DynamicObject atExitException = this.getContext().getAtExitManager().runAtExitHooks();
            if (atExitException != null) {
                lastException = atExitException;
            }
            throw new ExitException(this.statusFromException(lastException));
        }
    }

    private int statusFromException(DynamicObject exception) {
        if (exception == null) {
            return 0;
        }
        if (Layouts.BASIC_OBJECT.getLogicalClass(exception) == this.coreLibrary().getSystemExitClass()) {
            return this.castToInt(exception.get((Object)"@status", null));
        }
        return 1;
    }

    private int castToInt(Object value) {
        if (this.integerCastNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.integerCastNode = (IntegerCastNode)this.insert(IntegerCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        return this.integerCastNode.executeCastInt(value);
    }
}

