/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.interop.ForeignReadNodeSubNodeGen;
import org.jruby.truffle.interop.RubyMessageResolution;

abstract class ForeignReadNodeSub
extends RubyMessageResolution.ForeignReadNode {
    ForeignReadNodeSub() {
    }

    public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3);

    @Specialization
    protected Object accessWithTarget(VirtualFrame frame, DynamicObject object, Object name) {
        return this.access(frame, object, name);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new ReadRootNode(language);
    }

    private static final class ReadRootNode
    extends RootNode {
        @Node.Child
        private ForeignReadNodeSub node = ForeignReadNodeSubNodeGen.create();

        protected ReadRootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        public Object execute(VirtualFrame frame) {
            TruffleObject receiver = ForeignAccess.getReceiver((Frame)frame);
            Object identifier = ForeignAccess.getArguments((Frame)frame).get(0);
            try {
                return this.node.executeWithTarget(frame, receiver, identifier);
            }
            catch (UnsupportedSpecializationException e) {
                throw UnsupportedTypeException.raise((Object[])e.getSuppliedValues());
            }
        }
    }
}

