/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.rubinius.WeakRefLayout;

@GeneratedBy(value=WeakRefLayout.class)
public class WeakRefLayoutImpl
extends BasicObjectLayoutImpl
implements WeakRefLayout {
    public static final WeakRefLayout INSTANCE = new WeakRefLayoutImpl();
    protected static final Shape.Allocator WEAK_REF_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey REFERENCE_IDENTIFIER = new HiddenKey("reference");
    protected static final Property REFERENCE_PROPERTY = Property.create((Object)REFERENCE_IDENTIFIER, (Location)WEAK_REF_ALLOCATOR.locationForType(WeakReference.class, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected WeakRefLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createWeakRefShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new WeakRefType(logicalClass, metaClass)).addProperty(REFERENCE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createWeakRef(DynamicObjectFactory factory, WeakReference<Object> reference) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (WeakRefLayoutImpl.createsWeakRef(factory));
        assert (factory.getShape().hasProperty((Object)REFERENCE_IDENTIFIER));
        assert (reference != null);
        return factory.newInstance(new Object[]{reference});
    }

    private static boolean isWeakRef(DynamicObject object) {
        return WeakRefLayoutImpl.isWeakRef(object.getShape().getObjectType());
    }

    private static boolean isWeakRef(ObjectType objectType) {
        return objectType instanceof WeakRefType;
    }

    private static boolean createsWeakRef(DynamicObjectFactory factory) {
        return WeakRefLayoutImpl.isWeakRef(factory.getShape().getObjectType());
    }

    @Override
    public WeakReference<Object> getReference(DynamicObject object) {
        assert (WeakRefLayoutImpl.isWeakRef(object));
        assert (object.getShape().hasProperty((Object)REFERENCE_IDENTIFIER));
        return (WeakReference)REFERENCE_PROPERTY.get(object, WeakRefLayoutImpl.isWeakRef(object));
    }

    @Override
    public void setReference(DynamicObject object, WeakReference<Object> value) {
        assert (WeakRefLayoutImpl.isWeakRef(object));
        assert (object.getShape().hasProperty((Object)REFERENCE_IDENTIFIER));
        assert (value != null);
        try {
            REFERENCE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class WeakRefType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public WeakRefType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public WeakRefType setLogicalClass(DynamicObject logicalClass) {
            return new WeakRefType(logicalClass, this.metaClass);
        }

        @Override
        public WeakRefType setMetaClass(DynamicObject metaClass) {
            return new WeakRefType(this.logicalClass, metaClass);
        }
    }
}

