/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

public class ReturnEnumeratorIfNoBlockNode
extends RubyNode {
    @Node.Child
    private RubyNode method;
    @Node.Child
    private CallDispatchHeadNode toEnumNode;
    private final DynamicObject methodSymbol;
    private final ConditionProfile noBlockProfile = ConditionProfile.createBinaryProfile();

    public ReturnEnumeratorIfNoBlockNode(String methodName, RubyNode method) {
        super(method.getContext(), method.getEncapsulatingSourceSection());
        this.method = method;
        this.methodSymbol = this.getSymbol(methodName);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject block = RubyArguments.getBlock((Frame)frame);
        if (this.noBlockProfile.profile(block == null)) {
            if (this.toEnumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toEnumNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object[] arguments = ArrayUtils.unshift(RubyArguments.getArguments((Frame)frame), this.methodSymbol);
            return this.toEnumNode.call(frame, RubyArguments.getSelf((Frame)frame), "to_enum", null, arguments);
        }
        return this.method.execute(frame);
    }
}

