/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongArray;
import org.jruby.truffle.RubyContext;

public class CoverageManager {
    public static final long NO_CODE = -1L;
    private final Instrumenter instrumenter;
    private final Map<Source, AtomicLongArray> counters = new ConcurrentHashMap<Source, AtomicLongArray>();
    private final Map<Source, BitSet> linesHaveCode = new HashMap<Source, BitSet>();
    private boolean enabled;

    public CoverageManager(RubyContext context, Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
        if (context.getOptions().COVERAGE_GLOBAL) {
            this.enable();
        }
    }

    public synchronized void setLineHasCode(LineLocation line) {
        BitSet bitmap = this.linesHaveCode.get(line.getSource());
        if (bitmap == null) {
            bitmap = new BitSet(line.getSource().getLineCount());
            this.linesHaveCode.put(line.getSource(), bitmap);
        }
        bitmap.set(line.getLineNumber() - 1);
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void enable() {
        if (this.enabled) {
            return;
        }
        this.instrumenter.attachFactory(SourceSectionFilter.newBuilder().tagIs(new Class[]{LineTag.class}).build(), new ExecutionEventNodeFactory(){

            public ExecutionEventNode create(EventContext eventContext) {
                return new ExecutionEventNode(){
                    @CompilerDirectives.CompilationFinal
                    private AtomicLongArray counters;
                    @CompilerDirectives.CompilationFinal
                    private int lineNumber;

                    protected void onEnter(VirtualFrame frame) {
                        if (this.counters == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            SourceSection sourceSection = this.getEncapsulatingSourceSection();
                            this.counters = CoverageManager.this.getCounters(sourceSection.getSource());
                            this.lineNumber = sourceSection.getStartLine() - 1;
                        }
                        this.counters.incrementAndGet(this.lineNumber);
                    }
                };
            }
        });
        this.enabled = true;
    }

    private synchronized AtomicLongArray getCounters(Source source) {
        AtomicLongArray c = this.counters.get(source);
        if (c == null) {
            c = new AtomicLongArray(source.getLineCount());
            this.counters.put(source, c);
        }
        return c;
    }

    public Map<Source, long[]> getCounts() {
        HashMap<Source, long[]> counts = new HashMap<Source, long[]>();
        for (Map.Entry<Source, AtomicLongArray> entry : this.counters.entrySet()) {
            BitSet hasCode = this.linesHaveCode.get(entry.getKey());
            long[] array = new long[entry.getValue().length()];
            for (int n = 0; n < array.length; ++n) {
                array[n] = hasCode != null && hasCode.get(n) ? entry.getValue().get(n) : -1L;
            }
            counts.put(entry.getKey(), array);
        }
        return counts;
    }

    public void print(PrintStream out) {
        int maxCountDigits = Long.toString(this.getMaxCount()).length();
        String countFormat = "%" + maxCountDigits + "d";
        char[] noCodeChars = new char[maxCountDigits];
        Arrays.fill(noCodeChars, ' ');
        noCodeChars[maxCountDigits - 1] = 45;
        String noCodeString = new String(noCodeChars);
        for (Map.Entry<Source, AtomicLongArray> entry : this.counters.entrySet()) {
            BitSet hasCode = this.linesHaveCode.get(entry.getKey());
            out.println(entry.getKey().getName());
            for (int n = 0; n < entry.getValue().length(); ++n) {
                String line = entry.getKey().getCode(n + 1);
                if (line.length() > 60) {
                    line = line.substring(0, 60);
                }
                out.print("  ");
                if (hasCode != null && hasCode.get(n)) {
                    out.printf(countFormat, entry.getValue().get(n));
                } else {
                    out.print(noCodeString);
                }
                out.printf("  %s%n", line);
            }
        }
    }

    private long getMaxCount() {
        long max = 0L;
        for (Map.Entry<Source, AtomicLongArray> entry : this.counters.entrySet()) {
            for (int n = 0; n < entry.getValue().length(); ++n) {
                max = Math.max(max, entry.getValue().get(n));
            }
        }
        return max;
    }

    public class LineTag {
    }
}

