/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.DispatchAction;
import org.jruby.truffle.language.dispatch.DispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchNode;
import org.jruby.truffle.language.dispatch.MissingBehavior;

public class CallDispatchHeadNode
extends DispatchHeadNode {
    @Node.Child
    private BooleanCastNode booleanCastNode;

    public static CallDispatchHeadNode createMethodCall() {
        return new CallDispatchHeadNode(null, false, MissingBehavior.CALL_METHOD_MISSING);
    }

    public CallDispatchHeadNode(RubyContext context, boolean ignoreVisibility, MissingBehavior missingBehavior) {
        super(context, ignoreVisibility, missingBehavior, DispatchAction.CALL_METHOD);
    }

    public Object call(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object ... argumentsObjects) {
        return this.dispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
    }

    public boolean callBoolean(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object ... argumentsObjects) {
        if (this.booleanCastNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.context, this.getSourceSection(), null));
        }
        return this.booleanCastNode.executeBoolean(frame, this.dispatch(frame, receiverObject, methodName, blockObject, argumentsObjects));
    }

    public double callFloat(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object ... argumentsObjects) {
        Object value = this.call(frame, receiverObject, methodName, blockObject, argumentsObjects);
        if (value instanceof Double) {
            return (Double)value;
        }
        CompilerDirectives.transferToInterpreter();
        if (value == DispatchNode.MISSING) {
            throw new RaiseException(this.context.getCoreExceptions().typeErrorCantConvertInto(receiverObject, "Float", this));
        }
        throw new RaiseException(this.context.getCoreExceptions().typeErrorCantConvertTo(receiverObject, "Float", (String)methodName, value, this));
    }

    public long callLongFixnum(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object ... argumentsObjects) {
        Object value = this.call(frame, receiverObject, methodName, blockObject, argumentsObjects);
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        CompilerDirectives.transferToInterpreter();
        if (value == DispatchNode.MISSING) {
            throw new RaiseException(this.context.getCoreExceptions().typeErrorCantConvertInto(receiverObject, "Fixnum", this));
        }
        throw new RaiseException(this.context.getCoreExceptions().typeErrorCantConvertTo(receiverObject, "Fixnum", (String)methodName, value, this));
    }
}

