/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.array.ArrayReadNormalizedNode;
import org.jruby.truffle.core.array.ArrayReadNormalizedNodeGen;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.ReadRestArgumentNode;
import org.jruby.truffle.language.arguments.ReadUserKeywordsHashNode;
import org.jruby.truffle.language.arguments.RubyArguments;

public class ReadOptionalArgumentNode
extends RubyNode {
    private final int index;
    private final int minimum;
    private final boolean considerRejectedKWArgs;
    private final boolean reduceMinimumWhenNoKWargs;
    @Node.Child
    private ReadRestArgumentNode readRestArgumentNode;
    @Node.Child
    private RubyNode defaultValue;
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;
    @Node.Child
    private ArrayReadNormalizedNode arrayReadNode;
    private final BranchProfile defaultValueProfile = BranchProfile.create();

    public ReadOptionalArgumentNode(RubyContext context, SourceSection sourceSection, int index, int minimum, boolean considerRejectedKWArgs, boolean reduceMinimumWhenNoKWargs, int requiredForKWArgs, ReadRestArgumentNode readRestArgumentNode, RubyNode defaultValue) {
        super(context, sourceSection);
        this.index = index;
        this.minimum = minimum;
        this.considerRejectedKWArgs = considerRejectedKWArgs;
        this.defaultValue = defaultValue;
        this.readRestArgumentNode = readRestArgumentNode;
        this.reduceMinimumWhenNoKWargs = reduceMinimumWhenNoKWargs;
        if (reduceMinimumWhenNoKWargs) {
            this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode(requiredForKWArgs);
        }
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int effectiveMinimum = this.minimum;
        if (this.reduceMinimumWhenNoKWargs && this.readUserKeywordsHashNode.execute(frame) == null) {
            --effectiveMinimum;
        }
        if (RubyArguments.getArgumentsCount((Frame)frame) >= effectiveMinimum) {
            return RubyArguments.getArgument((Frame)frame, this.index);
        }
        this.defaultValueProfile.enter();
        if (this.considerRejectedKWArgs) {
            CompilerDirectives.bailout((String)"Ruby keyword arguments aren't optimized");
            Object rest = this.readRestArgumentNode.execute(frame);
            if (RubyGuards.isRubyArray(rest) && Layouts.ARRAY.getSize((DynamicObject)rest) > 0) {
                if (this.arrayReadNode == null) {
                    this.arrayReadNode = (ArrayReadNormalizedNode)this.insert(ArrayReadNormalizedNodeGen.create(this.getContext(), null, null, null));
                }
                return this.arrayReadNode.executeRead((DynamicObject)rest, 0);
            }
        }
        return this.defaultValue.execute(frame);
    }
}

