/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.interop.ToJavaStringNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=ToJavaStringNode.class)
public final class ToJavaStringNodeGen
extends ToJavaStringNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeStringUncached_;
    @Node.Child
    private BaseNode_ specialization_;

    private ToJavaStringNodeGen(RubyContext context, SourceSection sourceSection, RubyNode value) {
        super(context, sourceSection);
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public String executeToJavaString(VirtualFrame frameValue, Object valueValue) {
        return this.specialization_.executeString(frameValue, valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ToJavaStringNode create(RubyContext context, SourceSection sourceSection, RubyNode value) {
        return new ToJavaStringNodeGen(context, sourceSection, value);
    }

    @GeneratedBy(methodName="javaString(String)", value=ToJavaStringNode.class)
    private static final class JavaStringNode_
    extends BaseNode_ {
        JavaStringNode_(ToJavaStringNodeGen root) {
            super(root, 4);
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof String) {
                String valueValue_ = (String)valueValue;
                return this.root.javaString(valueValue_);
            }
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(ToJavaStringNodeGen root) {
            return new JavaStringNode_(root);
        }
    }

    @GeneratedBy(methodName="symbol(DynamicObject)", value=ToJavaStringNode.class)
    private static final class SymbolNode_
    extends BaseNode_ {
        SymbolNode_(ToJavaStringNodeGen root) {
            super(root, 3);
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubySymbol(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.symbol(valueValue_);
            }
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(ToJavaStringNodeGen root) {
            return new SymbolNode_(root);
        }
    }

    @GeneratedBy(methodName="stringCached(DynamicObject)", value=ToJavaStringNode.class)
    private static final class StringCachedNode_
    extends BaseNode_ {
        StringCachedNode_(ToJavaStringNodeGen root) {
            super(root, 2);
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyString(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.stringCached(valueValue_);
            }
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(ToJavaStringNodeGen root) {
            return new StringCachedNode_(root);
        }
    }

    @GeneratedBy(methodName="stringUncached(DynamicObject, Rope, String)", value=ToJavaStringNode.class)
    private static final class StringUncachedNode_
    extends BaseNode_ {
        private final Rope cachedRope;
        private final String convertedString;

        StringUncachedNode_(ToJavaStringNodeGen root, Rope cachedRope, String convertedString) {
            super(root, 1);
            this.cachedRope = cachedRope;
            this.convertedString = convertedString;
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            if (newNode.getClass() == StringCachedNode_.class) {
                this.removeSame("Contained by stringCached(DynamicObject)");
            }
            return super.merge(newNode, frameValue, valueValue);
        }

        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            return valueValue instanceof DynamicObject && RubyGuards.isRubyString(valueValue_ = (DynamicObject)valueValue) && StringCachingGuards.ropesEqual(valueValue_, this.cachedRope);
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyString(valueValue_ = (DynamicObject)valueValue) && StringCachingGuards.ropesEqual(valueValue_, this.cachedRope)) {
                return this.root.stringUncached(valueValue_, this.cachedRope, this.convertedString);
            }
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(ToJavaStringNodeGen root, Rope cachedRope, String convertedString) {
            return new StringUncachedNode_(root, cachedRope, convertedString);
        }
    }

    @GeneratedBy(value=ToJavaStringNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ToJavaStringNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(ToJavaStringNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ToJavaStringNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ToJavaStringNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            return (String)this.uninitialized((Frame)frameValue, valueValue);
        }

        static BaseNode_ create(ToJavaStringNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ToJavaStringNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ToJavaStringNodeGen root;

        BaseNode_(ToJavaStringNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ToJavaStringNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.executeString((VirtualFrame)frameValue, valueValue);
        }

        public abstract String executeString(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.executeString(frameValue, valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            if (valueValue instanceof DynamicObject) {
                String convertedString1;
                BaseNode_ s;
                DynamicObject valueValue_ = (DynamicObject)valueValue;
                Rope cachedRope1 = StringCachingGuards.privatizeRope(valueValue_);
                if (RubyGuards.isRubyString(valueValue_) && StringCachingGuards.ropesEqual(valueValue_, cachedRope1) && !this.root.excludeStringUncached_ && this.countSame(s = StringUncachedNode_.create(this.root, cachedRope1, convertedString1 = valueValue_.toString())) < this.root.getLimit()) {
                    return s;
                }
                if (RubyGuards.isRubyString(valueValue_)) {
                    this.root.excludeStringUncached_ = true;
                    return StringCachedNode_.create(this.root);
                }
                if (RubyGuards.isRubySymbol(valueValue_)) {
                    return SymbolNode_.create(this.root);
                }
            }
            if (valueValue instanceof String) {
                return JavaStringNode_.create(this.root);
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

