/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.interop.ForeignReadStringCachedHelperNode;
import org.jruby.truffle.interop.ForeignReadStringCachedHelperNodeGen;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={StringCachingGuards.class})
@NodeChildren(value={@NodeChild(value="receiver"), @NodeChild(value="name")})
abstract class ForeignReadStringCachingHelperNode
extends RubyNode {
    public ForeignReadStringCachingHelperNode(RubyContext context) {
        super(context, null);
    }

    public abstract Object executeStringCachingHelper(VirtualFrame var1, DynamicObject var2, Object var3);

    @Specialization(guards={"isRubyString(name)", "ropesEqual(name, cachedRope)"}, limit="getCacheLimit()")
    public Object cacheStringAndForward(VirtualFrame frame, DynamicObject receiver, DynamicObject name, @Cached(value="privatizeRope(name)") Rope cachedRope, @Cached(value="ropeToString(cachedRope)") String cachedString, @Cached(value="startsWithAt(cachedString)") boolean cachedStartsWithAt, @Cached(value="createNextHelper()") ForeignReadStringCachedHelperNode nextHelper) {
        return nextHelper.executeStringCachedHelper(frame, receiver, name, cachedString, cachedStartsWithAt);
    }

    @Specialization(guards={"isRubyString(name)"}, contains={"cacheStringAndForward"})
    public Object uncachedStringAndForward(VirtualFrame frame, DynamicObject receiver, DynamicObject name, @Cached(value="createNextHelper()") ForeignReadStringCachedHelperNode nextHelper) {
        String nameString = this.objectToString(name);
        return nextHelper.executeStringCachedHelper(frame, receiver, name, nameString, this.startsWithAt(nameString));
    }

    @Specialization(guards={"isRubySymbol(name)", "name == cachedName"}, limit="getCacheLimit()")
    public Object cacheSymbolAndForward(VirtualFrame frame, DynamicObject receiver, DynamicObject name, @Cached(value="name") DynamicObject cachedName, @Cached(value="objectToString(cachedName)") String cachedString, @Cached(value="startsWithAt(cachedString)") boolean cachedStartsWithAt, @Cached(value="createNextHelper()") ForeignReadStringCachedHelperNode nextHelper) {
        return nextHelper.executeStringCachedHelper(frame, receiver, cachedName, cachedString, cachedStartsWithAt);
    }

    @Specialization(guards={"isRubySymbol(name)"}, contains={"cacheSymbolAndForward"})
    public Object uncachedSymbolAndForward(VirtualFrame frame, DynamicObject receiver, DynamicObject name, @Cached(value="createNextHelper()") ForeignReadStringCachedHelperNode nextHelper) {
        String nameString = this.objectToString(name);
        return nextHelper.executeStringCachedHelper(frame, receiver, name, nameString, this.startsWithAt(nameString));
    }

    @Specialization(guards={"name == cachedName"}, limit="getCacheLimit()")
    public Object cacheJavaStringAndForward(VirtualFrame frame, DynamicObject receiver, String name, @Cached(value="name") String cachedName, @Cached(value="startsWithAt(cachedName)") boolean cachedStartsWithAt, @Cached(value="createNextHelper()") ForeignReadStringCachedHelperNode nextHelper) {
        return nextHelper.executeStringCachedHelper(frame, receiver, cachedName, cachedName, cachedStartsWithAt);
    }

    @Specialization(contains={"cacheJavaStringAndForward"})
    public Object uncachedJavaStringAndForward(VirtualFrame frame, DynamicObject receiver, String name, @Cached(value="createNextHelper()") ForeignReadStringCachedHelperNode nextHelper) {
        return nextHelper.executeStringCachedHelper(frame, receiver, name, name, this.startsWithAt(name));
    }

    protected ForeignReadStringCachedHelperNode createNextHelper() {
        return ForeignReadStringCachedHelperNodeGen.create(null, null, null, null);
    }

    @CompilerDirectives.TruffleBoundary
    protected String objectToString(DynamicObject string) {
        return string.toString();
    }

    protected String ropeToString(Rope rope) {
        return RopeOperations.decodeRope(this.getContext().getJRubyRuntime(), rope);
    }

    @CompilerDirectives.TruffleBoundary
    protected boolean startsWithAt(String name) {
        return !name.isEmpty() && name.charAt(0) == '@';
    }

    @Specialization(guards={"isRubyString(receiver)", "index < 0"})
    public int indexStringNegative(DynamicObject receiver, int index) {
        return 0;
    }

    @Specialization(guards={"isRubyString(receiver)", "index >= 0", "!inRange(receiver, index)"})
    public int indexStringOutOfRange(DynamicObject receiver, int index) {
        return 0;
    }

    @Specialization(guards={"isRubyString(receiver)", "index >= 0", "inRange(receiver, index)"})
    public int indexString(DynamicObject receiver, int index) {
        return Layouts.STRING.getRope(receiver).get(index);
    }

    protected boolean inRange(DynamicObject string, int index) {
        return index < Layouts.STRING.getRope(string).byteLength();
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().INTEROP_READ_CACHE;
    }
}

