/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Locale;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;
import org.jruby.truffle.core.rubinius.RubiniusPrimitive;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveArrayArgumentsNode;
import org.jruby.truffle.language.control.RaiseException;

public abstract class FloatPrimitiveNodes {

    @RubiniusPrimitive(name="float_round")
    public static abstract class FloatRoundPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;
        private final BranchProfile greaterZero = BranchProfile.create();
        private final BranchProfile lessZero = BranchProfile.create();

        public FloatRoundPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        @Specialization
        public Object round(double n) {
            if (Double.isInfinite(n)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().floatDomainError("Infinity", this));
            }
            if (Double.isNaN(n)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().floatDomainError("NaN", this));
            }
            double f = n;
            if (f > 0.0) {
                this.greaterZero.enter();
                f = Math.floor(f);
                if (n - f >= 0.5) {
                    f += 1.0;
                }
            } else if (f < 0.0) {
                this.lessZero.enter();
                f = Math.ceil(f);
                if (f - n >= 0.5) {
                    f -= 1.0;
                }
            }
            return this.fixnumOrBignum.fixnumOrBignum(f);
        }
    }

    @RubiniusPrimitive(name="float_signbit_p")
    public static abstract class FloatSignBitNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public boolean floatSignBit(double value) {
            return Double.doubleToLongBits(value) >>> 63 == 1L;
        }
    }

    @RubiniusPrimitive(name="float_dtoa")
    public static abstract class FloatDToAPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject dToA(double value) {
            int decimal;
            String string = String.format(Locale.ENGLISH, "%.1022f", value);
            if (string.toLowerCase(Locale.ENGLISH).contains("e")) {
                throw new UnsupportedOperationException();
            }
            string = string.replace("-", "");
            while (string.charAt(string.length() - 1) == '0') {
                string = string.substring(0, string.length() - 1);
            }
            if (string.startsWith("0.")) {
                string = string.replace("0.", "");
                decimal = 0;
                while (string.charAt(0) == '0') {
                    string = string.substring(1, string.length());
                    --decimal;
                }
            } else {
                decimal = string.indexOf(46);
                if (decimal == -1) {
                    throw new UnsupportedOperationException();
                }
                string = string.replace(".", "");
            }
            int sign = value < 0.0 ? 1 : 0;
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new Object[]{this.create7BitString(string, (Encoding)UTF8Encoding.INSTANCE), decimal, sign, string.length()}, 4);
        }
    }
}

