/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.kernel;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.UnaryCoreMethodNode;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.basicobject.BasicObjectNodes;
import org.jruby.truffle.core.basicobject.BasicObjectNodesFactory;
import org.jruby.truffle.core.binding.BindingNodes;
import org.jruby.truffle.core.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.core.cast.NameToJavaStringNode;
import org.jruby.truffle.core.cast.NameToJavaStringNodeGen;
import org.jruby.truffle.core.cast.NameToSymbolOrStringNodeGen;
import org.jruby.truffle.core.cast.NumericToFloatNode;
import org.jruby.truffle.core.cast.NumericToFloatNodeGen;
import org.jruby.truffle.core.cast.ToPathNodeGen;
import org.jruby.truffle.core.cast.ToStrNodeGen;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.encoding.EncodingOperations;
import org.jruby.truffle.core.format.BytesResult;
import org.jruby.truffle.core.format.FormatExceptionTranslator;
import org.jruby.truffle.core.format.exceptions.FormatException;
import org.jruby.truffle.core.format.exceptions.InvalidFormatException;
import org.jruby.truffle.core.format.printf.PrintfCompiler;
import org.jruby.truffle.core.hash.HashOperations;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.core.method.MethodFilter;
import org.jruby.truffle.core.proc.ProcNodes;
import org.jruby.truffle.core.proc.ProcNodesFactory;
import org.jruby.truffle.core.proc.ProcOperations;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.rubinius.ObjectPrimitiveNodes;
import org.jruby.truffle.core.rubinius.ObjectPrimitiveNodesFactory;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.symbol.SymbolTable;
import org.jruby.truffle.core.thread.ThreadBacktraceLocationLayoutImpl;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.backtrace.Activation;
import org.jruby.truffle.language.backtrace.Backtrace;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.language.dispatch.MissingBehavior;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.loader.FeatureLoader;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.LookupMethodNode;
import org.jruby.truffle.language.methods.LookupMethodNodeGen;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.objects.FreezeNode;
import org.jruby.truffle.language.objects.FreezeNodeGen;
import org.jruby.truffle.language.objects.IsANode;
import org.jruby.truffle.language.objects.IsANodeGen;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;
import org.jruby.truffle.language.objects.IsTaintedNode;
import org.jruby.truffle.language.objects.IsTaintedNodeGen;
import org.jruby.truffle.language.objects.LogicalClassNode;
import org.jruby.truffle.language.objects.LogicalClassNodeGen;
import org.jruby.truffle.language.objects.MetaClassNode;
import org.jruby.truffle.language.objects.MetaClassNodeGen;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;
import org.jruby.truffle.language.objects.SingletonClassNode;
import org.jruby.truffle.language.objects.SingletonClassNodeGen;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.language.objects.TaintNodeGen;
import org.jruby.truffle.language.objects.WriteObjectFieldNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNodeGen;
import org.jruby.truffle.language.parser.ParserContext;
import org.jruby.truffle.language.parser.jruby.TranslatorDriver;
import org.jruby.truffle.language.threadlocal.ThreadLocalObject;
import org.jruby.truffle.platform.UnsafeGroup;

@CoreClass(name="Kernel")
public abstract class KernelNodes {

    @CoreMethod(names={"untaint"})
    public static abstract class UntaintNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private IsTaintedNode isTaintedNode;
        @Node.Child
        private WriteObjectFieldNode writeTaintNode;

        public UntaintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isTaintedNode = IsTaintedNodeGen.create(context, sourceSection, null);
            this.writeTaintNode = WriteObjectFieldNodeGen.create(Layouts.TAINTED_IDENTIFIER);
        }

        @Specialization
        public Object taint(DynamicObject object) {
            if (!this.isTaintedNode.executeIsTainted(object)) {
                return object;
            }
            this.checkFrozen(object);
            this.writeTaintNode.execute(object, false);
            return object;
        }

        protected void checkFrozen(Object object) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            this.isFrozenNode.raiseIfFrozen(object);
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private LogicalClassNode classNode;
        @Node.Child
        private ObjectPrimitiveNodes.ObjectIDPrimitiveNode objectIDNode;
        @Node.Child
        private ToHexStringNode toHexStringNode;

        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = LogicalClassNodeGen.create(context, sourceSection, null);
            this.objectIDNode = ObjectPrimitiveNodesFactory.ObjectIDPrimitiveNodeFactory.create(new RubyNode[]{null});
            this.toHexStringNode = KernelNodesFactory.ToHexStringNodeFactory.create(new RubyNode[]{null});
        }

        public abstract DynamicObject executeToS(VirtualFrame var1, Object var2);

        @Specialization
        public DynamicObject toS(VirtualFrame frame, Object self) {
            CompilerDirectives.transferToInterpreter();
            String className = Layouts.MODULE.getFields(this.classNode.executeLogicalClass(self)).getName();
            Object id = this.objectIDNode.executeObjectID(frame, self);
            String hexID = this.toHexStringNode.executeToHexString(frame, id);
            return this.createString(StringOperations.encodeRope("#<" + className + ":0x" + hexID + ">", (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    public static abstract class ToHexStringNode
    extends CoreMethodArrayArgumentsNode {
        public abstract String executeToHexString(VirtualFrame var1, Object var2);

        @Specialization
        public String toHexString(int value) {
            return this.toHexString((long)value);
        }

        @Specialization
        public String toHexString(long value) {
            return Long.toHexString(value);
        }

        @Specialization(guards={"isRubyBignum(value)"})
        public String toHexString(DynamicObject value) {
            return Layouts.BIGNUM.getValue(value).toString(16);
        }
    }

    @CoreMethod(names={"tainted?"})
    public static abstract class KernelIsTaintedNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsTaintedNode isTaintedNode;

        @Specialization
        public boolean isTainted(Object object) {
            if (this.isTaintedNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isTaintedNode = (IsTaintedNode)this.insert(IsTaintedNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.isTaintedNode.executeIsTainted(object);
        }
    }

    @CoreMethod(names={"taint"})
    public static abstract class KernelTaintNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode;

        @Specialization
        public Object taint(Object object) {
            if (this.taintNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.taintNode.executeTaint(object);
        }
    }

    @CoreMethod(names={"format", "sprintf"}, isModuleFunction=true, rest=true, required=1, taintFromParameter=0)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class SprintfNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeLeafRopeNode makeLeafRopeNode;
        @Node.Child
        private TaintNode taintNode;
        private final BranchProfile exceptionProfile = BranchProfile.create();
        private final ConditionProfile resizeProfile = ConditionProfile.createBinaryProfile();

        @Specialization(guards={"isRubyString(format)", "ropesEqual(format, cachedFormat)"})
        public DynamicObject formatCached(VirtualFrame frame, DynamicObject format, Object[] arguments, @Cached(value="privatizeRope(format)") Rope cachedFormat, @Cached(value="ropeLength(cachedFormat)") int cachedFormatLength, @Cached(value="create(compileFormat(format))") DirectCallNode callPackNode) {
            BytesResult result;
            try {
                result = (BytesResult)callPackNode.call(frame, new Object[]{arguments, arguments.length});
            }
            catch (FormatException e) {
                this.exceptionProfile.enter();
                throw FormatExceptionTranslator.translate(this, e);
            }
            return this.finishFormat(cachedFormatLength, result);
        }

        @Specialization(guards={"isRubyString(format)"}, contains={"formatCached"})
        public DynamicObject formatUncached(VirtualFrame frame, DynamicObject format, Object[] arguments, @Cached(value="create()") IndirectCallNode callPackNode) {
            BytesResult result;
            try {
                result = (BytesResult)callPackNode.call(frame, this.compileFormat(format), new Object[]{arguments, arguments.length});
            }
            catch (FormatException e) {
                this.exceptionProfile.enter();
                throw FormatExceptionTranslator.translate(this, e);
            }
            return this.finishFormat(Layouts.STRING.getRope(format).byteLength(), result);
        }

        private DynamicObject finishFormat(int formatLength, BytesResult result) {
            byte[] bytes = result.getOutput();
            if (this.resizeProfile.profile(bytes.length != result.getOutputLength())) {
                bytes = Arrays.copyOf(bytes, result.getOutputLength());
            }
            if (this.makeLeafRopeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.makeLeafRopeNode = (RopeNodes.MakeLeafRopeNode)this.insert(RopeNodesFactory.MakeLeafRopeNodeGen.create(null, null, null, null));
            }
            DynamicObject string = this.createString(this.makeLeafRopeNode.executeMake(bytes, result.getEncoding().getEncodingForLength(formatLength), result.getStringCodeRange(), result.getOutputLength()));
            if (result.isTainted()) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
                }
                this.taintNode.executeTaint(string);
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        protected CallTarget compileFormat(DynamicObject format) {
            assert (RubyGuards.isRubyString(format));
            try {
                return new PrintfCompiler(this.getContext(), this).compile(format.toString(), Layouts.STRING.getRope(format).getBytes());
            }
            catch (InvalidFormatException e) {
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), this));
            }
        }
    }

    @CoreMethod(names={"sleep"}, isModuleFunction=true, optional=1)
    public static abstract class SleepNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NumericToFloatNode floatCastNode;

        @Specialization
        public long sleep(NotProvided duration) {
            return this.doSleepMillis(Long.MAX_VALUE);
        }

        @Specialization
        public long sleep(int duration) {
            return this.doSleepMillis((long)duration * 1000L);
        }

        @Specialization
        public long sleep(long duration) {
            return this.doSleepMillis(duration * 1000L);
        }

        @Specialization
        public long sleep(double duration) {
            return this.doSleepMillis((long)(duration * 1000.0));
        }

        @Specialization(guards={"isRubiniusUndefined(duration)"})
        public long sleep(DynamicObject duration) {
            return this.sleep(NotProvided.INSTANCE);
        }

        @Specialization(guards={"!isRubiniusUndefined(duration)"})
        public long sleep(VirtualFrame frame, DynamicObject duration) {
            if (this.floatCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.floatCastNode = (NumericToFloatNode)this.insert(NumericToFloatNodeGen.create(this.getContext(), this.getSourceSection(), "to_f", null));
            }
            return this.sleep(this.floatCastNode.executeDouble(frame, duration));
        }

        @CompilerDirectives.TruffleBoundary
        private long doSleepMillis(long durationInMillis) {
            if (durationInMillis < 0L) {
                throw new RaiseException(this.coreExceptions().argumentError("time interval must be positive", this));
            }
            DynamicObject thread = this.getContext().getThreadManager().getCurrentThread();
            Layouts.THREAD.getWakeUp(thread).set(false);
            return SleepNode.sleepFor(this, this.getContext(), durationInMillis);
        }

        public static long sleepFor(Node currentNode, RubyContext context, final long durationInMillis) {
            assert (durationInMillis >= 0L);
            final DynamicObject thread = context.getThreadManager().getCurrentThread();
            final long start = System.currentTimeMillis();
            long slept = context.getThreadManager().runUntilResult(currentNode, new ThreadManager.BlockingAction<Long>(){

                @Override
                public Long block() throws InterruptedException {
                    long now = System.currentTimeMillis();
                    long slept = now - start;
                    if (slept >= durationInMillis || Layouts.THREAD.getWakeUp(thread).getAndSet(false)) {
                        return slept;
                    }
                    Thread.sleep(durationInMillis - slept);
                    return System.currentTimeMillis() - start;
                }
            });
            return slept / 1000L;
        }
    }

    @CoreMethod(names={"singleton_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class SingletonMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public SingletonMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        public abstract DynamicObject executeSingletonMethods(VirtualFrame var1, Object var2, boolean var3);

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(null, null, true, includeAncestors);
        }

        @Specialization
        public DynamicObject singletonMethods(Object self, boolean includeAncestors) {
            DynamicObject metaClass = this.metaClassNode.executeMetaClass(self);
            if (!Layouts.CLASS.getIsSingleton(metaClass)) {
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), null, 0);
            }
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(metaClass).filterSingletonMethods(this.getContext(), includeAncestors, MethodFilter.PUBLIC_PROTECTED).toArray();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"singleton_class"})
    public static abstract class SingletonClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public SingletonClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject singletonClass(Object self) {
            return this.singletonClassNode.executeSingletonClass(self);
        }
    }

    @CoreMethod(names={"set_trace_func"}, isModuleFunction=true, required=1)
    public static abstract class SetTraceFuncNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNil(nil)"})
        public DynamicObject setTraceFunc(Object nil) {
            this.getContext().getTraceManager().setTraceFunc(null);
            return this.nil();
        }

        @Specialization(guards={"isRubyProc(traceFunc)"})
        public DynamicObject setTraceFunc(DynamicObject traceFunc) {
            this.getContext().getTraceManager().setTraceFunc(traceFunc);
            return traceFunc;
        }
    }

    @CoreMethod(names={"respond_to_missing?"}, required=2)
    public static abstract class RespondToMissingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(name)"})
        public boolean doesRespondToMissingString(Object object, DynamicObject name, Object unusedIncludeAll) {
            return false;
        }

        @Specialization(guards={"isRubySymbol(name)"})
        public boolean doesRespondToMissingSymbol(Object object, DynamicObject name, Object unusedIncludeAll) {
            return false;
        }
    }

    @CoreMethod(names={"respond_to?"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="includeProtectedAndPrivate")})
    public static abstract class RespondToNode
    extends CoreMethodNode {
        @Node.Child
        private DoesRespondDispatchHeadNode dispatch;
        @Node.Child
        private DoesRespondDispatchHeadNode dispatchIgnoreVisibility;
        @Node.Child
        private DoesRespondDispatchHeadNode dispatchRespondToMissing;
        @Node.Child
        private CallDispatchHeadNode respondToMissingNode;
        private final ConditionProfile ignoreVisibilityProfile = ConditionProfile.createBinaryProfile();

        public RespondToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = new DoesRespondDispatchHeadNode(context, false);
            this.dispatchIgnoreVisibility = new DoesRespondDispatchHeadNode(context, true);
            this.dispatchRespondToMissing = new DoesRespondDispatchHeadNode(context, true);
        }

        public abstract boolean executeDoesRespondTo(VirtualFrame var1, Object var2, Object var3, boolean var4);

        @CreateCast(value={"includeProtectedAndPrivate"})
        public RubyNode coerceToBoolean(RubyNode includeProtectedAndPrivate) {
            return BooleanCastWithDefaultNodeGen.create(null, null, false, includeProtectedAndPrivate);
        }

        @Specialization(guards={"isRubyString(name)"})
        public boolean doesRespondToString(VirtualFrame frame, Object object, DynamicObject name, boolean includeProtectedAndPrivate) {
            boolean ret = this.ignoreVisibilityProfile.profile(includeProtectedAndPrivate) ? this.dispatchIgnoreVisibility.doesRespondTo(frame, name, object) : this.dispatch.doesRespondTo(frame, name, object);
            if (ret) {
                return true;
            }
            if (this.dispatchRespondToMissing.doesRespondTo(frame, "respond_to_missing?", object)) {
                return this.respondToMissing(frame, object, name, includeProtectedAndPrivate);
            }
            return false;
        }

        @Specialization(guards={"isRubySymbol(name)"})
        public boolean doesRespondToSymbol(VirtualFrame frame, Object object, DynamicObject name, boolean includeProtectedAndPrivate) {
            boolean ret = this.ignoreVisibilityProfile.profile(includeProtectedAndPrivate) ? this.dispatchIgnoreVisibility.doesRespondTo(frame, name, object) : this.dispatch.doesRespondTo(frame, name, object);
            if (ret) {
                return true;
            }
            if (this.dispatchRespondToMissing.doesRespondTo(frame, "respond_to_missing?", object)) {
                return this.respondToMissing(frame, object, name, includeProtectedAndPrivate);
            }
            return false;
        }

        private boolean respondToMissing(VirtualFrame frame, Object object, DynamicObject name, boolean includeProtectedAndPrivate) {
            if (this.respondToMissingNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToMissingNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            return this.respondToMissingNode.callBoolean(frame, object, "respond_to_missing?", null, name, includeProtectedAndPrivate);
        }
    }

    @CoreMethod(names={"require_relative"}, isModuleFunction=true, required=1, unsafe={UnsafeGroup.LOAD})
    public static abstract class RequireRelativeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(feature)"})
        public boolean requireRelative(VirtualFrame frame, DynamicObject feature, @Cached(value="create()") IndirectCallNode callNode) {
            String featurePath;
            CompilerDirectives.transferToInterpreter();
            FeatureLoader featureLoader = this.getContext().getFeatureLoader();
            String featureString = feature.toString();
            if (featureString.startsWith("truffle:") || featureString.startsWith("jruby:") || new File(featureString).isAbsolute()) {
                featurePath = featureString;
            } else {
                Source source = this.getContext().getCallStack().getCallerFrameIgnoringSend().getCallNode().getEncapsulatingSourceSection().getSource();
                String result = source.getPath() == null ? source.getShortName() : source.getPath();
                String sourcePath = result;
                if (sourcePath == null) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.coreExceptions().loadError("cannot infer basepath", featureString, this));
                }
                featurePath = this.dirname(sourcePath) + "/" + featureString;
            }
            featureLoader.require(frame, featurePath, callNode);
            return true;
        }

        private String dirname(String path) {
            int lastSlash = path.lastIndexOf(47);
            assert (lastSlash > 0);
            return path.substring(0, lastSlash);
        }
    }

    @CoreMethod(names={"require"}, isModuleFunction=true, required=1, unsafe={UnsafeGroup.LOAD})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="feature")})
    public static abstract class RequireNode
    extends CoreMethodNode {
        @CreateCast(value={"feature"})
        public RubyNode coerceFeatureToPath(RubyNode feature) {
            return ToPathNodeGen.create(null, null, feature);
        }

        @Specialization(guards={"isRubyString(featureString)"})
        public boolean require(VirtualFrame frame, DynamicObject featureString, @Cached(value="create()") IndirectCallNode callNode) {
            CompilerDirectives.transferToInterpreter();
            String feature = featureString.toString();
            if (feature.equals("psych.so") && this.callerIs("stdlib/psych.rb")) {
                this.getContext().getFeatureLoader().require(frame, "truffle/psych.rb", callNode);
                return true;
            }
            if (feature.equals("strscan") && this.callerIs("stdlib/erb.rb")) {
                throw new RaiseException(this.coreExceptions().loadErrorCannotLoad(feature, this));
            }
            return this.getContext().getFeatureLoader().require(frame, feature, callNode);
        }

        private boolean callerIs(String caller) {
            for (Activation activation : this.getContext().getCallStack().getBacktrace(this).getActivations()) {
                Source source = activation.getCallNode().getEncapsulatingSourceSection().getSource();
                if (source == null || !source.getName().endsWith(caller)) continue;
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"public_send"}, needsBlock=true, required=1, rest=true)
    public static abstract class PublicSendNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode dispatchNode;

        public PublicSendNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatchNode = new CallDispatchHeadNode(context, false, MissingBehavior.CALL_METHOD_MISSING);
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self, Object name, Object[] args, NotProvided block) {
            return this.send(frame, self, name, args, (DynamicObject)null);
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self, Object name, Object[] args, DynamicObject block) {
            return this.dispatchNode.call(frame, self, name, block, args);
        }
    }

    @CoreMethod(names={"public_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class PublicMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public PublicMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(null, null, true, includeAncestors);
        }

        @Specialization
        public DynamicObject publicMethods(Object self, boolean includeAncestors) {
            DynamicObject metaClass = this.metaClassNode.executeMetaClass(self);
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(metaClass).filterMethodsOnObject(this.getContext(), includeAncestors, MethodFilter.PUBLIC).toArray();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"protected_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class ProtectedMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public ProtectedMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(null, null, true, includeAncestors);
        }

        @Specialization
        public DynamicObject protectedMethods(Object self, boolean includeAncestors) {
            DynamicObject metaClass = this.metaClassNode.executeMetaClass(self);
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(metaClass).filterMethodsOnObject(this.getContext(), includeAncestors, MethodFilter.PROTECTED).toArray();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"proc"}, isModuleFunction=true, needsBlock=true)
    public static abstract class ProcNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        ProcNodes.ProcNewNode procNewNode = ProcNodesFactory.ProcNewNodeFactory.create(null);

        public ProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject proc(VirtualFrame frame, Object maybeBlock) {
            return this.procNewNode.executeProcNew(frame, this.coreLibrary().getProcClass(), ArrayUtils.EMPTY_ARRAY, maybeBlock);
        }
    }

    @CoreMethod(names={"private_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class PrivateMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public PrivateMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(null, null, true, includeAncestors);
        }

        @Specialization
        public DynamicObject privateMethods(Object self, boolean includeAncestors) {
            DynamicObject metaClass = this.metaClassNode.executeMetaClass(self);
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(metaClass).filterMethodsOnObject(this.getContext(), includeAncestors, MethodFilter.PRIVATE).toArray();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"nil?"}, needsSelf=false)
    public static abstract class NilNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean isNil() {
            return false;
        }
    }

    @CoreMethod(names={"methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="regular")})
    public static abstract class MethodsNode
    extends CoreMethodNode {
        @CreateCast(value={"regular"})
        public RubyNode coerceToBoolean(RubyNode regular) {
            return BooleanCastWithDefaultNodeGen.create(null, null, true, regular);
        }

        @Specialization(guards={"regular"})
        public DynamicObject methodsRegular(Object self, boolean regular, @Cached(value="createMetaClassNode()") MetaClassNode metaClassNode) {
            DynamicObject metaClass = metaClassNode.executeMetaClass(self);
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(metaClass).filterMethodsOnObject(this.getContext(), regular, MethodFilter.PUBLIC_PROTECTED).toArray();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }

        @Specialization(guards={"!regular"})
        public DynamicObject methodsSingleton(VirtualFrame frame, Object self, boolean regular, @Cached(value="createSingletonMethodsNode()") SingletonMethodsNode singletonMethodsNode) {
            return singletonMethodsNode.executeSingletonMethods(frame, self, false);
        }

        protected MetaClassNode createMetaClassNode() {
            return MetaClassNodeGen.create(this.getContext(), this.getSourceSection(), null);
        }

        protected SingletonMethodsNode createSingletonMethodsNode() {
            return KernelNodesFactory.SingletonMethodsNodeFactory.create(this.getContext(), this.getSourceSection(), null, null);
        }
    }

    @CoreMethod(names={"method"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class MethodNode
    extends CoreMethodNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode = NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), null);
        @Node.Child
        LookupMethodNode lookupMethodNode;
        @Node.Child
        CallDispatchHeadNode respondToMissingNode;

        public MethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.lookupMethodNode = LookupMethodNodeGen.create(context, sourceSection, null, null);
            this.respondToMissingNode = DispatchHeadNodeFactory.createMethodCall(this.getContext(), true);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToSymbolOrStringNodeGen.create(null, null, name);
        }

        @Specialization
        public DynamicObject method(VirtualFrame frame, Object self, DynamicObject name) {
            String normalizedName = this.nameToJavaStringNode.executeToJavaString(frame, name);
            InternalMethod method = this.lookupMethodNode.executeLookupMethod(self, normalizedName);
            if (method == null) {
                CompilerDirectives.transferToInterpreter();
                if (this.respondToMissingNode.callBoolean(frame, self, "respond_to_missing?", null, name, true)) {
                    InternalMethod methodMissing = this.lookupMethodNode.executeLookupMethod(self, "method_missing").withName(normalizedName);
                    SharedMethodInfo info = methodMissing.getSharedMethodInfo().withName(normalizedName);
                    CallMethodMissingWithStaticName newBody = new CallMethodMissingWithStaticName(this.getContext(), info.getSourceSection(), name);
                    RubyRootNode newRootNode = new RubyRootNode(this.getContext(), info.getSourceSection(), new FrameDescriptor((Object)this.nil()), info, newBody, false);
                    RootCallTarget newCallTarget = Truffle.getRuntime().createCallTarget((RootNode)newRootNode);
                    DynamicObject module = this.coreLibrary().getMetaClass(self);
                    method = new InternalMethod(info, normalizedName, module, Visibility.PUBLIC, (CallTarget)newCallTarget);
                } else {
                    throw new RaiseException(this.coreExceptions().nameErrorUndefinedMethod(normalizedName, this.coreLibrary().getLogicalClass(self), this));
                }
            }
            return Layouts.METHOD.createMethod(this.coreLibrary().getMethodFactory(), self, method);
        }

        private static class CallMethodMissingWithStaticName
        extends RubyNode {
            private final DynamicObject methodName;
            @Node.Child
            private CallDispatchHeadNode methodMissing;

            public CallMethodMissingWithStaticName(RubyContext context, SourceSection sourceSection, DynamicObject methodName) {
                super(context, sourceSection);
                this.methodName = methodName;
                this.methodMissing = DispatchHeadNodeFactory.createMethodCall(context);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object[] originalUserArguments = RubyArguments.getArguments((Frame)frame);
                Object[] newUserArguments = ArrayUtils.unshift(originalUserArguments, this.methodName);
                return this.methodMissing.call(frame, RubyArguments.getSelf((Frame)frame), "method_missing", RubyArguments.getBlock((Frame)frame), newUserArguments);
            }
        }
    }

    @CoreMethod(names={"__method__"}, needsSelf=false)
    public static abstract class MethodNameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject methodName() {
            CompilerDirectives.transferToInterpreter();
            return this.getSymbol(this.getContext().getCallStack().getCallingMethodIgnoringSend().getSharedMethodInfo().getName());
        }
    }

    @CoreMethod(names={"local_variables"}, needsSelf=false)
    public static abstract class LocalVariablesNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject localVariables() {
            Frame frame = this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
            return BindingNodes.LocalVariablesNode.listLocalVariables(this.getContext(), frame);
        }
    }

    @CoreMethod(names={"lambda"}, isModuleFunction=true, needsBlock=true)
    public static abstract class LambdaNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject lambda(NotProvided block) {
            Frame parentFrame = this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
            DynamicObject parentBlock = RubyArguments.getBlock(parentFrame.getArguments());
            if (parentBlock == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().argumentError("tried to create Proc object without a block", this));
            }
            return this.lambda(parentBlock);
        }

        @Specialization
        public DynamicObject lambda(DynamicObject block) {
            return ProcOperations.createRubyProc(this.coreLibrary().getProcFactory(), ProcType.LAMBDA, Layouts.PROC.getSharedMethodInfo(block), Layouts.PROC.getCallTargetForLambdas(block), Layouts.PROC.getCallTargetForLambdas(block), Layouts.PROC.getDeclarationFrame(block), Layouts.PROC.getMethod(block), Layouts.PROC.getSelf(block), Layouts.PROC.getBlock(block));
        }
    }

    @CoreMethod(names={"is_a?", "kind_of?"}, required=1)
    public static abstract class KernelIsANode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        IsANode isANode;

        public KernelIsANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = IsANodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public boolean isA(Object self, DynamicObject module) {
            return this.isANode.executeIsA(self, module);
        }

        @Specialization(guards={"!isRubyModule(module)"})
        public boolean isATypeError(Object self, Object module) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.coreExceptions().typeError("class or module required", this));
        }
    }

    @CoreMethod(names={"instance_variables"})
    public static abstract class InstanceVariablesNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private BasicObjectNodes.InstanceVariablesNode instanceVariablesNode = BasicObjectNodesFactory.InstanceVariablesNodeFactory.create(new RubyNode[0]);

        public InstanceVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject instanceVariables(VirtualFrame frame, DynamicObject self) {
            return this.instanceVariablesNode.executeObject(self);
        }
    }

    @CoreMethod(names={"remove_instance_variable"}, raiseIfFrozenSelf=true, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class RemoveInstanceVariableNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(null, null, name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object removeInstanceVariable(DynamicObject object, String name) {
            String ivar = SymbolTable.checkInstanceVariableName(this.getContext(), name, this);
            Object value = object.get((Object)ivar, (Object)this.nil());
            if (!object.delete((Object)name)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().nameErrorInstanceVariableNotDefined(name, this));
            }
            return value;
        }
    }

    @CoreMethod(names={"instance_variable_set", "__instance_variable_set__"}, raiseIfFrozenSelf=true, required=2)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class InstanceVariableSetNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToSymbolOrString(RubyNode name) {
            return NameToSymbolOrStringNodeGen.create(null, null, name);
        }

        @Specialization(guards={"isRubySymbol(name)", "name == cachedName"}, limit="getCacheLimit()")
        public Object instanceVariableSetSymbolCached(DynamicObject object, DynamicObject name, Object value, @Cached(value="name") DynamicObject cachedName, @Cached(value="createWriteFieldNode(checkName(symbolToString(cachedName)))") WriteObjectFieldNode writeHeadObjectFieldNode) {
            writeHeadObjectFieldNode.execute(object, value);
            return value;
        }

        @Specialization(guards={"isRubySymbol(name)"})
        public Object instanceVariableSetSymbol(DynamicObject object, DynamicObject name, Object value) {
            return this.ivarSet(object, this.symbolToString(name), value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public Object instanceVariableSetString(DynamicObject object, DynamicObject name, Object value) {
            return this.ivarSet(object, name.toString(), value);
        }

        @CompilerDirectives.TruffleBoundary
        private Object ivarSet(DynamicObject object, String name, Object value) {
            object.define((Object)this.checkName(name), value, 0);
            return value;
        }

        protected String symbolToString(DynamicObject name) {
            return Layouts.SYMBOL.getString(name);
        }

        protected String checkName(String name) {
            return SymbolTable.checkInstanceVariableName(this.getContext(), name, this);
        }

        protected WriteObjectFieldNode createWriteFieldNode(String name) {
            return WriteObjectFieldNodeGen.create(name);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().INSTANCE_VARIABLE_CACHE;
        }
    }

    @CoreMethod(names={"instance_variable_get"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class InstanceVariableGetNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToSymbolOrString(RubyNode name) {
            return NameToSymbolOrStringNodeGen.create(null, null, name);
        }

        @Specialization(guards={"isRubySymbol(name)", "name == cachedName"}, limit="getCacheLimit()")
        public Object instanceVariableGetSymbolCached(DynamicObject object, DynamicObject name, @Cached(value="name") DynamicObject cachedName, @Cached(value="createReadFieldNode(checkName(symbolToString(cachedName)))") ReadObjectFieldNode readHeadObjectFieldNode) {
            return readHeadObjectFieldNode.execute(object);
        }

        @Specialization(guards={"isRubySymbol(name)"})
        public Object instanceVariableGetSymbol(DynamicObject object, DynamicObject name) {
            return this.ivarGet(object, this.symbolToString(name));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public Object instanceVariableGetString(DynamicObject object, DynamicObject name) {
            return this.ivarGet(object, name.toString());
        }

        @CompilerDirectives.TruffleBoundary
        private Object ivarGet(DynamicObject object, String name) {
            return object.get((Object)this.checkName(name), (Object)this.nil());
        }

        protected String symbolToString(DynamicObject name) {
            return Layouts.SYMBOL.getString(name);
        }

        protected String checkName(String name) {
            return SymbolTable.checkInstanceVariableName(this.getContext(), name, this);
        }

        protected ReadObjectFieldNode createReadFieldNode(String name) {
            return ReadObjectFieldNodeGen.create(name, this.nil());
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().INSTANCE_VARIABLE_CACHE;
        }
    }

    @CoreMethod(names={"instance_variable_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class InstanceVariableDefinedNode
    extends CoreMethodNode {
        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(null, null, name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isInstanceVariableDefined(DynamicObject object, String name) {
            String ivar = SymbolTable.checkInstanceVariableName(this.getContext(), name, this);
            return object.getShape().hasProperty((Object)ivar);
        }
    }

    @CoreMethod(names={"instance_of?"}, required=1)
    public static abstract class InstanceOfNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private LogicalClassNode classNode;

        public InstanceOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = LogicalClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization(guards={"isRubyClass(rubyClass)"})
        public boolean instanceOf(VirtualFrame frame, Object self, DynamicObject rubyClass) {
            return this.classNode.executeLogicalClass(self) == rubyClass;
        }
    }

    @CoreMethod(names={"initialize_dup", "initialize_clone"}, required=1)
    public static abstract class InitializeDupCloneNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode initializeCopyNode;

        public InitializeDupCloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initializeCopyNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public Object initializeDup(VirtualFrame frame, DynamicObject self, DynamicObject from) {
            return this.initializeCopyNode.call(frame, self, "initialize_copy", null, from);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object initializeCopy(DynamicObject self, DynamicObject from) {
            CompilerDirectives.transferToInterpreter();
            if (Layouts.BASIC_OBJECT.getLogicalClass(self) != Layouts.BASIC_OBJECT.getLogicalClass(from)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().typeError("initialize_copy should take same class object", this));
            }
            return self;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int hash(int value) {
            return value;
        }

        @Specialization
        public int hash(long value) {
            return Long.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(double value) {
            return Double.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(boolean value) {
            return Boolean.valueOf(value).hashCode();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int hash(DynamicObject self) {
            return System.identityHashCode(self);
        }
    }

    @CoreMethod(names={"gets"}, isModuleFunction=true, unsafe={UnsafeGroup.IO})
    public static abstract class GetsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject gets(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            InputStream in = this.getContext().getJRubyRuntime().getInstanceConfig().getInput();
            Encoding encoding = this.getContext().getJRubyRuntime().getDefaultExternalEncoding();
            final BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding.getCharset()));
            String line = this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<String>(){

                @Override
                public String block() throws InterruptedException {
                    return GetsNode.gets(reader);
                }
            });
            DynamicObject rubyLine = this.createString(StringOperations.encodeRope(line, (Encoding)UTF8Encoding.INSTANCE));
            Frame caller = this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.READ_WRITE, true);
            FrameSlot slot = caller.getFrameDescriptor().findFrameSlot((Object)"$_");
            if (slot != null) {
                caller.setObject(slot, (Object)ThreadLocalObject.wrap(this.getContext(), rubyLine));
            }
            return rubyLine;
        }

        @CompilerDirectives.TruffleBoundary
        private static String gets(BufferedReader reader) throws InterruptedException {
            try {
                return reader.readLine() + "\n";
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CoreMethod(names={"frozen?"})
    public static abstract class KernelFrozenNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;

        @Specialization
        public boolean isFrozen(Object self) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.isFrozenNode.executeIsFrozen(self);
        }
    }

    @CoreMethod(names={"freeze"})
    public static abstract class KernelFreezeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FreezeNode freezeNode;

        public KernelFreezeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.freezeNode = FreezeNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public Object freeze(Object self) {
            return this.freezeNode.executeFreeze(self);
        }
    }

    @CoreMethod(names={"fork"}, isModuleFunction=true, rest=true, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class ForkNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object fork(Object[] args) {
            SourceSection sourceSection = this.getContext().getCallStack().getTopMostUserCallNode().getEncapsulatingSourceSection();
            this.getContext().getJRubyRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, sourceSection.getSource().getName(), sourceSection.getStartLine(), "Kernel#fork not implemented - defined to satisfy some metaprogramming in RubySpec");
            return this.nil();
        }
    }

    @CoreMethod(names={"exec"}, isModuleFunction=true, required=1, rest=true, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class ExecNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toHashNode;

        @Specialization
        public Object exec(VirtualFrame frame, Object command, Object[] args) {
            if (this.toHashNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toHashNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            CompilerDirectives.transferToInterpreter();
            String[] commandLine = new String[1 + args.length];
            commandLine[0] = command.toString();
            for (int n = 0; n < args.length; ++n) {
                commandLine[1 + n] = args[n].toString();
            }
            DynamicObject env = this.coreLibrary().getENV();
            DynamicObject envAsHash = (DynamicObject)this.toHashNode.call(frame, env, "to_hash", null, new Object[0]);
            this.exec(this.getContext(), envAsHash, commandLine);
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private void exec(RubyContext context, DynamicObject envAsHash, String[] commandLine) {
            Process process;
            ProcessBuilder builder = new ProcessBuilder(commandLine);
            builder.inheritIO();
            for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(envAsHash)) {
                builder.environment().put(keyValue.getKey().toString(), keyValue.getValue().toString());
            }
            try {
                process = builder.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int exitCode = context.getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    return process.waitFor();
                }
            });
            System.exit(exitCode);
        }
    }

    @CoreMethod(names={"eval"}, isModuleFunction=true, required=1, optional=3, lowerFixnumParameters={3})
    @ImportStatic(value={StringCachingGuards.class})
    @NodeChildren(value={@NodeChild(value="source", type=RubyNode.class), @NodeChild(value="binding", type=RubyNode.class), @NodeChild(value="filename", type=RubyNode.class), @NodeChild(value="lineNumber", type=RubyNode.class)})
    public static abstract class EvalNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toStr;
        @Node.Child
        private BindingNode bindingNode;

        @CreateCast(value={"source"})
        public RubyNode coerceSourceToString(RubyNode source) {
            return ToStrNodeGen.create(null, null, source);
        }

        protected DynamicObject getCallerBinding(VirtualFrame frame) {
            if (this.bindingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bindingNode = (BindingNode)this.insert(KernelNodesFactory.BindingNodeFactory.create(new RubyNode[0]));
            }
            try {
                return this.bindingNode.executeDynamicObject(frame);
            }
            catch (UnexpectedResultException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Specialization(guards={"isRubyString(source)", "ropesEqual(source, cachedSource)", "!parseDependsOnDeclarationFrame(cachedRootNode)"}, limit="getCacheLimit()")
        public Object evalNoBindingCached(VirtualFrame frame, DynamicObject source, NotProvided binding, NotProvided filename, NotProvided lineNumber, @Cached(value="privatizeRope(source)") Rope cachedSource, @Cached(value="compileSource(frame, source)") RootNodeWrapper cachedRootNode, @Cached(value="createCallTarget(cachedRootNode)") CallTarget cachedCallTarget, @Cached(value="create(cachedCallTarget)") DirectCallNode callNode) {
            DynamicObject callerBinding = this.getCallerBinding(frame);
            MaterializedFrame parentFrame = Layouts.BINDING.getFrame(callerBinding);
            Object callerSelf = RubyArguments.getSelf((Frame)frame);
            InternalMethod method = new InternalMethod(cachedRootNode.getRootNode().getSharedMethodInfo(), cachedRootNode.getRootNode().getSharedMethodInfo().getName(), RubyArguments.getMethod(parentFrame.getArguments()).getDeclaringModule(), Visibility.PUBLIC, cachedCallTarget);
            return callNode.call(frame, RubyArguments.pack(parentFrame, null, method, RubyArguments.getDeclarationContext(parentFrame.getArguments()), null, callerSelf, null, new Object[0]));
        }

        @Specialization(guards={"isRubyString(source)"}, contains={"evalNoBindingCached"})
        public Object evalNoBindingUncached(VirtualFrame frame, DynamicObject source, NotProvided noBinding, NotProvided filename, NotProvided lineNumber, @Cached(value="create()") IndirectCallNode callNode) {
            DynamicObject binding = this.getCallerBinding(frame);
            MaterializedFrame topFrame = Layouts.BINDING.getFrame(binding);
            RubyArguments.setSelf(topFrame.getArguments(), RubyArguments.getSelf((Frame)frame));
            CodeLoader.DeferredCall deferredCall = this.doEvalX(source, binding, "(eval)", 1, true);
            return deferredCall.call(frame, callNode);
        }

        @Specialization(guards={"isRubyString(source)", "isNil(noBinding)", "isRubyString(filename)"})
        public Object evalNilBinding(VirtualFrame frame, DynamicObject source, DynamicObject noBinding, DynamicObject filename, Object unusedLineNumber, @Cached(value="create()") IndirectCallNode callNode) {
            return this.evalNoBindingUncached(frame, source, NotProvided.INSTANCE, NotProvided.INSTANCE, NotProvided.INSTANCE, callNode);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)"})
        public Object evalBinding(VirtualFrame frame, DynamicObject source, DynamicObject binding, NotProvided filename, NotProvided lineNumber, @Cached(value="create()") IndirectCallNode callNode) {
            CodeLoader.DeferredCall deferredCall = this.doEvalX(source, binding, "(eval)", 1, false);
            return deferredCall.call(frame, callNode);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)", "isNil(noFilename)", "isNil(noLineNumber)"})
        public Object evalBinding(VirtualFrame frame, DynamicObject source, DynamicObject binding, DynamicObject noFilename, DynamicObject noLineNumber, @Cached(value="create()") IndirectCallNode callNode) {
            return this.evalBinding(frame, source, binding, NotProvided.INSTANCE, NotProvided.INSTANCE, callNode);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)", "isRubyString(filename)"})
        public Object evalBindingFilename(VirtualFrame frame, DynamicObject source, DynamicObject binding, DynamicObject filename, NotProvided lineNumber, @Cached(value="create()") IndirectCallNode callNode) {
            return this.evalBindingFilenameLine(frame, source, binding, filename, 0, callNode);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)", "isRubyString(filename)", "isNil(noLineNumber)"})
        public Object evalBindingFilename(VirtualFrame frame, DynamicObject source, DynamicObject binding, DynamicObject filename, DynamicObject noLineNumber, @Cached(value="create()") IndirectCallNode callNode) {
            return this.evalBindingFilename(frame, source, binding, filename, NotProvided.INSTANCE, callNode);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)", "isRubyString(filename)"})
        public Object evalBindingFilenameLine(VirtualFrame frame, DynamicObject source, DynamicObject binding, DynamicObject filename, int lineNumber, @Cached(value="create()") IndirectCallNode callNode) {
            CodeLoader.DeferredCall deferredCall = this.doEvalX(source, binding, filename.toString(), lineNumber, false);
            return deferredCall.call(frame, callNode);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(source)", "!isRubyBinding(badBinding)"})
        public Object evalBadBinding(DynamicObject source, DynamicObject badBinding, NotProvided filename, NotProvided lineNumber) {
            throw new RaiseException(this.coreExceptions().typeErrorWrongArgumentType(badBinding, "binding", this));
        }

        @CompilerDirectives.TruffleBoundary
        private CodeLoader.DeferredCall doEvalX(DynamicObject rubySource, DynamicObject binding, String filename, int line, boolean ownScopeForAssignments) {
            Rope code = StringOperations.rope(rubySource);
            String space = new String(new char[Math.max(line - 1, 0)]).replace("\u0000", "\n");
            Source source = Source.fromText((CharSequence)(space + RopeOperations.decodeRope(this.getContext().getJRubyRuntime(), code)), (String)filename);
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            DeclarationContext declarationContext = RubyArguments.getDeclarationContext((Frame)frame);
            RubyRootNode rootNode = this.getContext().getCodeLoader().parse(source, code.getEncoding(), ParserContext.EVAL, frame, ownScopeForAssignments, this);
            return this.getContext().getCodeLoader().prepareExecute(ParserContext.EVAL, declarationContext, rootNode, frame, RubyArguments.getSelf((Frame)frame));
        }

        protected RootNodeWrapper compileSource(VirtualFrame frame, DynamicObject sourceText) {
            assert (RubyGuards.isRubyString(sourceText));
            DynamicObject callerBinding = this.getCallerBinding(frame);
            MaterializedFrame parentFrame = Layouts.BINDING.getFrame(callerBinding);
            Encoding encoding = Layouts.STRING.getRope(sourceText).getEncoding();
            Source source = Source.fromText((CharSequence)sourceText.toString(), (String)"(eval)");
            TranslatorDriver translator = new TranslatorDriver(this.getContext());
            return new RootNodeWrapper(translator.parse(this.getContext(), source, encoding, ParserContext.EVAL, null, null, parentFrame, true, this));
        }

        protected boolean parseDependsOnDeclarationFrame(RootNodeWrapper rootNode) {
            return rootNode.getRootNode().needsDeclarationFrame();
        }

        protected CallTarget createCallTarget(RootNodeWrapper rootNode) {
            return Truffle.getRuntime().createCallTarget((RootNode)rootNode.rootNode);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().EVAL_CACHE;
        }

        protected static class RootNodeWrapper {
            private final RubyRootNode rootNode;

            public RootNodeWrapper(RubyRootNode rootNode) {
                this.rootNode = rootNode;
            }

            public RubyRootNode getRootNode() {
                return this.rootNode;
            }
        }
    }

    @CoreMethod(names={"dup"}, taintFromSelf=true)
    public static abstract class DupNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CopyNode copyNode;
        @Node.Child
        private CallDispatchHeadNode initializeDupNode;

        public DupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.copyNode = KernelNodesFactory.CopyNodeFactory.create(context, sourceSection, null);
            this.initializeDupNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public DynamicObject dup(VirtualFrame frame, DynamicObject self) {
            DynamicObject newObject = this.copyNode.executeCopy(frame, self);
            this.initializeDupNode.call(frame, newObject, "initialize_dup", null, self);
            return newObject;
        }
    }

    @CoreMethod(names={"clone"}, taintFromSelf=true)
    public static abstract class CloneNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile frozenProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private CopyNode copyNode;
        @Node.Child
        private CallDispatchHeadNode initializeCloneNode;
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private FreezeNode freezeNode;
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public CloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.copyNode = KernelNodesFactory.CopyNodeFactory.create(context, sourceSection, null);
            this.initializeCloneNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
            this.isFrozenNode = IsFrozenNodeGen.create(context, sourceSection, null);
            this.freezeNode = FreezeNodeGen.create(context, sourceSection, null);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject clone(VirtualFrame frame, DynamicObject self) {
            CompilerDirectives.transferToInterpreter();
            DynamicObject newObject = this.copyNode.executeCopy(frame, self);
            if (Layouts.CLASS.getIsSingleton(Layouts.BASIC_OBJECT.getMetaClass(self))) {
                Layouts.MODULE.getFields(this.singletonClassNode.executeSingletonClass(newObject)).initCopy(Layouts.BASIC_OBJECT.getMetaClass(self));
            }
            this.initializeCloneNode.call(frame, newObject, "initialize_clone", null, self);
            if (this.frozenProfile.profile(this.isFrozenNode.executeIsFrozen(self))) {
                this.freezeNode.executeFreeze(newObject);
            }
            return newObject;
        }
    }

    public static abstract class CopyNode
    extends UnaryCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode allocateNode;

        public CopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = DispatchHeadNodeFactory.createMethodCall(context, true);
        }

        public abstract DynamicObject executeCopy(VirtualFrame var1, DynamicObject var2);

        @Specialization
        public DynamicObject copy(VirtualFrame frame, DynamicObject self) {
            DynamicObject rubyClass = Layouts.BASIC_OBJECT.getLogicalClass(self);
            DynamicObject newObject = (DynamicObject)this.allocateNode.call(frame, rubyClass, "allocate", null, new Object[0]);
            this.copyInstanceVariables(self, newObject);
            return newObject;
        }

        @CompilerDirectives.TruffleBoundary
        private void copyInstanceVariables(DynamicObject from, DynamicObject to) {
            for (Property property : from.getShape().getProperties()) {
                if (!(property.getKey() instanceof String)) continue;
                to.define(property.getKey(), property.get(from, from.getShape()), 0);
            }
        }
    }

    @CoreMethod(names={"class"})
    public static abstract class KernelClassNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private LogicalClassNode classNode;

        public KernelClassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = LogicalClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject getClass(VirtualFrame frame, Object self) {
            return this.classNode.executeLogicalClass(self);
        }
    }

    @CoreMethod(names={"caller_locations"}, isModuleFunction=true, optional=2, lowerFixnumParameters={0, 1})
    public static abstract class CallerLocationsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject callerLocations(NotProvided omit, NotProvided length) {
            return this.callerLocations(1, -1);
        }

        @Specialization
        public DynamicObject callerLocations(int omit, NotProvided length) {
            return this.callerLocations(omit, -1);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject callerLocations(int omit, int length) {
            DynamicObject threadBacktraceLocationClass = this.coreLibrary().getThreadBacktraceLocationClass();
            Backtrace backtrace = this.getContext().getCallStack().getBacktrace(this, 1 + omit, true, null);
            int locationsCount = backtrace.getActivations().size();
            if (length != -1 && locationsCount > length) {
                locationsCount = length;
            }
            Object[] locations = new Object[locationsCount];
            for (int n = 0; n < locationsCount; ++n) {
                Activation activation = backtrace.getActivations().get(n);
                locations[n] = ThreadBacktraceLocationLayoutImpl.INSTANCE.createThreadBacktraceLocation(Layouts.CLASS.getInstanceFactory(threadBacktraceLocationClass), activation);
            }
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), locations, locations.length);
        }
    }

    @CoreMethod(names={"__callee__"}, needsSelf=false)
    public static abstract class CalleeNameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject calleeName() {
            CompilerDirectives.transferToInterpreter();
            return this.getSymbol(this.getContext().getCallStack().getCallingMethodIgnoringSend().getName());
        }
    }

    @CoreMethod(names={"block_given?"}, isModuleFunction=true, needsCallerFrame=true)
    public static abstract class BlockGivenNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean blockGiven(MaterializedFrame callerFrame, @Cached(value="createBinaryProfile()") ConditionProfile blockProfile) {
            return blockProfile.profile(RubyArguments.getBlock(callerFrame.getArguments()) != null);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean blockGiven(NotProvided noCallerFrame) {
            return RubyArguments.getBlock(Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, false).getArguments()) != null;
        }
    }

    @CoreMethod(names={"binding"}, isModuleFunction=true)
    public static abstract class BindingNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject binding() {
            MaterializedFrame callerFrame = this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.MATERIALIZE, false).materialize();
            return BindingNodes.createBinding(this.getContext(), callerFrame);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SameOrEqualNode equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(new RubyNode[]{null, null});

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object compare(VirtualFrame frame, Object self, Object other) {
            if (this.equalNode.executeSameOrEqual(frame, self, other)) {
                return 0;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"!~"}, required=1)
    public static abstract class NotMatchNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode matchNode;

        public NotMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.matchNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public boolean notMatch(VirtualFrame frame, Object self, Object other) {
            return !this.matchNode.callBoolean(frame, self, "=~", null, other);
        }
    }

    @CoreMethod(names={"=~"}, required=1, needsSelf=false)
    public static abstract class MatchNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject equal(Object other) {
            return this.nil();
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class SameOrEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode referenceEqualNode;
        @Node.Child
        private CallDispatchHeadNode equalNode;
        private final ConditionProfile sameProfile = ConditionProfile.createBinaryProfile();

        public abstract boolean executeSameOrEqual(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public boolean sameOrEqual(VirtualFrame frame, Object a, Object b) {
            if (this.sameProfile.profile(this.areSame(frame, a, b))) {
                return true;
            }
            return this.areEqual(frame, a, b);
        }

        private boolean areSame(VirtualFrame frame, Object left, Object right) {
            if (this.referenceEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.referenceEqualNode = (BasicObjectNodes.ReferenceEqualNode)this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(null, null));
            }
            return this.referenceEqualNode.executeReferenceEqual(frame, left, right);
        }

        private boolean areEqual(VirtualFrame frame, Object left, Object right) {
            if (this.equalNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.equalNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.equalNode.callBoolean(frame, left, "==", null, right);
        }
    }

    @CoreMethod(names={"`"}, isModuleFunction=true, needsSelf=false, required=1, unsafe={UnsafeGroup.IO, UnsafeGroup.PROCESSES})
    public static abstract class BacktickNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toHashNode;

        @Specialization(guards={"isRubyString(command)"})
        public DynamicObject backtick(VirtualFrame frame, DynamicObject command) {
            Process process;
            if (this.toHashNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toHashNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            CompilerDirectives.transferToInterpreter();
            RubyContext context = this.getContext();
            DynamicObject env = context.getCoreLibrary().getENV();
            DynamicObject envAsHash = (DynamicObject)this.toHashNode.call(frame, env, "to_hash", null, new Object[0]);
            ArrayList<String> envp = new ArrayList<String>();
            for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(envAsHash)) {
                envp.add(keyValue.getKey().toString() + "=" + keyValue.getValue().toString());
            }
            try {
                process = Runtime.getRuntime().exec(new String[]{"bash", "-c", command.toString()}, envp.toArray(new String[envp.size()]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            InputStream stdout = process.getInputStream();
            InputStreamReader reader = new InputStreamReader(stdout, StandardCharsets.UTF_8);
            StringBuilder resultBuilder = new StringBuilder();
            try {
                int c;
                while ((c = reader.read()) != -1) {
                    resultBuilder.append((char)c);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.createString(StringOperations.encodeRope(resultBuilder.toString(), EncodingOperations.getEncoding(EncodingNodes.getEncoding("UTF-8"))));
        }
    }
}

