/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.exception.ExceptionOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.backtrace.Backtrace;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;

@CoreClass(name="Exception")
public abstract class ExceptionNodes {

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, null, null);
        }
    }

    @CoreMethod(names={"message"})
    public static abstract class MessageNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object message(DynamicObject exception, @Cached(value="createBinaryProfile()") ConditionProfile messageProfile) {
            Object message = Layouts.EXCEPTION.getMessage(exception);
            if (messageProfile.profile(message == null)) {
                String className = Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(exception)).getName();
                return this.createString(StringOperations.encodeRope(className, (Encoding)UTF8Encoding.INSTANCE));
            }
            return message;
        }
    }

    @CoreMethod(names={"capture_backtrace!"}, optional=1)
    public static abstract class CaptureBacktraceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject captureBacktrace(DynamicObject exception, NotProvided offset) {
            return this.captureBacktrace(exception, 1);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject captureBacktrace(DynamicObject exception, int offset) {
            Backtrace backtrace = this.getContext().getCallStack().getBacktrace(this, offset, exception);
            Layouts.EXCEPTION.setBacktrace(exception, backtrace);
            return this.nil();
        }
    }

    @CoreMethod(names={"backtrace"})
    public static abstract class BacktraceNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ReadObjectFieldNode readCustomBacktraceNode;

        @Specialization
        public Object backtrace(DynamicObject exception, @Cached(value="createBinaryProfile()") ConditionProfile hasCustomBacktraceProfile, @Cached(value="createBinaryProfile()") ConditionProfile hasBacktraceProfile) {
            Object customBacktrace = this.getReadCustomBacktraceNode().execute(exception);
            if (hasCustomBacktraceProfile.profile(customBacktrace != null)) {
                return customBacktrace;
            }
            if (hasBacktraceProfile.profile(Layouts.EXCEPTION.getBacktrace(exception) != null)) {
                return ExceptionOperations.backtraceAsRubyStringArray(this.getContext(), exception, Layouts.EXCEPTION.getBacktrace(exception));
            }
            return this.nil();
        }

        private ReadObjectFieldNode getReadCustomBacktraceNode() {
            if (this.readCustomBacktraceNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readCustomBacktraceNode = (ReadObjectFieldNode)this.insert(ReadObjectFieldNodeGen.create("@custom_backtrace", null));
            }
            return this.readCustomBacktraceNode;
        }
    }

    @CoreMethod(names={"initialize"}, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject initialize(DynamicObject exception, NotProvided message) {
            Layouts.EXCEPTION.setMessage(exception, this.nil());
            return exception;
        }

        @Specialization(guards={"wasProvided(message)"})
        public DynamicObject initialize(DynamicObject exception, Object message) {
            Layouts.EXCEPTION.setMessage(exception, message);
            return exception;
        }
    }
}

