/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.cast.ToIntNodeGen;
import org.jruby.truffle.core.numeric.FloatNodes;
import org.jruby.truffle.core.numeric.FloatNodesFactory;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

@NodeChild(value="child", type=RubyNode.class)
public abstract class ToIntNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toIntNode;
    @Node.Child
    private FloatNodes.ToINode floatToIntNode;
    private final ConditionProfile wasInteger = ConditionProfile.createBinaryProfile();
    private final ConditionProfile wasLong = ConditionProfile.createBinaryProfile();
    private final ConditionProfile wasLongInRange = ConditionProfile.createBinaryProfile();

    public static ToIntNode create() {
        return ToIntNodeGen.create(null);
    }

    public int doInt(VirtualFrame frame, Object object) {
        long longValue;
        Object integerObject = this.executeIntOrLong(frame, object);
        if (this.wasInteger.profile(integerObject instanceof Integer)) {
            return (Integer)integerObject;
        }
        if (this.wasLong.profile(integerObject instanceof Long) && this.wasLongInRange.profile(CoreLibrary.fitsIntoInteger(longValue = ((Long)integerObject).longValue()))) {
            return (int)longValue;
        }
        CompilerDirectives.transferToInterpreter();
        if (RubyGuards.isRubyBignum(object)) {
            throw new RaiseException(this.coreExceptions().rangeError("bignum too big to convert into `long'", (Node)this));
        }
        throw new UnsupportedOperationException(object.getClass().toString());
    }

    public abstract Object executeIntOrLong(VirtualFrame var1, Object var2);

    @Specialization
    public int coerceInt(int value) {
        return value;
    }

    @Specialization
    public long coerceLong(long value) {
        return value;
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public DynamicObject coerceRubyBignum(DynamicObject value) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.coreExceptions().rangeError("bignum too big to convert into `long'", (Node)this));
    }

    @Specialization
    public Object coerceDouble(VirtualFrame frame, double value) {
        if (this.floatToIntNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.floatToIntNode = (FloatNodes.ToINode)this.insert(FloatNodesFactory.ToINodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
        }
        return this.floatToIntNode.executeToI(frame, value);
    }

    @Specialization
    public Object coerceBoolean(VirtualFrame frame, boolean value) {
        return this.coerceObject(frame, value);
    }

    @Specialization(guards={"!isRubyBignum(object)"})
    public Object coerceBasicObject(VirtualFrame frame, DynamicObject object) {
        return this.coerceObject(frame, object);
    }

    private Object coerceObject(VirtualFrame frame, Object object) {
        Object coerced;
        if (this.toIntNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toIntNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        try {
            coerced = this.toIntNode.call(frame, object, "to_int", null, new Object[0]);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getNoMethodErrorClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().typeErrorNoImplicitConversion(object, "Integer", this));
            }
            throw e;
        }
        if (this.coreLibrary().getLogicalClass(coerced) == this.coreLibrary().getFixnumClass()) {
            return coerced;
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.coreExceptions().typeErrorBadCoercion(object, "Integer", "to_int", coerced, this));
    }
}

