/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.array.ArrayDupNode;
import org.jruby.truffle.core.array.ArrayDupNodeGen;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.DispatchNode;
import org.jruby.truffle.language.dispatch.MissingBehavior;

@NodeChild(value="child")
public abstract class SplatCastNode
extends RubyNode {
    private final NilBehavior nilBehavior;
    private final DynamicObject conversionMethod;
    @Node.Child
    private ArrayDupNode dup;
    @Node.Child
    private CallDispatchHeadNode respondToToA;
    @Node.Child
    private BooleanCastNode respondToCast;
    @Node.Child
    private CallDispatchHeadNode toA;

    public SplatCastNode(RubyContext context, SourceSection sourceSection, NilBehavior nilBehavior, boolean useToAry) {
        super(context, sourceSection);
        this.nilBehavior = nilBehavior;
        this.dup = ArrayDupNodeGen.create(context, sourceSection, null);
        this.respondToToA = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.RETURN_MISSING);
        this.respondToCast = BooleanCastNodeGen.create(context, sourceSection, null);
        this.toA = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.RETURN_MISSING);
        String name = useToAry ? "to_ary" : "to_a";
        this.conversionMethod = context.getSymbolTable().getSymbol(name);
    }

    public abstract RubyNode getChild();

    @Specialization(guards={"isNil(nil)"})
    public Object splatNil(VirtualFrame frame, Object nil) {
        switch (this.nilBehavior) {
            case EMPTY_ARRAY: {
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), null, 0);
            }
            case ARRAY_WITH_NIL: {
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new Object[]{this.nil()}, 1);
            }
            case CONVERT: {
                return this.toA.call(frame, nil, "to_a", null, new Object[0]);
            }
            case NIL: {
                return nil;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Specialization(guards={"isRubyArray(array)"})
    public DynamicObject splat(VirtualFrame frame, DynamicObject array) {
        return this.dup.executeDup(frame, array);
    }

    @Specialization(guards={"!isNil(object)", "!isRubyArray(object)"})
    public DynamicObject splat(VirtualFrame frame, Object object) {
        Object respondToResult = this.respondToToA.call(frame, object, "respond_to?", null, this.conversionMethod, true);
        if (respondToResult != DispatchNode.MISSING && this.respondToCast.executeBoolean(frame, respondToResult)) {
            Object array = this.toA.call(frame, object, this.conversionMethod, null, new Object[0]);
            if (RubyGuards.isRubyArray(array)) {
                return (DynamicObject)array;
            }
            if (array == this.nil() || array == DispatchNode.MISSING) {
                CompilerDirectives.transferToInterpreter();
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new Object[]{object}, 1);
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.coreExceptions().typeErrorCantConvertTo(object, "Array", Layouts.SYMBOL.getString(this.conversionMethod), array, this));
        }
        return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new Object[]{object}, 1);
    }

    public static enum NilBehavior {
        EMPTY_ARRAY,
        ARRAY_WITH_NIL,
        NIL,
        CONVERT;

    }
}

