/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.HandleLayout;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;

@GeneratedBy(value=HandleLayout.class)
public class HandleLayoutImpl
extends BasicObjectLayoutImpl
implements HandleLayout {
    public static final HandleLayout INSTANCE = new HandleLayoutImpl();
    protected static final Shape.Allocator HANDLE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey OBJECT_IDENTIFIER = new HiddenKey("object");
    protected static final Property OBJECT_PROPERTY = Property.create((Object)OBJECT_IDENTIFIER, (Location)HANDLE_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);

    protected HandleLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createHandleShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new HandleType(logicalClass, metaClass)).addProperty(OBJECT_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createHandle(DynamicObjectFactory factory, Object object) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (HandleLayoutImpl.createsHandle(factory));
        assert (factory.getShape().hasProperty((Object)OBJECT_IDENTIFIER));
        assert (object != null);
        return factory.newInstance(new Object[]{object});
    }

    @Override
    public boolean isHandle(DynamicObject object) {
        return HandleLayoutImpl.isHandle(object.getShape().getObjectType());
    }

    private static boolean isHandle(ObjectType objectType) {
        return objectType instanceof HandleType;
    }

    private static boolean createsHandle(DynamicObjectFactory factory) {
        return HandleLayoutImpl.isHandle(factory.getShape().getObjectType());
    }

    @Override
    public Object getObject(DynamicObject object) {
        assert (this.isHandle(object));
        assert (object.getShape().hasProperty((Object)OBJECT_IDENTIFIER));
        return OBJECT_PROPERTY.get(object, this.isHandle(object));
    }

    public static class HandleType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public HandleType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public HandleType setLogicalClass(DynamicObject logicalClass) {
            return new HandleType(logicalClass, this.metaClass);
        }

        @Override
        public HandleType setMetaClass(DynamicObject metaClass) {
            return new HandleType(this.logicalClass, metaClass);
        }
    }
}

