/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.runtime.BreakID;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.FrameOnStackMarker;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;

public class BlockDefinitionNode
extends RubyNode {
    private final ProcNodes.Type type;
    private final SharedMethodInfo sharedMethodInfo;
    private final CallTarget callTargetForProcs;
    private final CallTarget callTargetForLambdas;
    private final BreakID breakID;
    @Node.Child
    private ReadFrameSlotNode readFrameOnStackMarkerNode;

    public BlockDefinitionNode(RubyContext context, SourceSection sourceSection, ProcNodes.Type type, SharedMethodInfo sharedMethodInfo, CallTarget callTargetForProcs, CallTarget callTargetForLambdas, BreakID breakID, FrameSlot frameOnStackMarkerSlot) {
        super(context, sourceSection);
        this.type = type;
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTargetForProcs = callTargetForProcs;
        this.callTargetForLambdas = callTargetForLambdas;
        this.breakID = breakID;
        this.readFrameOnStackMarkerNode = frameOnStackMarkerSlot == null ? null : ReadFrameSlotNodeGen.create(frameOnStackMarkerSlot);
    }

    public BreakID getBreakID() {
        return this.breakID;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object frameOnStackMarkerValue;
        FrameOnStackMarker frameOnStackMarker = this.readFrameOnStackMarkerNode == null ? null : ((frameOnStackMarkerValue = this.readFrameOnStackMarkerNode.executeRead((Frame)frame)) instanceof FrameOnStackMarker ? (FrameOnStackMarker)frameOnStackMarkerValue : null);
        return ProcNodes.createRubyProc(this.getContext().getCoreLibrary().getProcFactory(), this.type, this.sharedMethodInfo, this.callTargetForProcs, this.callTargetForLambdas, frame.materialize(), RubyArguments.getMethod(frame.getArguments()), RubyArguments.getSelf(frame.getArguments()), RubyArguments.getBlock(frame.getArguments()), frameOnStackMarker);
    }
}

