/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.nodes.locals.ReadLocalNode;
import org.jruby.truffle.nodes.locals.WriteLocalVariableNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.translator.Translator;

public class ReadLocalVariableNode
extends ReadLocalNode {
    @Node.Child
    private ReadFrameSlotNode readFrameSlotNode;

    public ReadLocalVariableNode(RubyContext context, SourceSection sourceSection, FrameSlot slot) {
        super(context, sourceSection);
        this.readFrameSlotNode = ReadFrameSlotNodeGen.create(slot);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.readFrameSlotNode.executeRead((Frame)frame);
    }

    @Override
    public RubyNode makeWriteNode(RubyNode rhs) {
        return new WriteLocalVariableNode(this.getContext(), this.getSourceSection(), rhs, this.readFrameSlotNode.getFrameSlot());
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        if (Translator.FRAME_LOCAL_GLOBAL_VARIABLES.contains(this.readFrameSlotNode.getFrameSlot().getIdentifier())) {
            if (Translator.ALWAYS_DEFINED_GLOBALS.contains(this.readFrameSlotNode.getFrameSlot().getIdentifier()) || this.readFrameSlotNode.executeRead((Frame)frame) != this.nil()) {
                return this.create7BitString(StringOperations.encodeByteList("global-variable", (Encoding)UTF8Encoding.INSTANCE));
            }
            return this.nil();
        }
        return this.create7BitString(StringOperations.encodeByteList("local-variable", (Encoding)UTF8Encoding.INSTANCE));
    }
}

