/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.exceptions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

public class EnsureNode
extends RubyNode {
    @Node.Child
    private RubyNode tryPart;
    @Node.Child
    private RubyNode ensurePart;
    private final BranchProfile rubyExceptionPath = BranchProfile.create();
    private final BranchProfile javaExceptionPath = BranchProfile.create();

    public EnsureNode(RubyContext context, SourceSection sourceSection, RubyNode tryPart, RubyNode ensurePart) {
        super(context, sourceSection);
        this.tryPart = tryPart;
        this.ensurePart = ensurePart;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value;
        try {
            value = this.tryPart.execute(frame);
        }
        catch (RaiseException exception) {
            this.rubyExceptionPath.enter();
            throw this.setLastExceptionAndRunEnsure(frame, exception);
        }
        catch (Throwable throwable) {
            this.javaExceptionPath.enter();
            this.ensurePart.executeVoid(frame);
            throw throwable;
        }
        this.ensurePart.executeVoid(frame);
        return value;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        try {
            this.tryPart.executeVoid(frame);
        }
        catch (RaiseException exception) {
            this.rubyExceptionPath.enter();
            throw this.setLastExceptionAndRunEnsure(frame, exception);
        }
        catch (Throwable throwable) {
            this.javaExceptionPath.enter();
            this.ensurePart.executeVoid(frame);
            throw throwable;
        }
        this.ensurePart.executeVoid(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaiseException setLastExceptionAndRunEnsure(VirtualFrame frame, RaiseException exception) {
        DynamicObject threadLocals = Layouts.THREAD.getThreadLocals(this.getContext().getThreadManager().getCurrentThread());
        Object lastException = threadLocals.get((Object)"$!", (Object)this.nil());
        threadLocals.set((Object)"$!", (Object)exception.getRubyException());
        try {
            this.ensurePart.executeVoid(frame);
            RaiseException raiseException = exception;
            return raiseException;
        }
        finally {
            threadLocals.set((Object)"$!", lastException);
        }
    }
}

