/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;

public final class CachedForeignGlobalDispatchNode
extends CachedDispatchNode {
    private final Object cachedName;
    private final TruffleObject language;
    private final int numberOfArguments;
    @Node.Child
    private Node access;

    public CachedForeignGlobalDispatchNode(RubyContext context, DispatchNode next, Object cachedName, TruffleObject language, int numberOfArguments) {
        super(context, cachedName, next, DispatchAction.CALL_METHOD);
        this.cachedName = cachedName;
        this.language = language;
        this.numberOfArguments = numberOfArguments;
        this.access = this.create();
    }

    private Node create() {
        return Message.createInvoke((int)(this.numberOfArguments + 1)).createNode();
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object[] argumentsObjects) {
        if (receiverObject instanceof DynamicObject) {
            if (argumentsObjects.length == this.numberOfArguments) {
                Object[] args = new Object[argumentsObjects.length + 2];
                ArrayUtils.arraycopy(argumentsObjects, 0, args, 2, argumentsObjects.length);
                args[0] = this.cachedName;
                args[1] = this.language;
                return ForeignAccess.execute((Node)this.access, (VirtualFrame)frame, (TruffleObject)this.language, (Object[])args);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Varargs are not supported");
        }
        CompilerDirectives.transferToInterpreter();
        throw new IllegalStateException("Should not happen");
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return true;
    }
}

