/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import org.jruby.truffle.nodes.StringCachingGuards;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

@CoreClass(name="Truffle::Interop")
public abstract class TruffleInteropNodes {

    @CoreMethod(names={"java_string_to_ruby"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class JavaStringToRubyNode
    extends CoreMethodArrayArgumentsNode {
        public JavaStringToRubyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public DynamicObject javaStringToRuby(String string) {
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), ByteList.create((CharSequence)string), 0, null);
        }
    }

    @CoreMethod(names={"eval"}, isModuleFunction=true, needsSelf=false, required=2)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class EvalNode
    extends CoreMethodArrayArgumentsNode {
        public EvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(mimeType)", "isRubyString(source)", "byteListsEqual(mimeType, cachedMimeType)", "byteListsEqual(source, cachedSource)"}, limit="getCacheLimit()")
        public Object evalCached(VirtualFrame frame, DynamicObject mimeType, DynamicObject source, @Cached(value="privatizeByteList(mimeType)") ByteList cachedMimeType, @Cached(value="privatizeByteList(source)") ByteList cachedSource, @Cached(value="create(parse(mimeType, source))") DirectCallNode callNode) {
            return callNode.call(frame, new Object[0]);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(mimeType)", "isRubyString(source)"}, contains={"evalCached"})
        public Object evalUncached(DynamicObject mimeType, DynamicObject source) {
            return this.parse(mimeType, source).call(new Object[0]);
        }

        protected CallTarget parse(DynamicObject mimeType, DynamicObject source) {
            String mimeTypeString = mimeType.toString();
            Source sourceObject = Source.fromText((CharSequence)source.toString(), (String)"(eval)").withMimeType(mimeTypeString);
            try {
                return this.getContext().getEnv().parse(sourceObject, new String[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().EVAL_CACHE;
        }
    }

    @CoreMethod(names={"import"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class ImportNode
    extends CoreMethodArrayArgumentsNode {
        public ImportNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public Object importObject(DynamicObject name) {
            return this.getContext().importObject(name);
        }
    }

    @CoreMethod(names={"export"}, isModuleFunction=true, needsSelf=false, required=2)
    public static abstract class ExportNode
    extends CoreMethodArrayArgumentsNode {
        public ExportNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(name)"})
        public Object export(VirtualFrame frame, DynamicObject name, TruffleObject object) {
            this.getContext().exportObject(name, object);
            return object;
        }

        protected static String rubyStringToString(DynamicObject rubyString) {
            return rubyString.toString();
        }
    }

    @CoreMethod(names={"size"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class GetSizeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private Node node = Message.GET_SIZE.createNode();

        public GetSizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, String receiver) {
            return receiver.length();
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, TruffleObject receiver) {
            return ForeignAccess.execute((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[0]);
        }
    }

    @CoreMethod(names={"execute"}, isModuleFunction=true, needsSelf=false, required=1, rest=true)
    public static abstract class ExecuteNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private Node node;

        public ExecuteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, TruffleObject receiver, Object[] args) {
            if (this.node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.node = Message.createExecute((int)args.length).createNode();
            }
            return ForeignAccess.execute((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])args);
        }
    }

    @CoreMethod(names={"unbox_value"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class UnboxValueNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private Node node = Message.UNBOX.createNode();

        public UnboxValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject executeForeign(VirtualFrame frame, CharSequence receiver) {
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), ByteList.create((CharSequence)receiver), 0, null);
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, TruffleObject receiver) {
            return ForeignAccess.execute((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[0]);
        }
    }

    @CoreMethod(names={"write_property"}, isModuleFunction=true, needsSelf=false, required=3)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class WritePropertyNode
    extends CoreMethodArrayArgumentsNode {
        public WritePropertyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isRubySymbol(identifier)", "!isRubyString(identifier)"})
        public Object writeProperty(VirtualFrame frame, TruffleObject receiver, Object identifier, Object value, @Cached(value="createWriteNode()") Node writeNode) {
            return ForeignAccess.execute((Node)writeNode, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[]{identifier, value});
        }

        @Specialization(guards={"isRubySymbol(identifier)", "identifier == cachedIdentifier"})
        public Object writeProperty(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, Object value, @Cached(value="identifier") DynamicObject cachedIdentifier, @Cached(value="identifier.toString()") String identifierString, @Cached(value="createWriteNode()") Node writeNode) {
            return ForeignAccess.execute((Node)writeNode, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[]{identifierString, value});
        }

        @Specialization(guards={"isRubyString(identifier)", "byteListsEqual(identifier, cachedIdentifier)"})
        public Object writeProperty(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, Object value, @Cached(value="privatizeByteList(identifier)") ByteList cachedIdentifier, @Cached(value="identifier.toString()") String identifierString, @Cached(value="createWriteNode()") Node writeNode) {
            return ForeignAccess.execute((Node)writeNode, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[]{identifierString, value});
        }

        protected static Node createWriteNode() {
            return Message.WRITE.createNode();
        }
    }

    @CoreMethod(names={"read_property"}, isModuleFunction=true, needsSelf=false, required=2)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class ReadPropertyNode
    extends CoreMethodArrayArgumentsNode {
        public ReadPropertyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object readProperty(String receiver, int identifier) {
            return Character.valueOf(receiver.charAt(identifier));
        }

        @Specialization
        public Object readProperty(String receiver, long identifier) {
            return Character.valueOf(receiver.charAt((int)identifier));
        }

        @Specialization(guards={"!isRubySymbol(identifier)", "!isRubyString(identifier)"})
        public Object readProperty(VirtualFrame frame, TruffleObject receiver, Object identifier, @Cached(value="createReadNode()") Node readNode) {
            return ForeignAccess.execute((Node)readNode, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[]{identifier});
        }

        @Specialization(guards={"isRubySymbol(identifier)", "identifier == cachedIdentifier"})
        public Object readProperty(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, @Cached(value="identifier") DynamicObject cachedIdentifier, @Cached(value="identifier.toString()") String identifierString, @Cached(value="createReadNode()") Node readNode) {
            return ForeignAccess.execute((Node)readNode, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[]{identifierString});
        }

        @Specialization(guards={"isRubyString(identifier)", "byteListsEqual(identifier, cachedIdentifier)"})
        public Object readProperty(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, @Cached(value="privatizeByteList(identifier)") ByteList cachedIdentifier, @Cached(value="identifier.toString()") String identifierString, @Cached(value="createReadNode()") Node readNode) {
            return ForeignAccess.execute((Node)readNode, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[]{identifierString});
        }

        protected static Node createReadNode() {
            return Message.READ.createNode();
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().EVAL_CACHE;
        }
    }

    @CoreMethod(names={"has_size_property?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class HasSizePropertyNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private Node node = Message.HAS_SIZE.createNode();

        public HasSizePropertyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean hasSizeProperty(VirtualFrame frame, TruffleObject receiver) {
            return (Boolean)ForeignAccess.execute((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[0]);
        }
    }

    @CoreMethod(names={"null?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class IsNullNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private Node node = Message.IS_NULL.createNode();

        public IsNullNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isNull(VirtualFrame frame, TruffleObject receiver) {
            return (Boolean)ForeignAccess.execute((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[0]);
        }
    }

    @CoreMethod(names={"boxed_primitive?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class IsBoxedPrimitiveNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private Node node = Message.IS_BOXED.createNode();

        public IsBoxedPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isBoxedPrimitive(VirtualFrame frame, CharSequence receiver) {
            return true;
        }

        @Specialization
        public boolean isBoxedPrimitive(VirtualFrame frame, TruffleObject receiver) {
            return (Boolean)ForeignAccess.execute((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[0]);
        }

        @Specialization(guards={"!isTruffleObject(receiver)", "!isJavaCharSequence(receiver)"})
        public boolean isBoxedPrimitive(VirtualFrame frame, Object receiver) {
            return false;
        }
    }

    @CoreMethod(names={"executable?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class IsExecutableNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private Node node = Message.IS_EXECUTABLE.createNode();

        public IsExecutableNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isExecutable(VirtualFrame frame, TruffleObject receiver) {
            return (Boolean)ForeignAccess.execute((Node)this.node, (VirtualFrame)frame, (TruffleObject)receiver, (Object[])new Object[]{receiver});
        }
    }

    @CoreMethod(names={"interop_to_ruby_primitive"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class InteropToRubyNode
    extends CoreMethodArrayArgumentsNode {
        public InteropToRubyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int convert(byte value) {
            return value;
        }

        @Specialization
        public int convert(short value) {
            return value;
        }

        @Specialization
        public int convert(char value) {
            return value;
        }

        @Specialization
        public int convert(int value) {
            return value;
        }

        @Specialization
        public long convert(long value) {
            return value;
        }

        @Specialization
        public double convert(float value) {
            return value;
        }

        @Specialization
        public double convert(double value) {
            return value;
        }

        @Specialization
        public int convert(String value) {
            return value.charAt(0);
        }
    }
}

