/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.TrueClassNodes;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=TrueClassNodes.class)
public final class TrueClassNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AndNodeFactory.getInstance(), OrNodeFactory.getInstance(), XorNodeFactory.getInstance());
    }

    @GeneratedBy(value=TrueClassNodes.XorNode.class)
    public static final class XorNodeFactory
    extends NodeFactoryBase<TrueClassNodes.XorNode> {
        private static XorNodeFactory xorNodeFactoryInstance;

        private XorNodeFactory() {
            super(TrueClassNodes.XorNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public TrueClassNodes.XorNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return XorNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrueClassNodes.XorNode> getInstance() {
            if (xorNodeFactoryInstance == null) {
                xorNodeFactoryInstance = new XorNodeFactory();
            }
            return xorNodeFactoryInstance;
        }

        public static TrueClassNodes.XorNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new XorNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=TrueClassNodes.XorNode.class)
        public static final class XorNodeGen
        extends TrueClassNodes.XorNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private XorNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = this.createCast(operand);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean operandValue_;
                try {
                    operandValue_ = this.operand_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.xor(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=TrueClassNodes.OrNode.class)
    public static final class OrNodeFactory
    extends NodeFactoryBase<TrueClassNodes.OrNode> {
        private static OrNodeFactory orNodeFactoryInstance;

        private OrNodeFactory() {
            super(TrueClassNodes.OrNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public TrueClassNodes.OrNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return OrNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrueClassNodes.OrNode> getInstance() {
            if (orNodeFactoryInstance == null) {
                orNodeFactoryInstance = new OrNodeFactory();
            }
            return orNodeFactoryInstance;
        }

        public static TrueClassNodes.OrNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new OrNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrueClassNodes.OrNode.class)
        public static final class OrNodeGen
        extends TrueClassNodes.OrNode {
            @Node.Child
            private RubyNode arguments0_;

            private OrNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.or(arguments0Value_);
            }
        }
    }

    @GeneratedBy(value=TrueClassNodes.AndNode.class)
    public static final class AndNodeFactory
    extends NodeFactoryBase<TrueClassNodes.AndNode> {
        private static AndNodeFactory andNodeFactoryInstance;

        private AndNodeFactory() {
            super(TrueClassNodes.AndNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public TrueClassNodes.AndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return AndNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrueClassNodes.AndNode> getInstance() {
            if (andNodeFactoryInstance == null) {
                andNodeFactoryInstance = new AndNodeFactory();
            }
            return andNodeFactoryInstance;
        }

        public static TrueClassNodes.AndNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new AndNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=TrueClassNodes.AndNode.class)
        public static final class AndNodeGen
        extends TrueClassNodes.AndNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AndNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = this.createCast(operand);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                boolean operandValue_;
                try {
                    operandValue_ = this.operand_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.and(operandValue_);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }
}

