/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.format.parser.PrintfCompiler;
import org.jruby.truffle.format.runtime.PackResult;
import org.jruby.truffle.format.runtime.exceptions.CantCompressNegativeException;
import org.jruby.truffle.format.runtime.exceptions.CantConvertException;
import org.jruby.truffle.format.runtime.exceptions.FormatException;
import org.jruby.truffle.format.runtime.exceptions.NoImplicitConversionException;
import org.jruby.truffle.format.runtime.exceptions.OutsideOfStringException;
import org.jruby.truffle.format.runtime.exceptions.PackException;
import org.jruby.truffle.format.runtime.exceptions.RangeException;
import org.jruby.truffle.format.runtime.exceptions.TooFewArgumentsException;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.StringCachingGuards;
import org.jruby.truffle.nodes.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.nodes.cast.NumericToFloatNode;
import org.jruby.truffle.nodes.cast.NumericToFloatNodeGen;
import org.jruby.truffle.nodes.coerce.NameToJavaStringNode;
import org.jruby.truffle.nodes.coerce.NameToJavaStringNodeGen;
import org.jruby.truffle.nodes.coerce.NameToSymbolOrStringNodeGen;
import org.jruby.truffle.nodes.coerce.ToPathNodeGen;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.EncodingNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.core.ProcNodesFactory;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.methods.LookupMethodNode;
import org.jruby.truffle.nodes.methods.LookupMethodNodeGen;
import org.jruby.truffle.nodes.objects.ClassNode;
import org.jruby.truffle.nodes.objects.ClassNodeGen;
import org.jruby.truffle.nodes.objects.FreezeNode;
import org.jruby.truffle.nodes.objects.FreezeNodeGen;
import org.jruby.truffle.nodes.objects.IsANode;
import org.jruby.truffle.nodes.objects.IsANodeGen;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.nodes.objects.IsTaintedNode;
import org.jruby.truffle.nodes.objects.IsTaintedNodeGen;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeGen;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeGen;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.nodes.objects.TaintNodeGen;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNodeGen;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNodeGen;
import org.jruby.truffle.nodes.rubinius.ObjectPrimitiveNodes;
import org.jruby.truffle.nodes.rubinius.ObjectPrimitiveNodesFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.Options;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.ThreadLocalObject;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.EncodingOperations;
import org.jruby.truffle.runtime.core.MethodFilter;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.layouts.ThreadBacktraceLocationLayoutImpl;
import org.jruby.truffle.runtime.loader.FeatureLoader;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.ByteList;

@CoreClass(name="Kernel")
public abstract class KernelNodes {

    @CoreMethod(names={"untaint"})
    public static abstract class UntaintNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private IsTaintedNode isTaintedNode;
        @Node.Child
        private WriteHeadObjectFieldNode writeTaintNode;

        public UntaintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isFrozenNode = IsFrozenNodeGen.create(context, sourceSection, null);
            this.isTaintedNode = IsTaintedNodeGen.create(context, sourceSection, null);
            this.writeTaintNode = WriteHeadObjectFieldNodeGen.create(Layouts.TAINTED_IDENTIFIER);
        }

        @Specialization
        public Object taint(DynamicObject object) {
            if (!this.isTaintedNode.executeIsTainted(object)) {
                return object;
            }
            if (this.isFrozenNode.executeIsFrozen(object)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().frozenError(Layouts.MODULE.getFields(this.getContext().getCoreLibrary().getLogicalClass(object)).getName(), this));
            }
            this.writeTaintNode.execute(object, false);
            return object;
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassNode classNode;
        @Node.Child
        private ObjectPrimitiveNodes.ObjectIDPrimitiveNode objectIDNode;
        @Node.Child
        private ToHexStringNode toHexStringNode;

        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeGen.create(context, sourceSection, null);
            this.objectIDNode = ObjectPrimitiveNodesFactory.ObjectIDPrimitiveNodeFactory.create(context, sourceSection, new RubyNode[]{null});
            this.toHexStringNode = KernelNodesFactory.ToHexStringNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        public abstract DynamicObject executeToS(VirtualFrame var1, Object var2);

        @Specialization
        public DynamicObject toS(VirtualFrame frame, Object self) {
            CompilerDirectives.transferToInterpreter();
            String className = Layouts.MODULE.getFields(this.classNode.executeGetClass(frame, self)).getName();
            Object id = this.objectIDNode.executeObjectID(frame, self);
            String hexID = this.toHexStringNode.executeToHexString(frame, id);
            return this.createString(StringOperations.encodeByteList("#<" + className + ":0x" + hexID + ">", (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    public static abstract class ToHexStringNode
    extends CoreMethodArrayArgumentsNode {
        public ToHexStringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract String executeToHexString(VirtualFrame var1, Object var2);

        @Specialization
        public String toHexString(int value) {
            return this.toHexString((long)value);
        }

        @Specialization
        public String toHexString(long value) {
            return Long.toHexString(value);
        }

        @Specialization(guards={"isRubyBignum(value)"})
        public String toHexString(DynamicObject value) {
            return Layouts.BIGNUM.getValue(value).toString(16);
        }
    }

    @CoreMethod(names={"tainted?"})
    public static abstract class KernelIsTaintedNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsTaintedNode isTaintedNode;

        public KernelIsTaintedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isTainted(Object object) {
            if (this.isTaintedNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isTaintedNode = (IsTaintedNode)this.insert(IsTaintedNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.isTaintedNode.executeIsTainted(object);
        }
    }

    @CoreMethod(names={"taint"})
    public static abstract class KernelTaintNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode;

        public KernelTaintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object taint(Object object) {
            if (this.taintNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.taintNode.executeTaint(object);
        }
    }

    @CoreMethod(names={"format", "sprintf"}, isModuleFunction=true, rest=true, required=1, taintFromParameter=0)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class SprintfNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode;

        public SprintfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(format)", "byteListsEqual(format, cachedFormat)"})
        public DynamicObject formatCached(VirtualFrame frame, DynamicObject format, Object[] arguments, @Cached(value="privatizeByteList(format)") ByteList cachedFormat, @Cached(value="byteListLength(cachedFormat)") int cachedFormatLength, @Cached(value="create(compileFormat(format))") DirectCallNode callPackNode) {
            PackResult result;
            try {
                result = (PackResult)callPackNode.call(frame, new Object[]{arguments, arguments.length});
            }
            catch (PackException e) {
                CompilerDirectives.transferToInterpreter();
                throw this.handleException(e);
            }
            return this.finishFormat(cachedFormatLength, result);
        }

        @Specialization(guards={"isRubyString(format)"}, contains={"formatCached"})
        public DynamicObject formatUncached(VirtualFrame frame, DynamicObject format, Object[] arguments, @Cached(value="create()") IndirectCallNode callPackNode) {
            PackResult result;
            try {
                result = (PackResult)callPackNode.call(frame, this.compileFormat(format), new Object[]{arguments, arguments.length});
            }
            catch (PackException e) {
                CompilerDirectives.transferToInterpreter();
                throw this.handleException(e);
            }
            return this.finishFormat(StringOperations.getByteList(format).length(), result);
        }

        private RuntimeException handleException(PackException exception) {
            try {
                throw exception;
            }
            catch (TooFewArgumentsException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("too few arguments", this));
            }
            catch (NoImplicitConversionException e) {
                return new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(e.getObject(), e.getTarget(), this));
            }
            catch (OutsideOfStringException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("X outside of string", this));
            }
            catch (CantCompressNegativeException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("can't compress negative numbers", this));
            }
            catch (RangeException e) {
                return new RaiseException(this.getContext().getCoreLibrary().rangeError(e.getMessage(), (Node)this));
            }
            catch (CantConvertException e) {
                return new RaiseException(this.getContext().getCoreLibrary().typeError(e.getMessage(), this));
            }
        }

        private DynamicObject finishFormat(int formatLength, PackResult result) {
            DynamicObject string = this.createString(new ByteList((byte[])result.getOutput(), 0, result.getOutputLength()));
            if (formatLength == 0) {
                StringOperations.forceEncoding(string, (Encoding)USASCIIEncoding.INSTANCE);
            } else {
                switch (result.getEncoding()) {
                    case DEFAULT: 
                    case ASCII_8BIT: {
                        break;
                    }
                    case US_ASCII: {
                        StringOperations.forceEncoding(string, (Encoding)USASCIIEncoding.INSTANCE);
                        break;
                    }
                    case UTF_8: {
                        StringOperations.forceEncoding(string, (Encoding)UTF8Encoding.INSTANCE);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            if (result.isTainted()) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
                }
                this.taintNode.executeTaint(string);
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        protected CallTarget compileFormat(DynamicObject format) {
            assert (RubyGuards.isRubyString(format));
            try {
                return new PrintfCompiler(this.getContext(), this).compile(StringOperations.getByteList(format));
            }
            catch (FormatException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError(e.getMessage(), this));
            }
        }
    }

    @CoreMethod(names={"sleep"}, isModuleFunction=true, optional=1)
    public static abstract class SleepNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NumericToFloatNode floatCastNode;

        public SleepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long sleep(NotProvided duration) {
            return this.doSleepMillis(Long.MAX_VALUE);
        }

        @Specialization
        public long sleep(int duration) {
            return this.doSleepMillis((long)duration * 1000L);
        }

        @Specialization
        public long sleep(long duration) {
            return this.doSleepMillis(duration * 1000L);
        }

        @Specialization
        public long sleep(double duration) {
            return this.doSleepMillis((long)(duration * 1000.0));
        }

        @Specialization(guards={"isRubiniusUndefined(duration)"})
        public long sleep(DynamicObject duration) {
            return this.sleep(NotProvided.INSTANCE);
        }

        @Specialization(guards={"!isRubiniusUndefined(duration)"})
        public long sleep(VirtualFrame frame, DynamicObject duration) {
            if (this.floatCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.floatCastNode = (NumericToFloatNode)this.insert(NumericToFloatNodeGen.create(this.getContext(), this.getSourceSection(), "to_f", null));
            }
            return this.sleep(this.floatCastNode.executeDouble(frame, duration));
        }

        @CompilerDirectives.TruffleBoundary
        private long doSleepMillis(long durationInMillis) {
            if (durationInMillis < 0L) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("time interval must be positive", this));
            }
            DynamicObject thread = this.getContext().getThreadManager().getCurrentThread();
            Layouts.THREAD.getWakeUp(thread).set(false);
            return SleepNode.sleepFor(this, this.getContext(), durationInMillis);
        }

        public static long sleepFor(Node currentNode, RubyContext context, final long durationInMillis) {
            assert (durationInMillis >= 0L);
            final DynamicObject thread = context.getThreadManager().getCurrentThread();
            final long start = System.currentTimeMillis();
            long slept = context.getThreadManager().runUntilResult(currentNode, new ThreadManager.BlockingAction<Long>(){

                @Override
                public Long block() throws InterruptedException {
                    long now = System.currentTimeMillis();
                    long slept = now - start;
                    if (slept >= durationInMillis || Layouts.THREAD.getWakeUp(thread).getAndSet(false)) {
                        return slept;
                    }
                    Thread.sleep(durationInMillis - slept);
                    return System.currentTimeMillis() - start;
                }
            });
            return slept / 1000L;
        }
    }

    @CoreMethod(names={"String"}, isModuleFunction=true, required=1)
    public static abstract class StringNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toS;

        public StringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toS = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization(guards={"isRubyString(value)"})
        public DynamicObject string(DynamicObject value) {
            return value;
        }

        @Specialization(guards={"!isRubyString(value)"})
        public Object string(VirtualFrame frame, Object value) {
            return this.toS.call(frame, value, "to_s", null, new Object[0]);
        }
    }

    @CoreMethod(names={"singleton_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class SingletonMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public SingletonMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        public abstract DynamicObject executeSingletonMethods(VirtualFrame var1, Object var2, boolean var3);

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public DynamicObject singletonMethods(Object self, boolean includeAncestors) {
            DynamicObject metaClass = this.metaClassNode.executeMetaClass(self);
            if (!Layouts.CLASS.getIsSingleton(metaClass)) {
                return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
            }
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(metaClass).filterSingletonMethods(this.getContext(), includeAncestors, MethodFilter.PUBLIC_PROTECTED).toArray();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"singleton_class"})
    public static abstract class SingletonClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public SingletonClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject singletonClass(Object self) {
            return this.singletonClassNode.executeSingletonClass(self);
        }
    }

    @CoreMethod(names={"set_trace_func"}, isModuleFunction=true, required=1)
    public static abstract class SetTraceFuncNode
    extends CoreMethodArrayArgumentsNode {
        public SetTraceFuncNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNil(nil)"})
        public DynamicObject setTraceFunc(Object nil) {
            this.getContext().getTraceManager().setTraceFunc(null);
            return this.nil();
        }

        @Specialization(guards={"isRubyProc(traceFunc)"})
        public DynamicObject setTraceFunc(DynamicObject traceFunc) {
            this.getContext().getTraceManager().setTraceFunc(traceFunc);
            return traceFunc;
        }
    }

    @CoreMethod(names={"respond_to_missing?"}, required=2)
    public static abstract class RespondToMissingNode
    extends CoreMethodArrayArgumentsNode {
        public RespondToMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(name)"})
        public boolean doesRespondToMissingString(Object object, DynamicObject name, Object unusedIncludeAll) {
            return false;
        }

        @Specialization(guards={"isRubySymbol(name)"})
        public boolean doesRespondToMissingSymbol(Object object, DynamicObject name, Object unusedIncludeAll) {
            return false;
        }
    }

    @CoreMethod(names={"respond_to?"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="includeProtectedAndPrivate")})
    public static abstract class RespondToNode
    extends CoreMethodNode {
        @Node.Child
        private DoesRespondDispatchHeadNode dispatch;
        @Node.Child
        private DoesRespondDispatchHeadNode dispatchIgnoreVisibility;
        @Node.Child
        private DoesRespondDispatchHeadNode dispatchRespondToMissing;
        @Node.Child
        private CallDispatchHeadNode respondToMissingNode;
        private final ConditionProfile ignoreVisibilityProfile = ConditionProfile.createBinaryProfile();

        public RespondToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = new DoesRespondDispatchHeadNode(context, false);
            this.dispatchIgnoreVisibility = new DoesRespondDispatchHeadNode(context, true);
            this.dispatchRespondToMissing = new DoesRespondDispatchHeadNode(context, true);
        }

        public abstract boolean executeDoesRespondTo(VirtualFrame var1, Object var2, Object var3, boolean var4);

        @CreateCast(value={"includeProtectedAndPrivate"})
        public RubyNode coerceToBoolean(RubyNode includeProtectedAndPrivate) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), false, includeProtectedAndPrivate);
        }

        @Specialization(guards={"isRubyString(name)"})
        public boolean doesRespondToString(VirtualFrame frame, Object object, DynamicObject name, boolean includeProtectedAndPrivate) {
            boolean ret = this.ignoreVisibilityProfile.profile(includeProtectedAndPrivate) ? this.dispatchIgnoreVisibility.doesRespondTo(frame, name, object) : this.dispatch.doesRespondTo(frame, name, object);
            if (ret) {
                return true;
            }
            if (this.dispatchRespondToMissing.doesRespondTo(frame, "respond_to_missing?", object)) {
                return this.respondToMissing(frame, object, name, includeProtectedAndPrivate);
            }
            return false;
        }

        @Specialization(guards={"isRubySymbol(name)"})
        public boolean doesRespondToSymbol(VirtualFrame frame, Object object, DynamicObject name, boolean includeProtectedAndPrivate) {
            boolean ret = this.ignoreVisibilityProfile.profile(includeProtectedAndPrivate) ? this.dispatchIgnoreVisibility.doesRespondTo(frame, name, object) : this.dispatch.doesRespondTo(frame, name, object);
            if (ret) {
                return true;
            }
            if (this.dispatchRespondToMissing.doesRespondTo(frame, "respond_to_missing?", object)) {
                return this.respondToMissing(frame, object, name, includeProtectedAndPrivate);
            }
            return false;
        }

        private boolean respondToMissing(VirtualFrame frame, Object object, DynamicObject name, boolean includeProtectedAndPrivate) {
            if (this.respondToMissingNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToMissingNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            return this.respondToMissingNode.callBoolean(frame, object, "respond_to_missing?", null, name, includeProtectedAndPrivate);
        }
    }

    @CoreMethod(names={"require_relative"}, isModuleFunction=true, required=1)
    public static abstract class RequireRelativeNode
    extends CoreMethodArrayArgumentsNode {
        public RequireRelativeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(feature)"})
        public boolean requireRelative(DynamicObject feature) {
            String featurePath;
            String featureString;
            FeatureLoader featureLoader = this.getContext().getFeatureLoader();
            if (featureLoader.isAbsolutePath(featureString = feature.toString())) {
                featurePath = featureString;
            } else {
                Source source = RubyCallStack.getCallerFrame(this.getContext()).getCallNode().getEncapsulatingSourceSection().getSource();
                String sourcePath = featureLoader.getSourcePath(source);
                if (sourcePath == null) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().loadError("cannot infer basepath", featureString, this));
                }
                featurePath = this.dirname(sourcePath) + "/" + featureString;
            }
            try {
                featureLoader.require(featurePath, this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        private String dirname(String path) {
            int lastSlash = path.lastIndexOf(47);
            assert (lastSlash > 0);
            return path.substring(0, lastSlash);
        }
    }

    @CoreMethod(names={"require"}, isModuleFunction=true, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="feature")})
    public static abstract class RequireNode
    extends CoreMethodNode {
        public RequireNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"feature"})
        public RubyNode coerceFeatureToPath(RubyNode feature) {
            return ToPathNodeGen.create(this.getContext(), this.getSourceSection(), feature);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(featureString)"})
        public boolean require(DynamicObject featureString) {
            String feature = featureString.toString();
            if (feature.equals("psych.so") && this.callerIs("psych.rb")) {
                try {
                    this.getContext().getFeatureLoader().require("truffle/psych.rb", this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
            if (feature.equals("strscan") && this.callerIs("erb.rb")) {
                throw new RaiseException(this.getContext().getCoreLibrary().loadErrorCannotLoad(feature, this));
            }
            try {
                return this.getContext().getFeatureLoader().require(feature, this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean callerIs(String caller) {
            return RubyCallStack.getCallerFrame(this.getContext()).getCallNode().getEncapsulatingSourceSection().getSource().getName().endsWith(caller);
        }
    }

    @CoreMethod(names={"rand"}, isModuleFunction=true, optional=1)
    public static abstract class RandNode
    extends CoreMethodArrayArgumentsNode {
        public RandNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double rand(NotProvided max) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"max == 0"})
        public double randZero(int max) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"max != 0"})
        public int randNonZero(int max) {
            return this.getContext().getRandom().nextInt(max);
        }

        @Specialization(guards={"max == 0"})
        public double randZero(long max) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"max != 0"})
        public long randNonZero(long max) {
            return this.getContext().getRandom().nextLong(max);
        }
    }

    @CoreMethod(names={"public_send"}, needsBlock=true, required=1, rest=true)
    public static abstract class PublicSendNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode dispatchNode;

        public PublicSendNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatchNode = new CallDispatchHeadNode(context, false, MissingBehavior.CALL_METHOD_MISSING);
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self, Object name, Object[] args, NotProvided block) {
            return this.send(frame, self, name, args, (DynamicObject)null);
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self, Object name, Object[] args, DynamicObject block) {
            return this.dispatchNode.call(frame, self, name, block, args);
        }
    }

    @CoreMethod(names={"public_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class PublicMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public PublicMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public DynamicObject publicMethods(Object self, boolean includeAncestors) {
            DynamicObject metaClass = this.metaClassNode.executeMetaClass(self);
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(metaClass).filterMethodsOnObject(this.getContext(), includeAncestors, MethodFilter.PUBLIC).toArray();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"protected_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class ProtectedMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public ProtectedMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public DynamicObject protectedMethods(Object self, boolean includeAncestors) {
            DynamicObject metaClass = this.metaClassNode.executeMetaClass(self);
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(metaClass).filterMethodsOnObject(this.getContext(), includeAncestors, MethodFilter.PROTECTED).toArray();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"proc"}, isModuleFunction=true, needsBlock=true)
    public static abstract class ProcNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        ProcNodes.ProcNewNode procNewNode;

        public ProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.procNewNode = ProcNodesFactory.ProcNewNodeFactory.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject proc(VirtualFrame frame, Object maybeBlock) {
            return this.procNewNode.executeProcNew(frame, this.getContext().getCoreLibrary().getProcClass(), ArrayUtils.EMPTY_ARRAY, maybeBlock);
        }
    }

    @CoreMethod(names={"private_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class PrivateMethodsNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public PrivateMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public DynamicObject privateMethods(Object self, boolean includeAncestors) {
            DynamicObject metaClass = this.metaClassNode.executeMetaClass(self);
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(metaClass).filterMethodsOnObject(this.getContext(), includeAncestors, MethodFilter.PRIVATE).toArray();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"nil?"}, needsSelf=false)
    public static abstract class NilNode
    extends CoreMethodArrayArgumentsNode {
        public NilNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isNil() {
            return false;
        }
    }

    @CoreMethod(names={"methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="regular")})
    public static abstract class MethodsNode
    extends CoreMethodNode {
        public MethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"regular"})
        public RubyNode coerceToBoolean(RubyNode regular) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, regular);
        }

        @Specialization(guards={"regular"})
        public DynamicObject methodsRegular(Object self, boolean regular, @Cached(value="createMetaClassNode()") MetaClassNode metaClassNode) {
            DynamicObject metaClass = metaClassNode.executeMetaClass(self);
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(metaClass).filterMethodsOnObject(this.getContext(), regular, MethodFilter.PUBLIC_PROTECTED).toArray();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }

        @Specialization(guards={"!regular"})
        public DynamicObject methodsSingleton(VirtualFrame frame, Object self, boolean regular, @Cached(value="createSingletonMethodsNode()") SingletonMethodsNode singletonMethodsNode) {
            return singletonMethodsNode.executeSingletonMethods(frame, self, false);
        }

        protected MetaClassNode createMetaClassNode() {
            return MetaClassNodeGen.create(this.getContext(), this.getSourceSection(), null);
        }

        protected SingletonMethodsNode createSingletonMethodsNode() {
            return KernelNodesFactory.SingletonMethodsNodeFactory.create(this.getContext(), this.getSourceSection(), null, null);
        }
    }

    @CoreMethod(names={"method"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class MethodNode
    extends CoreMethodNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode = NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), null);
        @Node.Child
        LookupMethodNode lookupMethodNode;
        @Node.Child
        CallDispatchHeadNode respondToMissingNode;

        public MethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.lookupMethodNode = LookupMethodNodeGen.create(context, sourceSection, null, null);
            this.respondToMissingNode = DispatchHeadNodeFactory.createMethodCall(this.getContext(), true);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToSymbolOrStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public DynamicObject method(VirtualFrame frame, Object self, DynamicObject name) {
            String normalizedName = this.nameToJavaStringNode.executeToJavaString(frame, name);
            InternalMethod method = this.lookupMethodNode.executeLookupMethod(self, normalizedName);
            if (method == null) {
                CompilerDirectives.transferToInterpreter();
                if (this.respondToMissingNode.callBoolean(frame, self, "respond_to_missing?", null, name, true)) {
                    InternalMethod methodMissing = this.lookupMethodNode.executeLookupMethod(self, "method_missing").withName(normalizedName);
                    SharedMethodInfo info = methodMissing.getSharedMethodInfo().withName(normalizedName);
                    CallMethodMissingWithStaticName newBody = new CallMethodMissingWithStaticName(this.getContext(), info.getSourceSection(), name);
                    RubyRootNode newRootNode = new RubyRootNode(this.getContext(), info.getSourceSection(), new FrameDescriptor((Object)this.nil()), info, newBody);
                    RootCallTarget newCallTarget = Truffle.getRuntime().createCallTarget((RootNode)newRootNode);
                    DynamicObject module = this.getContext().getCoreLibrary().getMetaClass(self);
                    method = new InternalMethod(info, normalizedName, module, Visibility.PUBLIC, (CallTarget)newCallTarget);
                } else {
                    throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(normalizedName, this.getContext().getCoreLibrary().getLogicalClass(self), this));
                }
            }
            return Layouts.METHOD.createMethod(this.getContext().getCoreLibrary().getMethodFactory(), self, method);
        }

        private static class CallMethodMissingWithStaticName
        extends RubyNode {
            private final DynamicObject methodName;
            @Node.Child
            private CallDispatchHeadNode methodMissing;

            public CallMethodMissingWithStaticName(RubyContext context, SourceSection sourceSection, DynamicObject methodName) {
                super(context, sourceSection);
                this.methodName = methodName;
                this.methodMissing = DispatchHeadNodeFactory.createMethodCall(context);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object[] originalUserArguments = RubyArguments.getArguments(frame.getArguments());
                Object[] newUserArguments = ArrayUtils.unshift(originalUserArguments, this.methodName);
                return this.methodMissing.call(frame, RubyArguments.getSelf(frame.getArguments()), "method_missing", RubyArguments.getBlock(frame.getArguments()), newUserArguments);
            }
        }
    }

    @CoreMethod(names={"__method__"}, needsSelf=false)
    public static abstract class MethodNameNode
    extends CoreMethodArrayArgumentsNode {
        public MethodNameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject methodName() {
            CompilerDirectives.transferToInterpreter();
            return this.getSymbol(RubyCallStack.getCallingMethod(this.getContext()).getSharedMethodInfo().getName());
        }
    }

    @CoreMethod(names={"local_variables"}, needsSelf=false)
    public static abstract class LocalVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public LocalVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject localVariables() {
            Frame frame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
            return BindingNodes.LocalVariablesNode.listLocalVariables(this.getContext(), frame);
        }
    }

    @CoreMethod(names={"lambda"}, isModuleFunction=true, needsBlock=true)
    public static abstract class LambdaNode
    extends CoreMethodArrayArgumentsNode {
        public LambdaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject lambda(NotProvided block) {
            Frame parentFrame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
            DynamicObject parentBlock = RubyArguments.getBlock(parentFrame.getArguments());
            if (parentBlock == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("tried to create Proc object without a block", this));
            }
            return this.lambda(parentBlock);
        }

        @Specialization
        public DynamicObject lambda(DynamicObject block) {
            return ProcNodes.createRubyProc(this.getContext().getCoreLibrary().getProcFactory(), ProcNodes.Type.LAMBDA, Layouts.PROC.getSharedMethodInfo(block), Layouts.PROC.getCallTargetForLambdas(block), Layouts.PROC.getCallTargetForLambdas(block), Layouts.PROC.getDeclarationFrame(block), Layouts.PROC.getMethod(block), Layouts.PROC.getSelf(block), Layouts.PROC.getBlock(block));
        }
    }

    @CoreMethod(names={"is_a?", "kind_of?"}, required=1)
    public static abstract class KernelIsANode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        IsANode isANode;

        public KernelIsANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = IsANodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public boolean isA(Object self, DynamicObject module) {
            return this.isANode.executeIsA(self, module);
        }

        @Specialization(guards={"!isRubyModule(module)"})
        public boolean isATypeError(Object self, Object module) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("class or module required", this));
        }
    }

    @CoreMethod(names={"instance_variables"})
    public static abstract class InstanceVariablesNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private BasicObjectNodes.InstanceVariablesNode instanceVariablesNode;

        public InstanceVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.instanceVariablesNode = BasicObjectNodesFactory.InstanceVariablesNodeFactory.create(context, sourceSection, new RubyNode[0]);
        }

        @Specialization
        public DynamicObject instanceVariables(VirtualFrame frame, DynamicObject self) {
            return this.instanceVariablesNode.executeObject(self);
        }
    }

    @CoreMethod(names={"remove_instance_variable"}, raiseIfFrozenSelf=true, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class RemoveInstanceVariableNode
    extends CoreMethodNode {
        public RemoveInstanceVariableNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object removeInstanceVariable(DynamicObject object, String name) {
            String ivar = RubyContext.checkInstanceVariableName(this.getContext(), name, this);
            Object value = object.get((Object)ivar, (Object)this.nil());
            if (!object.delete((Object)name)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorInstanceVariableNotDefined(name, this));
            }
            return value;
        }
    }

    @CoreMethod(names={"instance_variable_set", "__instance_variable_set__"}, raiseIfFrozenSelf=true, required=2)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class InstanceVariableSetNode
    extends CoreMethodNode {
        protected static final int LIMIT = Options.FIELD_LOOKUP_CACHE;

        public InstanceVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToSymbolOrString(RubyNode name) {
            return NameToSymbolOrStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization(guards={"isRubySymbol(name)", "name == cachedName"}, limit="LIMIT")
        public Object instanceVariableSetSymbolCached(DynamicObject object, DynamicObject name, Object value, @Cached(value="name") DynamicObject cachedName, @Cached(value="createWriteFieldNode(checkName(symbolToString(cachedName)))") WriteHeadObjectFieldNode writeHeadObjectFieldNode) {
            writeHeadObjectFieldNode.execute(object, value);
            return value;
        }

        @Specialization(guards={"isRubySymbol(name)"})
        public Object instanceVariableSetSymbol(DynamicObject object, DynamicObject name, Object value) {
            return this.ivarSet(object, this.symbolToString(name), value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public Object instanceVariableSetString(DynamicObject object, DynamicObject name, Object value) {
            return this.ivarSet(object, name.toString(), value);
        }

        @CompilerDirectives.TruffleBoundary
        private Object ivarSet(DynamicObject object, String name, Object value) {
            object.define((Object)this.checkName(name), value, 0);
            return value;
        }

        protected String symbolToString(DynamicObject name) {
            return Layouts.SYMBOL.getString(name);
        }

        protected String checkName(String name) {
            return RubyContext.checkInstanceVariableName(this.getContext(), name, this);
        }

        protected WriteHeadObjectFieldNode createWriteFieldNode(String name) {
            return WriteHeadObjectFieldNodeGen.create(name);
        }
    }

    @CoreMethod(names={"instance_variable_get"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class InstanceVariableGetNode
    extends CoreMethodNode {
        protected static final int LIMIT = Options.FIELD_LOOKUP_CACHE;

        public InstanceVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToSymbolOrString(RubyNode name) {
            return NameToSymbolOrStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization(guards={"isRubySymbol(name)", "name == cachedName"}, limit="LIMIT")
        public Object instanceVariableGetSymbolCached(DynamicObject object, DynamicObject name, @Cached(value="name") DynamicObject cachedName, @Cached(value="createReadFieldNode(checkName(symbolToString(cachedName)))") ReadHeadObjectFieldNode readHeadObjectFieldNode) {
            return readHeadObjectFieldNode.execute(object);
        }

        @Specialization(guards={"isRubySymbol(name)"})
        public Object instanceVariableGetSymbol(DynamicObject object, DynamicObject name) {
            return this.ivarGet(object, this.symbolToString(name));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(name)"})
        public Object instanceVariableGetString(DynamicObject object, DynamicObject name) {
            return this.ivarGet(object, name.toString());
        }

        @CompilerDirectives.TruffleBoundary
        private Object ivarGet(DynamicObject object, String name) {
            return object.get((Object)this.checkName(name), (Object)this.nil());
        }

        protected String symbolToString(DynamicObject name) {
            return Layouts.SYMBOL.getString(name);
        }

        protected String checkName(String name) {
            return RubyContext.checkInstanceVariableName(this.getContext(), name, this);
        }

        protected ReadHeadObjectFieldNode createReadFieldNode(String name) {
            return ReadHeadObjectFieldNodeGen.create(name, this.nil());
        }
    }

    @CoreMethod(names={"instance_variable_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="object"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class InstanceVariableDefinedNode
    extends CoreMethodNode {
        public InstanceVariableDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isInstanceVariableDefined(DynamicObject object, String name) {
            String ivar = RubyContext.checkInstanceVariableName(this.getContext(), name, this);
            return object.getShape().hasProperty((Object)ivar);
        }
    }

    @CoreMethod(names={"instance_of?"}, required=1)
    public static abstract class InstanceOfNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassNode classNode;

        public InstanceOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization(guards={"isRubyClass(rubyClass)"})
        public boolean instanceOf(VirtualFrame frame, Object self, DynamicObject rubyClass) {
            return this.classNode.executeGetClass(frame, self) == rubyClass;
        }
    }

    @CoreMethod(names={"initialize_dup", "initialize_clone"}, required=1)
    public static abstract class InitializeDupCloneNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode initializeCopyNode;

        public InitializeDupCloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initializeCopyNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public Object initializeDup(VirtualFrame frame, DynamicObject self, DynamicObject from) {
            return this.initializeCopyNode.call(frame, self, "initialize_copy", null, from);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object initializeCopy(DynamicObject self, DynamicObject from) {
            CompilerDirectives.transferToInterpreter();
            if (Layouts.BASIC_OBJECT.getLogicalClass(self) != Layouts.BASIC_OBJECT.getLogicalClass(from)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("initialize_copy should take same class object", this));
            }
            return self;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(int value) {
            return value;
        }

        @Specialization
        public int hash(long value) {
            return Long.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(double value) {
            return Double.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(boolean value) {
            return Boolean.valueOf(value).hashCode();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int hash(DynamicObject self) {
            return System.identityHashCode(self);
        }
    }

    @CoreMethod(names={"gets"}, isModuleFunction=true)
    public static abstract class GetsNode
    extends CoreMethodArrayArgumentsNode {
        public GetsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject gets(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            InputStream in = this.getContext().getRuntime().getInstanceConfig().getInput();
            Encoding encoding = this.getContext().getRuntime().getDefaultExternalEncoding();
            final BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding.getCharset()));
            String line = this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<String>(){

                @Override
                public String block() throws InterruptedException {
                    return GetsNode.gets(reader);
                }
            });
            DynamicObject rubyLine = this.createString(StringOperations.encodeByteList(line, (Encoding)UTF8Encoding.INSTANCE));
            Frame caller = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_WRITE, true);
            FrameSlot slot = caller.getFrameDescriptor().findFrameSlot((Object)"$_");
            if (slot != null) {
                caller.setObject(slot, (Object)ThreadLocalObject.wrap(this.getContext(), rubyLine));
            }
            return rubyLine;
        }

        @CompilerDirectives.TruffleBoundary
        private static String gets(BufferedReader reader) throws InterruptedException {
            try {
                return reader.readLine() + "\n";
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CoreMethod(names={"frozen?"})
    public static abstract class KernelFrozenNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;

        public KernelFrozenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isFrozen(Object self) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.isFrozenNode.executeIsFrozen(self);
        }
    }

    @CoreMethod(names={"freeze"})
    public static abstract class KernelFreezeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FreezeNode freezeNode;

        public KernelFreezeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.freezeNode = FreezeNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public Object freeze(Object self) {
            return this.freezeNode.executeFreeze(self);
        }
    }

    @CoreMethod(names={"fork"}, isModuleFunction=true, rest=true)
    public static abstract class ForkNode
    extends CoreMethodArrayArgumentsNode {
        public ForkNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object fork(Object[] args) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getWarnings().warn("Kernel#fork not implemented - defined to satisfy some metaprogramming in RubySpec");
            return this.nil();
        }
    }

    @CoreMethod(names={"exec"}, isModuleFunction=true, required=1, rest=true)
    public static abstract class ExecNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toHashNode;

        public ExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object exec(VirtualFrame frame, Object command, Object[] args) {
            if (this.toHashNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toHashNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            CompilerDirectives.transferToInterpreter();
            String[] commandLine = new String[1 + args.length];
            commandLine[0] = command.toString();
            for (int n = 0; n < args.length; ++n) {
                commandLine[1 + n] = args[n].toString();
            }
            DynamicObject env = this.getContext().getCoreLibrary().getENV();
            DynamicObject envAsHash = (DynamicObject)this.toHashNode.call(frame, env, "to_hash", null, new Object[0]);
            this.exec(this.getContext(), envAsHash, commandLine);
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private void exec(RubyContext context, DynamicObject envAsHash, String[] commandLine) {
            Process process;
            ProcessBuilder builder = new ProcessBuilder(commandLine);
            builder.inheritIO();
            for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(envAsHash)) {
                builder.environment().put(keyValue.getKey().toString(), keyValue.getValue().toString());
            }
            try {
                process = builder.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int exitCode = context.getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    return process.waitFor();
                }
            });
            System.exit(exitCode);
        }
    }

    @CoreMethod(names={"eval"}, isModuleFunction=true, required=1, optional=3, lowerFixnumParameters={3})
    @ImportStatic(value={StringCachingGuards.class})
    @NodeChildren(value={@NodeChild(value="source", type=RubyNode.class), @NodeChild(value="binding", type=RubyNode.class), @NodeChild(value="filename", type=RubyNode.class), @NodeChild(value="lineNumber", type=RubyNode.class)})
    public static abstract class EvalNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toStr;
        @Node.Child
        private BindingNode bindingNode;

        public EvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"source"})
        public RubyNode coerceSourceToString(RubyNode source) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), source);
        }

        protected DynamicObject getCallerBinding(VirtualFrame frame) {
            if (this.bindingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bindingNode = (BindingNode)this.insert(KernelNodesFactory.BindingNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            try {
                return this.bindingNode.executeDynamicObject(frame);
            }
            catch (UnexpectedResultException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Specialization(guards={"isRubyString(source)", "byteListsEqual(source, cachedSource)", "!parseDependsOnDeclarationFrame(cachedRootNode)"}, limit="getCacheLimit()")
        public Object evalNoBindingCached(VirtualFrame frame, DynamicObject source, NotProvided binding, NotProvided filename, NotProvided lineNumber, @Cached(value="privatizeByteList(source)") ByteList cachedSource, @Cached(value="compileSource(frame, source)") RootNodeWrapper cachedRootNode, @Cached(value="createCallTarget(cachedRootNode)") CallTarget cachedCallTarget, @Cached(value="create(cachedCallTarget)") DirectCallNode callNode) {
            DynamicObject callerBinding = this.getCallerBinding(frame);
            MaterializedFrame parentFrame = Layouts.BINDING.getFrame(callerBinding);
            Object callerSelf = RubyArguments.getSelf(frame.getArguments());
            InternalMethod method = new InternalMethod(cachedRootNode.getRootNode().getSharedMethodInfo(), cachedRootNode.getRootNode().getSharedMethodInfo().getName(), RubyArguments.getMethod(parentFrame.getArguments()).getDeclaringModule(), Visibility.PUBLIC, cachedCallTarget);
            return callNode.call(frame, RubyArguments.pack(parentFrame, null, method, RubyArguments.getDeclarationContext(parentFrame.getArguments()), null, callerSelf, null, new Object[0]));
        }

        @Specialization(guards={"isRubyString(source)"}, contains={"evalNoBindingCached"})
        public Object evalNoBindingUncached(VirtualFrame frame, DynamicObject source, NotProvided noBinding, NotProvided filename, NotProvided lineNumber) {
            DynamicObject binding = this.getCallerBinding(frame);
            MaterializedFrame topFrame = Layouts.BINDING.getFrame(binding);
            RubyArguments.setSelf(topFrame.getArguments(), RubyArguments.getSelf(frame.getArguments()));
            return this.doEval(source, binding, "(eval)", true);
        }

        @Specialization(guards={"isRubyString(source)", "isNil(noBinding)", "isRubyString(filename)"})
        public Object evalNilBinding(VirtualFrame frame, DynamicObject source, DynamicObject noBinding, DynamicObject filename, int lineNumber) {
            return this.evalNoBindingUncached(frame, source, NotProvided.INSTANCE, NotProvided.INSTANCE, NotProvided.INSTANCE);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)"})
        public Object evalBinding(DynamicObject source, DynamicObject binding, NotProvided filename, NotProvided lineNumber) {
            return this.doEval(source, binding, "(eval)", false);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)", "isNil(noFilename)", "isNil(noLineNumber)"})
        public Object evalBinding(DynamicObject source, DynamicObject binding, DynamicObject noFilename, DynamicObject noLineNumber) {
            return this.evalBinding(source, binding, NotProvided.INSTANCE, NotProvided.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)", "isRubyString(filename)"})
        public Object evalBindingFilename(DynamicObject source, DynamicObject binding, DynamicObject filename, NotProvided lineNumber) {
            return this.evalBindingFilenameLine(source, binding, filename, 0);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)", "isRubyString(filename)", "isNil(noLineNumber)"})
        public Object evalBindingFilename(DynamicObject source, DynamicObject binding, DynamicObject filename, DynamicObject noLineNumber) {
            return this.evalBindingFilename(source, binding, filename, NotProvided.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(source)", "isRubyBinding(binding)", "isRubyString(filename)"})
        public Object evalBindingFilenameLine(DynamicObject source, DynamicObject binding, DynamicObject filename, int lineNumber) {
            return this.doEval(source, binding, filename.toString(), false);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(source)", "!isRubyBinding(badBinding)"})
        public Object evalBadBinding(DynamicObject source, DynamicObject badBinding, NotProvided filename, NotProvided lineNumber) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorWrongArgumentType(badBinding, "binding", this));
        }

        @CompilerDirectives.TruffleBoundary
        private Object doEval(DynamicObject source, DynamicObject binding, String filename, boolean ownScopeForAssignments) {
            Object result = this.getContext().eval(TranslatorDriver.ParserContext.EVAL, StringOperations.getByteList(source), binding, ownScopeForAssignments, filename, this);
            assert (result != null);
            return result;
        }

        protected RootNodeWrapper compileSource(VirtualFrame frame, DynamicObject sourceText) {
            assert (RubyGuards.isRubyString(sourceText));
            DynamicObject callerBinding = this.getCallerBinding(frame);
            MaterializedFrame parentFrame = Layouts.BINDING.getFrame(callerBinding);
            Encoding encoding = StringOperations.getByteList(sourceText).getEncoding();
            Source source = Source.fromText((CharSequence)sourceText.toString(), (String)"(eval)");
            TranslatorDriver translator = new TranslatorDriver(this.getContext());
            return new RootNodeWrapper(translator.parse(this.getContext(), source, encoding, TranslatorDriver.ParserContext.EVAL, null, parentFrame, true, this));
        }

        protected boolean parseDependsOnDeclarationFrame(RootNodeWrapper rootNode) {
            return rootNode.getRootNode().needsDeclarationFrame();
        }

        protected CallTarget createCallTarget(RootNodeWrapper rootNode) {
            return Truffle.getRuntime().createCallTarget((RootNode)rootNode.rootNode);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().EVAL_CACHE;
        }

        protected static class RootNodeWrapper {
            private final RubyRootNode rootNode;

            public RootNodeWrapper(RubyRootNode rootNode) {
                this.rootNode = rootNode;
            }

            public RubyRootNode getRootNode() {
                return this.rootNode;
            }
        }
    }

    @CoreMethod(names={"dup"}, taintFromSelf=true)
    public static abstract class DupNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CopyNode copyNode;
        @Node.Child
        private CallDispatchHeadNode initializeDupNode;

        public DupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.copyNode = KernelNodesFactory.CopyNodeFactory.create(context, sourceSection, null);
            this.initializeDupNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public DynamicObject dup(VirtualFrame frame, DynamicObject self) {
            DynamicObject newObject = this.copyNode.executeCopy(frame, self);
            this.initializeDupNode.call(frame, newObject, "initialize_dup", null, self);
            return newObject;
        }
    }

    @CoreMethod(names={"clone"}, taintFromSelf=true)
    public static abstract class CloneNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile frozenProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private CopyNode copyNode;
        @Node.Child
        private CallDispatchHeadNode initializeCloneNode;
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private FreezeNode freezeNode;
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public CloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.copyNode = KernelNodesFactory.CopyNodeFactory.create(context, sourceSection, null);
            this.initializeCloneNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
            this.isFrozenNode = IsFrozenNodeGen.create(context, sourceSection, null);
            this.freezeNode = FreezeNodeGen.create(context, sourceSection, null);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject clone(VirtualFrame frame, DynamicObject self) {
            CompilerDirectives.transferToInterpreter();
            DynamicObject newObject = this.copyNode.executeCopy(frame, self);
            if (Layouts.CLASS.getIsSingleton(Layouts.BASIC_OBJECT.getMetaClass(self))) {
                Layouts.MODULE.getFields(this.singletonClassNode.executeSingletonClass(newObject)).initCopy(Layouts.BASIC_OBJECT.getMetaClass(self));
            }
            this.initializeCloneNode.call(frame, newObject, "initialize_clone", null, self);
            if (this.frozenProfile.profile(this.isFrozenNode.executeIsFrozen(self))) {
                this.freezeNode.executeFreeze(newObject);
            }
            return newObject;
        }
    }

    public static abstract class CopyNode
    extends UnaryCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode allocateNode;

        public CopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = DispatchHeadNodeFactory.createMethodCall(context, true);
        }

        public abstract DynamicObject executeCopy(VirtualFrame var1, DynamicObject var2);

        @Specialization
        public DynamicObject copy(VirtualFrame frame, DynamicObject self) {
            DynamicObject rubyClass = Layouts.BASIC_OBJECT.getLogicalClass(self);
            DynamicObject newObject = (DynamicObject)this.allocateNode.call(frame, rubyClass, "allocate", null, new Object[0]);
            this.copyInstanceVariables(self, newObject);
            return newObject;
        }

        @CompilerDirectives.TruffleBoundary
        private void copyInstanceVariables(DynamicObject from, DynamicObject to) {
            for (Property property : from.getShape().getProperties()) {
                if (!(property.getKey() instanceof String)) continue;
                to.define(property.getKey(), property.get(from, from.getShape()), 0);
            }
        }
    }

    @CoreMethod(names={"class"})
    public static abstract class KernelClassNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassNode classNode;

        public KernelClassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject getClass(VirtualFrame frame, Object self) {
            return this.classNode.executeGetClass(frame, self);
        }
    }

    @CoreMethod(names={"caller_locations"}, isModuleFunction=true, optional=2, lowerFixnumParameters={0, 1})
    public static abstract class CallerLocationsNode
    extends CoreMethodArrayArgumentsNode {
        public CallerLocationsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject callerLocations(NotProvided omit, NotProvided length) {
            return this.callerLocations(1, -1);
        }

        @Specialization
        public DynamicObject callerLocations(int omit, NotProvided length) {
            return this.callerLocations(omit, -1);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject callerLocations(int omit, int length) {
            DynamicObject threadBacktraceLocationClass = this.getContext().getCoreLibrary().getThreadBacktraceLocationClass();
            Backtrace backtrace = RubyCallStack.getBacktrace(this, 1 + omit, true);
            int locationsCount = backtrace.getActivations().size();
            if (length != -1 && locationsCount > length) {
                locationsCount = length;
            }
            Object[] locations = new Object[locationsCount];
            for (int n = 0; n < locationsCount; ++n) {
                Activation activation = backtrace.getActivations().get(n);
                locations[n] = ThreadBacktraceLocationLayoutImpl.INSTANCE.createThreadBacktraceLocation(Layouts.CLASS.getInstanceFactory(threadBacktraceLocationClass), activation);
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), locations, locations.length);
        }
    }

    @CoreMethod(names={"__callee__"}, needsSelf=false)
    public static abstract class CalleeNameNode
    extends CoreMethodArrayArgumentsNode {
        public CalleeNameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject calleeName() {
            CompilerDirectives.transferToInterpreter();
            return this.getSymbol(RubyCallStack.getCallingMethod(this.getContext()).getName());
        }
    }

    @CoreMethod(names={"block_given?"}, isModuleFunction=true, needsCallerFrame=true)
    public static abstract class BlockGivenNode
    extends CoreMethodArrayArgumentsNode {
        public BlockGivenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean blockGiven(MaterializedFrame callerFrame, @Cached(value="createBinaryProfile()") ConditionProfile blockProfile) {
            return blockProfile.profile(RubyArguments.getBlock(callerFrame.getArguments()) != null);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean blockGiven(NotProvided noCallerFrame) {
            return RubyArguments.getBlock(Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, false).getArguments()) != null;
        }
    }

    @CoreMethod(names={"binding"}, isModuleFunction=true)
    public static abstract class BindingNode
    extends CoreMethodArrayArgumentsNode {
        public BindingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject binding() {
            MaterializedFrame callerFrame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.MATERIALIZE, false).materialize();
            return BindingNodes.createBinding(this.getContext(), callerFrame);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SameOrEqualNode equalNode;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        @Specialization
        public Object compare(VirtualFrame frame, Object self, Object other) {
            if (this.equalNode.executeSameOrEqual(frame, self, other)) {
                return 0;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"!~"}, required=1)
    public static abstract class NotMatchNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode matchNode;

        public NotMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.matchNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public boolean notMatch(VirtualFrame frame, Object self, Object other) {
            return !this.matchNode.callBoolean(frame, self, "=~", null, other);
        }
    }

    @CoreMethod(names={"=~"}, required=1, needsSelf=false)
    public static abstract class MatchNode
    extends CoreMethodArrayArgumentsNode {
        public MatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject equal(Object other) {
            return this.nil();
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class SameOrEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode referenceEqualNode;
        @Node.Child
        private CallDispatchHeadNode equalNode;
        private final ConditionProfile sameProfile = ConditionProfile.createBinaryProfile();

        public SameOrEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract boolean executeSameOrEqual(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public boolean sameOrEqual(VirtualFrame frame, Object a, Object b) {
            if (this.sameProfile.profile(this.areSame(frame, a, b))) {
                return true;
            }
            return this.areEqual(frame, a, b);
        }

        private boolean areSame(VirtualFrame frame, Object left, Object right) {
            if (this.referenceEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.referenceEqualNode = (BasicObjectNodes.ReferenceEqualNode)this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.referenceEqualNode.executeReferenceEqual(frame, left, right);
        }

        private boolean areEqual(VirtualFrame frame, Object left, Object right) {
            if (this.equalNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.equalNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.equalNode.callBoolean(frame, left, "==", null, right);
        }
    }

    @CoreMethod(names={"`"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class BacktickNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toHashNode;

        public BacktickNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(command)"})
        public DynamicObject backtick(VirtualFrame frame, DynamicObject command) {
            Process process;
            if (this.toHashNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toHashNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            CompilerDirectives.transferToInterpreter();
            RubyContext context = this.getContext();
            DynamicObject env = context.getCoreLibrary().getENV();
            DynamicObject envAsHash = (DynamicObject)this.toHashNode.call(frame, env, "to_hash", null, new Object[0]);
            ArrayList<String> envp = new ArrayList<String>();
            for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(envAsHash)) {
                envp.add(keyValue.getKey().toString() + "=" + keyValue.getValue().toString());
            }
            try {
                process = Runtime.getRuntime().exec(new String[]{"bash", "-c", command.toString()}, envp.toArray(new String[envp.size()]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            InputStream stdout = process.getInputStream();
            InputStreamReader reader = new InputStreamReader(stdout, StandardCharsets.UTF_8);
            StringBuilder resultBuilder = new StringBuilder();
            try {
                int c;
                while ((c = reader.read()) != -1) {
                    resultBuilder.append((char)c);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.createString(StringOperations.encodeByteList(resultBuilder.toString(), EncodingOperations.getEncoding(EncodingNodes.getEncoding("UTF-8"))));
        }
    }
}

