/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNode;
import org.jruby.truffle.nodes.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNode;
import org.jruby.truffle.nodes.locals.WriteFrameSlotNodeGen;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.ThreadLocalObject;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

@CoreClass(name="Binding")
public abstract class BindingNodes {
    public static DynamicObject createBinding(RubyContext context, MaterializedFrame frame) {
        Object[] arguments = frame.getArguments();
        MaterializedFrame bindingFrame = Truffle.getRuntime().createMaterializedFrame(RubyArguments.pack(frame, null, RubyArguments.getMethod(arguments), RubyArguments.getDeclarationContext(arguments), null, RubyArguments.getSelf(arguments), RubyArguments.getBlock(arguments), RubyArguments.getArguments(arguments)), BindingNodes.newFrameDescriptor(context));
        return Layouts.BINDING.createBinding(context.getCoreLibrary().getBindingFactory(), bindingFrame);
    }

    @CompilerDirectives.TruffleBoundary
    private static FrameDescriptor newFrameDescriptor(RubyContext context) {
        return new FrameDescriptor((Object)context.getCoreLibrary().getNilObject());
    }

    public static FrameDescriptor getFrameDescriptor(DynamicObject binding) {
        assert (RubyGuards.isRubyBinding(binding));
        return Layouts.BINDING.getFrame(binding).getFrameDescriptor();
    }

    public static MaterializedFrame getDeclarationFrame(DynamicObject binding) {
        assert (RubyGuards.isRubyBinding(binding));
        return RubyArguments.getDeclarationFrame(Layouts.BINDING.getFrame(binding).getArguments());
    }

    public static FrameSlotAndDepth findFrameSlotOrNull(DynamicObject binding, DynamicObject symbol) {
        assert (RubyGuards.isRubyBinding(binding));
        assert (RubyGuards.isRubySymbol(symbol));
        String identifier = Layouts.SYMBOL.getString(symbol);
        int depth = 0;
        MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
        while (frame != null) {
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)identifier);
            if (frameSlot != null) {
                return new FrameSlotAndDepth(frameSlot, depth);
            }
            frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            ++depth;
        }
        return null;
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"receiver"})
    public static abstract class ReceiverNode
    extends UnaryCoreMethodNode {
        public ReceiverNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object receiver(DynamicObject binding) {
            return RubyArguments.getSelf(Layouts.BINDING.getFrame(binding).getArguments());
        }
    }

    @CoreMethod(names={"local_variables"})
    public static abstract class LocalVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public LocalVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject localVariables(DynamicObject binding) {
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            return LocalVariablesNode.listLocalVariables(this.getContext(), (Frame)frame);
        }

        @CompilerDirectives.TruffleBoundary
        public static DynamicObject listLocalVariables(RubyContext context, Frame frame) {
            DynamicObject array = Layouts.ARRAY.createArray(context.getCoreLibrary().getArrayFactory(), null, 0);
            while (frame != null) {
                for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
                    if (!(slot.getIdentifier() instanceof String) || ((String)slot.getIdentifier()).startsWith("rubytruffle_temp_frame_on_stack_marker")) continue;
                    ArrayOperations.append(array, context.getSymbol((String)slot.getIdentifier()));
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
            return array;
        }
    }

    @ImportStatic(value={BindingNodes.class})
    @CoreMethod(names={"local_variable_set"}, required=2)
    public static abstract class LocalVariableSetNode
    extends CoreMethodArrayArgumentsNode {
        private final DynamicObject dollarUnderscore = this.getSymbol("$_");

        public LocalVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "!isLastLine(symbol)", "getFrameDescriptor(binding) == cachedFrameDescriptor", "symbol == cachedSymbol"}, limit="getCacheLimit()")
        public Object localVariableSetCached(DynamicObject binding, DynamicObject symbol, Object value, @Cached(value="symbol") DynamicObject cachedSymbol, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor cachedFrameDescriptor, @Cached(value="findFrameSlot(binding, symbol)") FrameSlotAndDepth cachedFrameSlot, @Cached(value="createWriteNode(cachedFrameSlot)") WriteFrameSlotNode writeLocalVariableNode) {
            MaterializedFrame frame = RubyArguments.getDeclarationFrame(Layouts.BINDING.getFrame(binding), cachedFrameSlot.depth);
            return writeLocalVariableNode.executeWrite((Frame)frame, value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "!isLastLine(symbol)"})
        public Object localVariableSetUncached(DynamicObject binding, DynamicObject symbol, Object value) {
            FrameSlotAndDepth frameSlot = this.findFrameSlot(binding, symbol);
            MaterializedFrame frame = RubyArguments.getDeclarationFrame(Layouts.BINDING.getFrame(binding), frameSlot.depth);
            frame.setObject(frameSlot.slot, value);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "isLastLine(symbol)"})
        public Object localVariableSetLastLine(DynamicObject binding, DynamicObject symbol, Object value) {
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)Layouts.SYMBOL.getString(symbol));
            frame.setObject(frameSlot, (Object)ThreadLocalObject.wrap(this.getContext(), value));
            return value;
        }

        protected FrameSlotAndDepth findFrameSlot(DynamicObject binding, DynamicObject symbol) {
            FrameSlotAndDepth frameSlot = BindingNodes.findFrameSlotOrNull(binding, symbol);
            if (frameSlot == null) {
                FrameSlot newSlot = Layouts.BINDING.getFrame(binding).getFrameDescriptor().addFrameSlot((Object)Layouts.SYMBOL.getString(symbol));
                return new FrameSlotAndDepth(newSlot, 0);
            }
            return frameSlot;
        }

        protected WriteFrameSlotNode createWriteNode(FrameSlotAndDepth frameSlot) {
            return WriteFrameSlotNodeGen.create(frameSlot.slot);
        }

        protected boolean isLastLine(DynamicObject symbol) {
            return symbol == this.dollarUnderscore;
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().BINDING_LOCAL_VARIABLE_CACHE;
        }
    }

    @ImportStatic(value={BindingNodes.class})
    @CoreMethod(names={"local_variable_get"}, required=1)
    public static abstract class LocalVariableGetNode
    extends CoreMethodArrayArgumentsNode {
        private final DynamicObject dollarUnderscore = this.getSymbol("$_");

        public LocalVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "symbol == cachedSymbol", "!isLastLine(cachedSymbol)", "compatibleFrames(binding, cachedBinding)", "cachedFrameSlot != null"}, limit="getCacheLimit()")
        public Object localVariableGetCached(DynamicObject binding, DynamicObject symbol, @Cached(value="symbol") DynamicObject cachedSymbol, @Cached(value="binding") DynamicObject cachedBinding, @Cached(value="findFrameSlotOrNull(binding, symbol)") FrameSlotAndDepth cachedFrameSlot, @Cached(value="createReadNode(cachedFrameSlot)") ReadFrameSlotNode readLocalVariableNode) {
            MaterializedFrame frame = RubyArguments.getDeclarationFrame(Layouts.BINDING.getFrame(binding), cachedFrameSlot.depth);
            return readLocalVariableNode.executeRead((Frame)frame);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "!isLastLine(symbol)"})
        public Object localVariableGetUncached(DynamicObject binding, DynamicObject symbol) {
            FrameSlotAndDepth frameSlot = BindingNodes.findFrameSlotOrNull(binding, symbol);
            if (frameSlot == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorLocalVariableNotDefined(Layouts.SYMBOL.getString(symbol), binding, this));
            }
            MaterializedFrame frame = RubyArguments.getDeclarationFrame(Layouts.BINDING.getFrame(binding), frameSlot.depth);
            return frame.getValue(frameSlot.slot);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(symbol)", "isLastLine(symbol)"})
        public Object localVariableGetLastLine(DynamicObject binding, DynamicObject symbol) {
            MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
            FrameSlot frameSlot = frame.getFrameDescriptor().findFrameSlot((Object)Layouts.SYMBOL.getString(symbol));
            if (frameSlot == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorLocalVariableNotDefined(Layouts.SYMBOL.getString(symbol), binding, this));
            }
            Object value = frame.getValue(frameSlot);
            if (value instanceof ThreadLocalObject) {
                return ((ThreadLocalObject)value).get();
            }
            return value;
        }

        protected boolean compatibleFrames(DynamicObject binding1, DynamicObject binding2) {
            FrameDescriptor fd2;
            FrameDescriptor fd1 = BindingNodes.getFrameDescriptor(binding1);
            return (fd1 == (fd2 = BindingNodes.getFrameDescriptor(binding2)) || fd1.getSize() == 0 && fd2.getSize() == 0) && BindingNodes.getDeclarationFrame(binding1).getFrameDescriptor() == BindingNodes.getDeclarationFrame(binding2).getFrameDescriptor();
        }

        protected ReadFrameSlotNode createReadNode(FrameSlotAndDepth frameSlot) {
            if (frameSlot == null) {
                return null;
            }
            return ReadFrameSlotNodeGen.create(frameSlot.slot);
        }

        protected boolean isLastLine(DynamicObject symbol) {
            return symbol == this.dollarUnderscore;
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().BINDING_LOCAL_VARIABLE_CACHE;
        }
    }

    @CoreMethod(names={"dup", "clone"})
    public static abstract class DupNode
    extends UnaryCoreMethodNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public DupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject dup(DynamicObject binding) {
            DynamicObject copy = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(binding), this.copyFrame(Layouts.BINDING.getFrame(binding)));
            return copy;
        }

        private MaterializedFrame copyFrame(MaterializedFrame frame) {
            MaterializedFrame copy = Truffle.getRuntime().createMaterializedFrame(frame.getArguments(), frame.getFrameDescriptor().copy());
            for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
                copy.setObject(copy.getFrameDescriptor().findFrameSlot(slot.getIdentifier()), frame.getValue(slot));
            }
            return copy;
        }
    }

    protected static class FrameSlotAndDepth {
        private final FrameSlot slot;
        private final int depth;

        public FrameSlotAndDepth(FrameSlot slot, int depth) {
            this.slot = slot;
            this.depth = depth;
        }

        public FrameSlot getSlot() {
            return this.slot;
        }
    }
}

