/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.parser;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.RootNode;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jruby.truffle.format.nodes.PackRootNode;
import org.jruby.truffle.format.parser.PackCompiler;
import org.jruby.truffle.format.parser.PackErrorListener;
import org.jruby.truffle.format.parser.PrintfLexer;
import org.jruby.truffle.format.parser.PrintfParser;
import org.jruby.truffle.format.parser.PrintfTreeBuilder;
import org.jruby.truffle.format.runtime.PackEncoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

public class PrintfCompiler {
    private final RubyContext context;
    private final RubyNode currentNode;

    public PrintfCompiler(RubyContext context, RubyNode currentNode) {
        this.context = context;
        this.currentNode = currentNode;
    }

    public CallTarget compile(ByteList format) {
        PackErrorListener errorListener = new PackErrorListener(this.context, this.currentNode);
        ANTLRInputStream input = new ANTLRInputStream(PrintfCompiler.bytesToChars(format.bytes()), format.realSize());
        PrintfLexer lexer = new PrintfLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PrintfParser parser = new PrintfParser((TokenStream)tokens);
        PrintfTreeBuilder builder = new PrintfTreeBuilder(this.context, format);
        parser.addParseListener(builder);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        parser.sequence();
        return Truffle.getRuntime().createCallTarget((RootNode)new PackRootNode(PackCompiler.describe(format.toString()), PackEncoding.DEFAULT, builder.getNode()));
    }

    public static char[] bytesToChars(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int n = 0; n < bytes.length; ++n) {
            chars[n] = (char)bytes[n];
        }
        return chars;
    }
}

