/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.ThreadBacktraceLocationLayout;

public class ThreadBacktraceLocationLayoutImpl
extends BasicObjectLayoutImpl
implements ThreadBacktraceLocationLayout {
    public static final ThreadBacktraceLocationLayout INSTANCE = new ThreadBacktraceLocationLayoutImpl();
    protected static final Shape.Allocator THREAD_BACKTRACE_LOCATION_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ACTIVATION_IDENTIFIER = new HiddenKey("activation");
    protected static final Property ACTIVATION_PROPERTY = Property.create((Object)ACTIVATION_IDENTIFIER, (Location)THREAD_BACKTRACE_LOCATION_ALLOCATOR.locationForType(Activation.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);

    protected ThreadBacktraceLocationLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createThreadBacktraceLocationShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new ThreadBacktraceLocationType(logicalClass, metaClass)).addProperty(ACTIVATION_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createThreadBacktraceLocation(DynamicObjectFactory factory, Activation activation) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsThreadBacktraceLocation(factory));
        assert (factory.getShape().hasProperty((Object)ACTIVATION_IDENTIFIER));
        assert (activation != null);
        return factory.newInstance(new Object[]{activation});
    }

    private boolean isThreadBacktraceLocation(DynamicObject object) {
        return this.isThreadBacktraceLocation(object.getShape().getObjectType());
    }

    private boolean isThreadBacktraceLocation(ObjectType objectType) {
        return objectType instanceof ThreadBacktraceLocationType;
    }

    private boolean createsThreadBacktraceLocation(DynamicObjectFactory factory) {
        return this.isThreadBacktraceLocation(factory.getShape().getObjectType());
    }

    @Override
    public Activation getActivation(DynamicObject object) {
        assert (this.isThreadBacktraceLocation(object));
        assert (object.getShape().hasProperty((Object)ACTIVATION_IDENTIFIER));
        return (Activation)ACTIVATION_PROPERTY.get(object, true);
    }

    protected static class ThreadBacktraceLocationType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ThreadBacktraceLocationType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ThreadBacktraceLocationType setLogicalClass(DynamicObject logicalClass) {
            return new ThreadBacktraceLocationType(logicalClass, this.metaClass);
        }

        @Override
        public ThreadBacktraceLocationType setMetaClass(DynamicObject metaClass) {
            return new ThreadBacktraceLocationType(this.logicalClass, metaClass);
        }
    }
}

