/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.array.ArrayReflector;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;

public abstract class ArrayOperations {
    public static int normalizeIndex(int length, int index, ConditionProfile negativeIndexProfile) {
        if (negativeIndexProfile.profile(index < 0)) {
            return length + index;
        }
        return index;
    }

    public static int normalizeIndex(int length, int index) {
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (index < 0 ? 1 : 0) != 0)) {
            return length + index;
        }
        return index;
    }

    public static int clampExclusiveIndex(int length, int index) {
        if (CompilerDirectives.injectBranchProbability((double)0.25, (index < 0 ? 1 : 0) != 0)) {
            return 0;
        }
        if (CompilerDirectives.injectBranchProbability((double)0.25, (index > length ? 1 : 0) != 0)) {
            return length;
        }
        return index;
    }

    public static Object[] toObjectArray(DynamicObject array) {
        return ArrayReflector.reflect(Layouts.ARRAY.getStore(array)).getBoxedCopy(Layouts.ARRAY.getSize(array));
    }

    public static Iterable<Object> toIterable(DynamicObject array) {
        return ArrayReflector.reflect(Layouts.ARRAY.getStore(array)).iterableUntil(Layouts.ARRAY.getSize(array));
    }

    public static void append(DynamicObject array, Object value) {
        assert (RubyGuards.isRubyArray(array));
        Layouts.ARRAY.setStore(array, Arrays.copyOf(ArrayUtils.box(Layouts.ARRAY.getStore(array)), Layouts.ARRAY.getSize(array) + 1));
        Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array));
        ((Object[])Layouts.ARRAY.getStore((DynamicObject)array))[Layouts.ARRAY.getSize((DynamicObject)array)] = value;
        Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) + 1);
    }
}

