/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.SingleValueCastNode;
import org.jruby.truffle.nodes.cast.SingleValueCastNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FiberNodesFactory;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.nodes.rubinius.ThreadPrimitiveNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.BreakException;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ReturnException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

@CoreClass(name="Fiber")
public abstract class FiberNodes {
    public static DynamicObject createFiber(DynamicObject thread, DynamicObject rubyClass, String name) {
        return FiberNodes.createFiber(thread, rubyClass, name, false);
    }

    public static DynamicObject createRootFiber(RubyContext context, DynamicObject thread) {
        return FiberNodes.createFiber(thread, context.getCoreLibrary().getFiberClass(), "root Fiber for Thread", true);
    }

    private static DynamicObject createFiber(DynamicObject thread, DynamicObject rubyClass, String name, boolean isRootFiber) {
        assert (RubyGuards.isRubyThread(thread));
        return Layouts.FIBER.createFiber(Layouts.CLASS.getInstanceFactory(rubyClass), isRootFiber, new CountDownLatch(1), new LinkedBlockingQueue<FiberMessage>(2), thread, null, true, null);
    }

    public static void initialize(final RubyContext context, final DynamicObject fiber, final DynamicObject block, final Node currentNode) {
        String name = "Ruby Fiber@" + Layouts.PROC.getSharedMethodInfo(block).getSourceSection().getShortDescription();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                FiberNodes.handleFiberExceptions(context, fiber, block, currentNode);
            }
        });
        thread.setName(name);
        thread.start();
        FiberNodes.waitForInitialization(context, fiber, currentNode);
    }

    public static void waitForInitialization(RubyContext context, DynamicObject fiber, Node currentNode) {
        final CountDownLatch initializedLatch = Layouts.FIBER.getInitializedLatch(fiber);
        context.getThreadManager().runUntilSuccessKeepRunStatus(currentNode, new ThreadManager.BlockingAction<Boolean>(){

            @Override
            public Boolean block() throws InterruptedException {
                initializedLatch.await();
                return true;
            }
        });
    }

    private static void handleFiberExceptions(final RubyContext context, final DynamicObject fiber, final DynamicObject block, Node currentNode) {
        FiberNodes.run(context, fiber, currentNode, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object result;
                    Object[] args = FiberNodes.waitForResume(context, fiber);
                    try {
                        result = ProcNodes.rootCall(block, args);
                    }
                    finally {
                        Layouts.FIBER.setAlive(fiber, false);
                    }
                    FiberNodes.resume(fiber, Layouts.FIBER.getLastResumedByFiber(fiber), true, new Object[]{result});
                }
                catch (FiberExitException e) {
                    assert (!Layouts.FIBER.getRootFiber(fiber));
                }
                catch (BreakException e) {
                    Layouts.FIBER.getMessageQueue(Layouts.FIBER.getLastResumedByFiber(fiber)).add(new FiberExceptionMessage(context.getCoreLibrary().breakFromProcClosure(null)));
                }
                catch (ReturnException e) {
                    Layouts.FIBER.getMessageQueue(Layouts.FIBER.getLastResumedByFiber(fiber)).add(new FiberExceptionMessage(context.getCoreLibrary().unexpectedReturn(null)));
                }
                catch (RaiseException e) {
                    Layouts.FIBER.getMessageQueue(Layouts.FIBER.getLastResumedByFiber(fiber)).add(new FiberExceptionMessage(e.getRubyException()));
                }
            }
        });
    }

    public static void run(RubyContext context, DynamicObject fiber, Node currentNode, Runnable task) {
        assert (RubyGuards.isRubyFiber(fiber));
        FiberNodes.start(context, fiber);
        try {
            task.run();
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getRubyException()) == context.getCoreLibrary().getSystemExitClass()) {
                ThreadPrimitiveNodes.ThreadRaisePrimitiveNode.raiseInThread(context, context.getThreadManager().getRootThread(), e.getRubyException(), currentNode);
            }
            throw e;
        }
        finally {
            FiberNodes.cleanup(context, fiber);
        }
    }

    public static void start(RubyContext context, DynamicObject fiber) {
        assert (RubyGuards.isRubyFiber(fiber));
        Layouts.FIBER.setThread(fiber, Thread.currentThread());
        context.getThreadManager().initializeCurrentThread(Layouts.FIBER.getRubyThread(fiber));
        Layouts.THREAD.getFiberManager(Layouts.FIBER.getRubyThread(fiber)).registerFiber(fiber);
        context.getSafepointManager().enterThread();
        Layouts.FIBER.getInitializedLatch(fiber).countDown();
    }

    public static void cleanup(RubyContext context, DynamicObject fiber) {
        assert (RubyGuards.isRubyFiber(fiber));
        Layouts.FIBER.setAlive(fiber, false);
        context.getSafepointManager().leaveThread();
        Layouts.THREAD.getFiberManager(Layouts.FIBER.getRubyThread(fiber)).unregisterFiber(fiber);
        Layouts.FIBER.setThread(fiber, null);
    }

    private static Object[] waitForResume(RubyContext context, final DynamicObject fiber) {
        assert (RubyGuards.isRubyFiber(fiber));
        FiberMessage message = context.getThreadManager().runUntilResult(null, new ThreadManager.BlockingAction<FiberMessage>(){

            @Override
            public FiberMessage block() throws InterruptedException {
                return Layouts.FIBER.getMessageQueue(fiber).take();
            }
        });
        Layouts.THREAD.getFiberManager(Layouts.FIBER.getRubyThread(fiber)).setCurrentFiber(fiber);
        if (message instanceof FiberExitMessage) {
            throw new FiberExitException();
        }
        if (message instanceof FiberExceptionMessage) {
            throw new RaiseException(((FiberExceptionMessage)message).getException());
        }
        if (message instanceof FiberResumeMessage) {
            FiberResumeMessage resumeMessage = (FiberResumeMessage)message;
            assert (context.getThreadManager().getCurrentThread() == Layouts.FIBER.getRubyThread(resumeMessage.getSendingFiber()));
            if (!resumeMessage.isYield()) {
                Layouts.FIBER.setLastResumedByFiber(fiber, resumeMessage.getSendingFiber());
            }
            return resumeMessage.getArgs();
        }
        throw new UnsupportedOperationException();
    }

    private static void resume(DynamicObject fromFiber, DynamicObject fiber, boolean yield, Object ... args) {
        assert (RubyGuards.isRubyFiber(fromFiber));
        assert (RubyGuards.isRubyFiber(fiber));
        Layouts.FIBER.getMessageQueue(fiber).add(new FiberResumeMessage(yield, fromFiber, args));
    }

    public static Object[] transferControlTo(RubyContext context, DynamicObject fromFiber, DynamicObject fiber, boolean yield, Object[] args) {
        assert (RubyGuards.isRubyFiber(fromFiber));
        assert (RubyGuards.isRubyFiber(fiber));
        FiberNodes.resume(fromFiber, fiber, yield, args);
        return FiberNodes.waitForResume(context, fromFiber);
    }

    public static void shutdown(DynamicObject fiber) {
        assert (RubyGuards.isRubyFiber(fiber));
        assert (!Layouts.FIBER.getRootFiber(fiber));
        Layouts.FIBER.getMessageQueue(fiber).add(new FiberExitMessage());
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            DynamicObject parent = this.getContext().getThreadManager().getCurrentThread();
            return FiberNodes.createFiber(parent, rubyClass, null);
        }
    }

    @CoreMethod(names={"current"}, onSingleton=true)
    public static abstract class CurrentNode
    extends CoreMethodNode {
        public CurrentNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject current() {
            DynamicObject currentThread = this.getContext().getThreadManager().getCurrentThread();
            return Layouts.THREAD.getFiberManager(currentThread).getCurrentFiber();
        }
    }

    @CoreMethod(names={"alive?"})
    public static abstract class AliveNode
    extends UnaryCoreMethodNode {
        public AliveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean alive(DynamicObject fiber) {
            return Layouts.FIBER.getAlive(fiber);
        }
    }

    public static class FiberExitException
    extends ControlFlowException {
        private static final long serialVersionUID = 1522270454305076317L;
    }

    public static class FiberExceptionMessage
    implements FiberMessage {
        private final DynamicObject exception;

        public FiberExceptionMessage(DynamicObject exception) {
            this.exception = exception;
        }

        public DynamicObject getException() {
            return this.exception;
        }
    }

    public static class FiberExitMessage
    implements FiberMessage {
    }

    public static class FiberResumeMessage
    implements FiberMessage {
        private final boolean yield;
        private final DynamicObject sendingFiber;
        private final Object[] args;

        public FiberResumeMessage(boolean yield, DynamicObject sendingFiber, Object[] args) {
            assert (RubyGuards.isRubyFiber(sendingFiber));
            this.yield = yield;
            this.sendingFiber = sendingFiber;
            this.args = args;
        }

        public boolean isYield() {
            return this.yield;
        }

        public DynamicObject getSendingFiber() {
            return this.sendingFiber;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }

    @CoreMethod(names={"yield"}, onSingleton=true, rest=true)
    public static abstract class YieldNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        FiberTransferNode fiberTransferNode;

        public YieldNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fiberTransferNode = FiberNodesFactory.FiberTransferNodeFactory.create(context, sourceSection, new RubyNode[]{null, null, null});
        }

        @Specialization
        public Object yield(VirtualFrame frame, Object[] args) {
            DynamicObject currentThread = this.getContext().getThreadManager().getCurrentThread();
            DynamicObject yieldingFiber = Layouts.THREAD.getFiberManager(currentThread).getCurrentFiber();
            DynamicObject fiberYieldedTo = Layouts.FIBER.getLastResumedByFiber(yieldingFiber);
            if (Layouts.FIBER.getRootFiber(yieldingFiber) || fiberYieldedTo == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().yieldFromRootFiberError(this));
            }
            return this.fiberTransferNode.executeTransferControlTo(frame, fiberYieldedTo, true, args);
        }
    }

    @CoreMethod(names={"resume"}, rest=true)
    public static abstract class ResumeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        FiberTransferNode fiberTransferNode;

        public ResumeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fiberTransferNode = FiberNodesFactory.FiberTransferNodeFactory.create(context, sourceSection, new RubyNode[]{null, null, null});
        }

        @Specialization
        public Object resume(VirtualFrame frame, DynamicObject fiberBeingResumed, Object[] args) {
            return this.fiberTransferNode.executeTransferControlTo(frame, fiberBeingResumed, false, args);
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject initialize(DynamicObject fiber, DynamicObject block) {
            FiberNodes.initialize(this.getContext(), fiber, block, this);
            return this.nil();
        }
    }

    public static abstract class FiberTransferNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SingleValueCastNode singleValueCastNode;

        public FiberTransferNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        protected Object singleValue(VirtualFrame frame, Object[] args) {
            if (this.singleValueCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.singleValueCastNode = (SingleValueCastNode)this.insert(SingleValueCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.singleValueCastNode.executeSingleValue(frame, args);
        }

        public abstract Object executeTransferControlTo(VirtualFrame var1, DynamicObject var2, boolean var3, Object[] var4);

        @Specialization(guards={"isRubyFiber(fiber)"})
        protected Object transfer(VirtualFrame frame, DynamicObject fiber, boolean isYield, Object[] args) {
            CompilerDirectives.transferToInterpreter();
            if (!Layouts.FIBER.getAlive(fiber)) {
                throw new RaiseException(this.getContext().getCoreLibrary().deadFiberCalledError(this));
            }
            DynamicObject currentThread = this.getContext().getThreadManager().getCurrentThread();
            if (Layouts.FIBER.getRubyThread(fiber) != currentThread) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().fiberError("fiber called across threads", this));
            }
            DynamicObject sendingFiber = Layouts.THREAD.getFiberManager(currentThread).getCurrentFiber();
            return this.singleValue(frame, FiberNodes.transferControlTo(this.getContext(), sendingFiber, fiber, isYield, args));
        }
    }

    public static interface FiberMessage {
    }
}

