/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts.ext;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.security.MessageDigest;
import java.util.EnumSet;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.ext.DigestLayout;

public class DigestLayoutImpl
extends BasicObjectLayoutImpl
implements DigestLayout {
    public static final DigestLayout INSTANCE = new DigestLayoutImpl();
    protected static final Shape.Allocator DIGEST_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey DIGEST_IDENTIFIER = new HiddenKey("digest");
    protected static final Property DIGEST_PROPERTY = Property.create((Object)DIGEST_IDENTIFIER, (Location)DIGEST_ALLOCATOR.locationForType(MessageDigest.class, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected DigestLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createDigestShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new DigestType(logicalClass, metaClass)).addProperty(DIGEST_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createDigest(DynamicObjectFactory factory, MessageDigest digest) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsDigest(factory));
        assert (factory.getShape().hasProperty((Object)DIGEST_IDENTIFIER));
        assert (digest != null);
        return factory.newInstance(new Object[]{digest});
    }

    private boolean isDigest(DynamicObject object) {
        return this.isDigest(object.getShape().getObjectType());
    }

    private boolean isDigest(ObjectType objectType) {
        return objectType instanceof DigestType;
    }

    private boolean createsDigest(DynamicObjectFactory factory) {
        return this.isDigest(factory.getShape().getObjectType());
    }

    @Override
    public MessageDigest getDigest(DynamicObject object) {
        assert (this.isDigest(object));
        assert (object.getShape().hasProperty((Object)DIGEST_IDENTIFIER));
        return (MessageDigest)DIGEST_PROPERTY.get(object, true);
    }

    protected static class DigestType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public DigestType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public DigestType setLogicalClass(DynamicObject logicalClass) {
            return new DigestType(logicalClass, this.metaClass);
        }

        @Override
        public DigestType setMetaClass(DynamicObject metaClass) {
            return new DigestType(this.logicalClass, metaClass);
        }
    }
}

