/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.jruby.RubyThread;
import org.jruby.truffle.nodes.core.InterruptMode;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.ThreadLayout;
import org.jruby.truffle.runtime.subsystems.FiberManager;

public class ThreadLayoutImpl
extends BasicObjectLayoutImpl
implements ThreadLayout {
    public static final ThreadLayout INSTANCE = new ThreadLayoutImpl();
    protected static final Shape.Allocator THREAD_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey FIBER_MANAGER_IDENTIFIER = new HiddenKey("fiberManager");
    protected static final Property FIBER_MANAGER_PROPERTY = Property.create((Object)FIBER_MANAGER_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(FiberManager.class), (int)0);
    protected static final HiddenKey NAME_IDENTIFIER = new HiddenKey("name");
    protected static final Property NAME_PROPERTY = Property.create((Object)NAME_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(String.class), (int)0);
    protected static final HiddenKey FINISHED_LATCH_IDENTIFIER = new HiddenKey("finishedLatch");
    protected static final Property FINISHED_LATCH_PROPERTY = Property.create((Object)FINISHED_LATCH_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(CountDownLatch.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey THREAD_LOCALS_IDENTIFIER = new HiddenKey("threadLocals");
    protected static final Property THREAD_LOCALS_PROPERTY = Property.create((Object)THREAD_LOCALS_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey OWNED_LOCKS_IDENTIFIER = new HiddenKey("ownedLocks");
    protected static final Property OWNED_LOCKS_PROPERTY = Property.create((Object)OWNED_LOCKS_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(List.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey ABORT_ON_EXCEPTION_IDENTIFIER = new HiddenKey("abortOnException");
    protected static final Property ABORT_ON_EXCEPTION_PROPERTY = Property.create((Object)ABORT_ON_EXCEPTION_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey INTERRUPT_MODE_IDENTIFIER = new HiddenKey("interruptMode");
    protected static final Property INTERRUPT_MODE_PROPERTY = Property.create((Object)INTERRUPT_MODE_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(InterruptMode.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey THREAD_IDENTIFIER = new HiddenKey("thread");
    protected static final Property THREAD_PROPERTY = Property.create((Object)THREAD_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(AtomicReference.class), (int)0);
    protected static final HiddenKey STATUS_IDENTIFIER = new HiddenKey("status");
    protected static final Property STATUS_PROPERTY = Property.create((Object)STATUS_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(AtomicReference.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey EXCEPTION_IDENTIFIER = new HiddenKey("exception");
    protected static final Property EXCEPTION_PROPERTY = Property.create((Object)EXCEPTION_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(AtomicReference.class), (int)0);
    protected static final HiddenKey VALUE_IDENTIFIER = new HiddenKey("value");
    protected static final Property VALUE_PROPERTY = Property.create((Object)VALUE_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(AtomicReference.class), (int)0);
    protected static final HiddenKey WAKE_UP_IDENTIFIER = new HiddenKey("wakeUp");
    protected static final Property WAKE_UP_PROPERTY = Property.create((Object)WAKE_UP_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(AtomicBoolean.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey PRIORITY_IDENTIFIER = new HiddenKey("priority");
    protected static final Property PRIORITY_PROPERTY = Property.create((Object)PRIORITY_IDENTIFIER, (Location)THREAD_ALLOCATOR.locationForType(AtomicInteger.class, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected ThreadLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createThreadShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new ThreadType(logicalClass, metaClass)).addProperty(FIBER_MANAGER_PROPERTY).addProperty(NAME_PROPERTY).addProperty(FINISHED_LATCH_PROPERTY).addProperty(THREAD_LOCALS_PROPERTY).addProperty(OWNED_LOCKS_PROPERTY).addProperty(ABORT_ON_EXCEPTION_PROPERTY).addProperty(INTERRUPT_MODE_PROPERTY).addProperty(THREAD_PROPERTY).addProperty(STATUS_PROPERTY).addProperty(EXCEPTION_PROPERTY).addProperty(VALUE_PROPERTY).addProperty(WAKE_UP_PROPERTY).addProperty(PRIORITY_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createThread(DynamicObjectFactory factory, FiberManager fiberManager, String name, CountDownLatch finishedLatch, DynamicObject threadLocals, List<Lock> ownedLocks, boolean abortOnException, InterruptMode interruptMode, Thread thread, RubyThread.Status status, DynamicObject exception, Object value, AtomicBoolean wakeUp, int priority) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsThread(factory));
        assert (factory.getShape().hasProperty((Object)FIBER_MANAGER_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)NAME_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)FINISHED_LATCH_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)THREAD_LOCALS_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)OWNED_LOCKS_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)ABORT_ON_EXCEPTION_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)INTERRUPT_MODE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)THREAD_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)STATUS_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)EXCEPTION_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)VALUE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)WAKE_UP_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)PRIORITY_IDENTIFIER));
        assert (finishedLatch != null);
        assert (threadLocals != null);
        assert (ownedLocks != null);
        assert (interruptMode != null);
        assert (status != null);
        assert (wakeUp != null);
        return factory.newInstance(new Object[]{fiberManager, name, finishedLatch, threadLocals, ownedLocks, abortOnException, interruptMode, new AtomicReference<Thread>(thread), new AtomicReference<RubyThread.Status>(status), new AtomicReference<DynamicObject>(exception), new AtomicReference<Object>(value), wakeUp, new AtomicInteger(priority)});
    }

    @Override
    public boolean isThread(DynamicObject object) {
        return this.isThread(object.getShape().getObjectType());
    }

    private boolean isThread(ObjectType objectType) {
        return objectType instanceof ThreadType;
    }

    private boolean createsThread(DynamicObjectFactory factory) {
        return this.isThread(factory.getShape().getObjectType());
    }

    @Override
    public FiberManager getFiberManager(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)FIBER_MANAGER_IDENTIFIER));
        return (FiberManager)FIBER_MANAGER_PROPERTY.get(object, true);
    }

    @Override
    public void setFiberManagerUnsafe(DynamicObject object, FiberManager value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)FIBER_MANAGER_IDENTIFIER));
        FIBER_MANAGER_PROPERTY.setInternal(object, (Object)value);
    }

    @Override
    public String getName(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)NAME_IDENTIFIER));
        return (String)NAME_PROPERTY.get(object, true);
    }

    @Override
    public void setName(DynamicObject object, String value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)NAME_IDENTIFIER));
        try {
            NAME_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public CountDownLatch getFinishedLatch(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)FINISHED_LATCH_IDENTIFIER));
        return (CountDownLatch)FINISHED_LATCH_PROPERTY.get(object, true);
    }

    @Override
    public DynamicObject getThreadLocals(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)THREAD_LOCALS_IDENTIFIER));
        return (DynamicObject)THREAD_LOCALS_PROPERTY.get(object, true);
    }

    @Override
    public List<Lock> getOwnedLocks(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)OWNED_LOCKS_IDENTIFIER));
        return (List)OWNED_LOCKS_PROPERTY.get(object, true);
    }

    @Override
    public boolean getAbortOnException(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)ABORT_ON_EXCEPTION_IDENTIFIER));
        return (Boolean)ABORT_ON_EXCEPTION_PROPERTY.get(object, true);
    }

    @Override
    public void setAbortOnException(DynamicObject object, boolean value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)ABORT_ON_EXCEPTION_IDENTIFIER));
        try {
            ABORT_ON_EXCEPTION_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public InterruptMode getInterruptMode(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)INTERRUPT_MODE_IDENTIFIER));
        return (InterruptMode)((Object)INTERRUPT_MODE_PROPERTY.get(object, true));
    }

    @Override
    public void setInterruptMode(DynamicObject object, InterruptMode value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)INTERRUPT_MODE_IDENTIFIER));
        assert (value != null);
        try {
            INTERRUPT_MODE_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public Thread getThread(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)THREAD_IDENTIFIER));
        return (Thread)((AtomicReference)THREAD_PROPERTY.get(object, true)).get();
    }

    @Override
    public void setThread(DynamicObject object, Thread value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)THREAD_IDENTIFIER));
        ((AtomicReference)THREAD_PROPERTY.get(object, true)).set(value);
    }

    @Override
    public RubyThread.Status getStatus(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)STATUS_IDENTIFIER));
        return (RubyThread.Status)((AtomicReference)STATUS_PROPERTY.get(object, true)).get();
    }

    @Override
    public void setStatus(DynamicObject object, RubyThread.Status value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)STATUS_IDENTIFIER));
        assert (value != null);
        ((AtomicReference)STATUS_PROPERTY.get(object, true)).set(value);
    }

    @Override
    public DynamicObject getException(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)EXCEPTION_IDENTIFIER));
        return (DynamicObject)((AtomicReference)EXCEPTION_PROPERTY.get(object, true)).get();
    }

    @Override
    public void setException(DynamicObject object, DynamicObject value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)EXCEPTION_IDENTIFIER));
        ((AtomicReference)EXCEPTION_PROPERTY.get(object, true)).set(value);
    }

    @Override
    public Object getValue(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)VALUE_IDENTIFIER));
        return ((AtomicReference)VALUE_PROPERTY.get(object, true)).get();
    }

    @Override
    public void setValue(DynamicObject object, Object value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)VALUE_IDENTIFIER));
        ((AtomicReference)VALUE_PROPERTY.get(object, true)).set(value);
    }

    @Override
    public AtomicBoolean getWakeUp(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)WAKE_UP_IDENTIFIER));
        return (AtomicBoolean)WAKE_UP_PROPERTY.get(object, true);
    }

    @Override
    public int getPriority(DynamicObject object) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)PRIORITY_IDENTIFIER));
        return ((AtomicInteger)PRIORITY_PROPERTY.get(object, true)).get();
    }

    @Override
    public void setPriority(DynamicObject object, int value) {
        assert (this.isThread(object));
        assert (object.getShape().hasProperty((Object)PRIORITY_IDENTIFIER));
        ((AtomicInteger)PRIORITY_PROPERTY.get(object, true)).set(value);
    }

    protected static class ThreadType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ThreadType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ThreadType setLogicalClass(DynamicObject logicalClass) {
            return new ThreadType(logicalClass, this.metaClass);
        }

        @Override
        public ThreadType setMetaClass(DynamicObject metaClass) {
            return new ThreadType(this.logicalClass, metaClass);
        }
    }
}

