/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.InternalMethod;

public abstract class DispatchNode
extends RubyNode {
    private final DispatchAction dispatchAction;
    public static final Object MISSING = new Missing();

    public DispatchNode(RubyContext context, DispatchAction dispatchAction) {
        super(context, null);
        this.dispatchAction = dispatchAction;
        assert (dispatchAction != null);
    }

    protected abstract boolean guard(Object var1, Object var2);

    protected DispatchNode getNext() {
        return null;
    }

    public abstract Object executeDispatch(VirtualFrame var1, Object var2, Object var3, DynamicObject var4, Object[] var5);

    @CompilerDirectives.TruffleBoundary
    protected InternalMethod lookup(DynamicObject callerClass, Object receiver, String name, boolean ignoreVisibility) {
        assert (ignoreVisibility || RubyGuards.isRubyClass(callerClass));
        InternalMethod method = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(receiver), name);
        if (method == null) {
            return null;
        }
        if (method.isUndefined()) {
            return null;
        }
        if (!ignoreVisibility && !method.isVisibleTo(this, callerClass)) {
            return null;
        }
        return method;
    }

    protected Object resetAndDispatch(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object[] argumentsObjects, String reason) {
        DispatchHeadNode head = this.getHeadNode();
        head.reset(reason);
        return head.dispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
    }

    protected DispatchHeadNode getHeadNode() {
        return (DispatchHeadNode)((Object)NodeUtil.findParent((Node)this, DispatchHeadNode.class));
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        throw new IllegalStateException("do not call execute on dispatch nodes");
    }

    public DispatchAction getDispatchAction() {
        return this.dispatchAction;
    }

    public boolean couldOptimizeKeywordArguments() {
        return false;
    }

    private static final class Missing {
        private Missing() {
        }
    }
}

