/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.truffle.nodes.core.ThreadNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

public class ObjectSpaceManager {
    private final RubyContext context;
    private final Map<DynamicObject, FinalizerReference> finalizerReferences = new WeakHashMap<DynamicObject, FinalizerReference>();
    private final ReferenceQueue<DynamicObject> finalizerQueue = new ReferenceQueue();
    private DynamicObject finalizerThread;

    public ObjectSpaceManager(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void defineFinalizer(DynamicObject object, Object callable) {
        FinalizerReference finalizerReference = this.finalizerReferences.get(object);
        if (finalizerReference == null) {
            finalizerReference = new FinalizerReference(object, this.finalizerQueue);
            this.finalizerReferences.put(object, finalizerReference);
        }
        finalizerReference.addFinalizer(callable);
        if (this.finalizerThread == null) {
            this.finalizerThread = ThreadNodes.createRubyThread(this.context.getCoreLibrary().getThreadClass());
            ThreadNodes.initialize(this.finalizerThread, this.context, null, "finalizer", new Runnable(){

                @Override
                public void run() {
                    ObjectSpaceManager.this.runFinalizers();
                }
            });
        }
    }

    public synchronized void undefineFinalizer(DynamicObject object) {
        FinalizerReference finalizerReference = this.finalizerReferences.get(object);
        if (finalizerReference != null) {
            finalizerReference.clearFinalizers();
        }
    }

    private void runFinalizers() {
        while (true) {
            FinalizerReference finalizerReference = this.context.getThreadManager().runUntilResult(null, new ThreadManager.BlockingAction<FinalizerReference>(){

                @Override
                public FinalizerReference block() throws InterruptedException {
                    return (FinalizerReference)ObjectSpaceManager.this.finalizerQueue.remove();
                }
            });
            ObjectSpaceManager.runFinalizers(this.context, finalizerReference);
        }
    }

    private static void runFinalizers(RubyContext context, FinalizerReference finalizerReference) {
        try {
            for (Object callable : finalizerReference.getFinalizers()) {
                context.send(callable, "call", null, new Object[0]);
            }
        }
        catch (RaiseException raiseException) {
            // empty catch block
        }
    }

    public List<DynamicObject> getFinalizerHandlers() {
        ArrayList<DynamicObject> handlers = new ArrayList<DynamicObject>();
        for (FinalizerReference finalizer : this.finalizerReferences.values()) {
            for (Object handler : finalizer.getFinalizers()) {
                if (!(handler instanceof DynamicObject)) continue;
                handlers.add((DynamicObject)handler);
            }
        }
        return handlers;
    }

    private static class FinalizerReference
    extends WeakReference<DynamicObject> {
        public List<Object> finalizers = new LinkedList<Object>();

        public FinalizerReference(DynamicObject object, ReferenceQueue<? super DynamicObject> queue) {
            super(object, queue);
        }

        public void addFinalizer(Object callable) {
            this.finalizers.add(callable);
        }

        public List<Object> getFinalizers() {
            return this.finalizers;
        }

        public void clearFinalizers() {
            this.finalizers = new LinkedList<Object>();
        }
    }
}

