/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.runtime.Helpers;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.StringCodeRangeableWrapper;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.CodeRangeable;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

public abstract class StringOperations {
    @CompilerDirectives.TruffleBoundary
    public static String getString(DynamicObject string) {
        return Helpers.decodeByteList((Ruby)Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(string)).getContext().getRuntime(), (ByteList)Layouts.STRING.getByteList(string));
    }

    public static StringCodeRangeableWrapper getCodeRangeable(DynamicObject string) {
        StringCodeRangeableWrapper wrapper = Layouts.STRING.getCodeRangeableWrapper(string);
        if (wrapper == null) {
            wrapper = new StringCodeRangeableWrapper(string);
            Layouts.STRING.setCodeRangeableWrapper(string, wrapper);
        }
        return wrapper;
    }

    @CompilerDirectives.TruffleBoundary
    public static int scanForCodeRange(DynamicObject string) {
        int cr = Layouts.STRING.getCodeRange(string);
        if (cr == 0) {
            cr = StringOperations.slowCodeRangeScan(string);
            Layouts.STRING.setCodeRange(string, cr);
        }
        return cr;
    }

    public static boolean isCodeRangeValid(DynamicObject string) {
        return Layouts.STRING.getCodeRange(string) == 32;
    }

    public static void clearCodeRange(DynamicObject string) {
        Layouts.STRING.setCodeRange(string, 0);
    }

    public static void keepCodeRange(DynamicObject string) {
        if (Layouts.STRING.getCodeRange(string) == 48) {
            StringOperations.clearCodeRange(string);
        }
    }

    public static void modify(DynamicObject string) {
        Layouts.STRING.getByteList(string).invalidate();
    }

    public static void modify(DynamicObject string, int length) {
        Layouts.STRING.getByteList(string).ensure(length);
        Layouts.STRING.getByteList(string).invalidate();
    }

    public static void modifyAndKeepCodeRange(DynamicObject string) {
        StringOperations.modify(string);
        StringOperations.keepCodeRange(string);
    }

    @CompilerDirectives.TruffleBoundary
    public static Encoding checkEncoding(DynamicObject string, CodeRangeable other) {
        Encoding encoding = StringSupport.areCompatible((CodeRangeable)StringOperations.getCodeRangeable(string), (CodeRangeable)other);
        if (encoding == null) {
            throw Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(string)).getContext().getRuntime().newEncodingCompatibilityError(String.format("incompatible character encodings: %s and %s", Layouts.STRING.getByteList(string).getEncoding().toString(), other.getByteList().getEncoding().toString()));
        }
        return encoding;
    }

    @CompilerDirectives.TruffleBoundary
    private static int slowCodeRangeScan(DynamicObject string) {
        ByteList byteList = Layouts.STRING.getByteList(string);
        return StringSupport.codeRangeScan((Encoding)byteList.getEncoding(), (ByteList)byteList);
    }

    public static void forceEncoding(DynamicObject string, Encoding encoding) {
        StringOperations.modify(string);
        StringOperations.clearCodeRange(string);
        StringSupport.associateEncoding((CodeRangeable)StringOperations.getCodeRangeable(string), (Encoding)encoding);
        StringOperations.clearCodeRange(string);
    }

    public static int length(DynamicObject string) {
        if (CompilerDirectives.injectBranchProbability((double)0.9999, (boolean)StringSupport.isSingleByteOptimizable((CodeRangeable)StringOperations.getCodeRangeable(string), (Encoding)Layouts.STRING.getByteList(string).getEncoding()))) {
            return Layouts.STRING.getByteList(string).getRealSize();
        }
        return StringSupport.strLengthFromRubyString((CodeRangeable)StringOperations.getCodeRangeable(string));
    }

    public static int normalizeIndex(int length, int index) {
        return ArrayOperations.normalizeIndex(length, index);
    }

    public static int normalizeIndex(DynamicObject rubyString, int index) {
        return StringOperations.normalizeIndex(StringOperations.length(rubyString), index);
    }

    public static int clampExclusiveIndex(DynamicObject string, int index) {
        assert (RubyGuards.isRubyString(string));
        return ArrayOperations.clampExclusiveIndex(Layouts.STRING.getByteList(string).length(), index);
    }

    @CompilerDirectives.TruffleBoundary
    public static Encoding checkEncoding(DynamicObject string, CodeRangeable other, Node node) {
        Encoding encoding = StringSupport.areCompatible((CodeRangeable)StringOperations.getCodeRangeable(string), (CodeRangeable)other);
        if (encoding == null) {
            throw new RaiseException(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(string)).getContext().getCoreLibrary().encodingCompatibilityErrorIncompatible(Layouts.STRING.getByteList(string).getEncoding().toString(), other.getByteList().getEncoding().toString(), node));
        }
        return encoding;
    }

    public static boolean singleByteOptimizable(DynamicObject string) {
        return StringSupport.isSingleByteOptimizable((CodeRangeable)StringOperations.getCodeRangeable(string), (Encoding)EncodingUtils.STR_ENC_GET((ByteListHolder)StringOperations.getCodeRangeable(string)));
    }
}

