/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.parser;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.ArrayList;
import org.jruby.truffle.pack.nodes.PackNode;
import org.jruby.truffle.pack.nodes.PackRootNode;
import org.jruby.truffle.pack.nodes.SourceNode;
import org.jruby.truffle.pack.nodes.control.SequenceNode;
import org.jruby.truffle.pack.nodes.format.FormatFloatNodeGen;
import org.jruby.truffle.pack.nodes.format.FormatIntegerNodeGen;
import org.jruby.truffle.pack.nodes.read.LiteralBytesNode;
import org.jruby.truffle.pack.nodes.read.ReadStringNodeGen;
import org.jruby.truffle.pack.nodes.read.ReadValueNodeGen;
import org.jruby.truffle.pack.nodes.type.ToDoubleWithCoercionNodeGen;
import org.jruby.truffle.pack.nodes.type.ToIntegerNodeGen;
import org.jruby.truffle.pack.nodes.write.WriteByteNode;
import org.jruby.truffle.pack.nodes.write.WriteBytesNodeGen;
import org.jruby.truffle.pack.nodes.write.WritePaddedBytesNodeGen;
import org.jruby.truffle.pack.parser.FormatDirective;
import org.jruby.truffle.pack.parser.FormatTokenizer;
import org.jruby.truffle.pack.parser.PackParser;
import org.jruby.truffle.pack.runtime.PackEncoding;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

public class FormatParser {
    private final RubyContext context;
    private PackEncoding encoding = PackEncoding.DEFAULT;

    public FormatParser(RubyContext context) {
        this.context = context;
    }

    public CallTarget parse(ByteList format) {
        FormatTokenizer tokenizer = new FormatTokenizer(format);
        PackNode body = this.parse(tokenizer);
        return Truffle.getRuntime().createCallTarget((RootNode)new PackRootNode(PackParser.describe(format.toString()), this.encoding, body));
    }

    public PackNode parse(FormatTokenizer tokenizer) {
        Object token;
        ArrayList<WriteByteNode> sequenceChildren = new ArrayList<WriteByteNode>();
        while ((token = tokenizer.next()) != null) {
            PackNode node;
            if (token instanceof ByteList) {
                ByteList byteList = (ByteList)token;
                node = byteList.length() == 1 ? new WriteByteNode(this.context, (byte)byteList.get(0)) : WriteBytesNodeGen.create(this.context, new LiteralBytesNode(this.context, byteList));
            } else if (token instanceof FormatDirective) {
                FormatDirective directive = (FormatDirective)token;
                switch (directive.getType()) {
                    case '%': {
                        node = new WriteByteNode(this.context, 37);
                        break;
                    }
                    case 's': {
                        if (directive.getSpacePadding() == -1) {
                            node = WriteBytesNodeGen.create(this.context, ReadStringNodeGen.create(this.context, true, "to_s", false, new ByteList(), new SourceNode()));
                            break;
                        }
                        node = WritePaddedBytesNodeGen.create(this.context, directive.getSpacePadding(), directive.getLeftJustified(), ReadStringNodeGen.create(this.context, true, "to_s", false, new ByteList(), new SourceNode()));
                        break;
                    }
                    case 'X': 
                    case 'd': 
                    case 'i': 
                    case 'u': 
                    case 'x': {
                        char format;
                        int spacePadding = directive.getSpacePadding();
                        int zeroPadding = directive.getPrecision() != -1 ? directive.getPrecision() : directive.getZeroPadding();
                        switch (directive.getType()) {
                            case 'd': 
                            case 'i': 
                            case 'u': {
                                format = 'd';
                                break;
                            }
                            case 'X': 
                            case 'x': {
                                format = directive.getType();
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException();
                            }
                        }
                        node = WriteBytesNodeGen.create(this.context, FormatIntegerNodeGen.create(this.context, spacePadding, zeroPadding, format, ToIntegerNodeGen.create(this.context, ReadValueNodeGen.create(this.context, new SourceNode()))));
                        break;
                    }
                    case 'E': 
                    case 'G': 
                    case 'e': 
                    case 'f': 
                    case 'g': {
                        node = WriteBytesNodeGen.create(this.context, FormatFloatNodeGen.create(this.context, directive.getSpacePadding(), directive.getZeroPadding(), directive.getPrecision(), directive.getType(), ToDoubleWithCoercionNodeGen.create(this.context, ReadValueNodeGen.create(this.context, new SourceNode()))));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            } else {
                throw new UnsupportedOperationException();
            }
            sequenceChildren.add((WriteByteNode)node);
        }
        return new SequenceNode(this.context, sequenceChildren.toArray(new PackNode[sequenceChildren.size()]));
    }
}

