/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.nodes.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.pack.nodes.PackGuards;
import org.jruby.truffle.pack.nodes.PackNode;
import org.jruby.truffle.pack.runtime.exceptions.CantConvertException;
import org.jruby.truffle.pack.runtime.exceptions.NoImplicitConversionException;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class ToLongNode
extends PackNode {
    @Node.Child
    private CallDispatchHeadNode toIntNode;
    @CompilerDirectives.CompilationFinal
    private boolean seenInt;
    @CompilerDirectives.CompilationFinal
    private boolean seenLong;
    @CompilerDirectives.CompilationFinal
    private boolean seenBignum;

    public ToLongNode(RubyContext context) {
        super(context);
    }

    public abstract long executeToLong(VirtualFrame var1, Object var2);

    @Specialization
    public long toLong(VirtualFrame frame, boolean object) {
        CompilerDirectives.transferToInterpreter();
        throw new NoImplicitConversionException(object, "Integer");
    }

    @Specialization
    public long toLong(VirtualFrame frame, int object) {
        return object;
    }

    @Specialization
    public long toLong(VirtualFrame frame, long object) {
        return object;
    }

    @Specialization(guards={"isRubyBignum(object)"})
    public long toLong(VirtualFrame frame, DynamicObject object) {
        return Layouts.BIGNUM.getValue(object).longValue();
    }

    @Specialization(guards={"isNil(nil)"})
    public long toLongNil(VirtualFrame frame, Object nil) {
        CompilerDirectives.transferToInterpreter();
        throw new NoImplicitConversionException(nil, "Integer");
    }

    @Specialization(guards={"!isBoolean(object)", "!isInteger(object)", "!isLong(object)", "!isBigInteger(object)", "!isRubyBignum(object)", "!isNil(object)"})
    public long toLong(VirtualFrame frame, Object object) {
        if (this.toIntNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toIntNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true, MissingBehavior.RETURN_MISSING));
        }
        Object value = this.toIntNode.call(frame, object, "to_int", null, new Object[0]);
        if (this.seenInt && value instanceof Integer) {
            return this.toLong(frame, (Integer)value);
        }
        if (this.seenLong && value instanceof Long) {
            return this.toLong(frame, (Long)value);
        }
        if (this.seenBignum && PackGuards.isRubyBignum(value)) {
            return this.toLong(frame, (DynamicObject)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (value == DispatchNode.MISSING) {
            throw new NoImplicitConversionException(object, "Integer");
        }
        if (value instanceof Integer) {
            this.seenInt = true;
            return this.toLong(frame, (Integer)value);
        }
        if (value instanceof Long) {
            this.seenLong = true;
            return this.toLong(frame, (Long)value);
        }
        if (PackGuards.isRubyBignum(value)) {
            this.seenBignum = true;
            return this.toLong(frame, (DynamicObject)value);
        }
        throw new CantConvertException("can't convert Object to Integer");
    }
}

