/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChild(value="child", type=RubyNode.class)
public abstract class TaintNode
extends RubyNode {
    @Node.Child
    private WriteHeadObjectFieldNode writeTaintNode;

    public TaintNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeTaint(Object var1);

    @Specialization
    public Object taint(boolean object) {
        return this.frozen(object);
    }

    @Specialization
    public Object taint(int object) {
        return this.frozen(object);
    }

    @Specialization
    public Object taint(long object) {
        return this.frozen(object);
    }

    @Specialization
    public Object taint(double object) {
        return this.frozen(object);
    }

    @Specialization(guards={"isRubySymbol(symbol)"})
    public Object taintSymbol(DynamicObject symbol) {
        return this.frozen(symbol);
    }

    @Specialization(guards={"!isRubySymbol(object)"})
    public Object taint(DynamicObject object) {
        if (this.writeTaintNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.writeTaintNode = (WriteHeadObjectFieldNode)this.insert(new WriteHeadObjectFieldNode(Layouts.TAINTED_IDENTIFIER));
        }
        this.writeTaintNode.execute(object, true);
        return object;
    }

    private Object frozen(Object object) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().frozenError(Layouts.MODULE.getFields(this.getContext().getCoreLibrary().getLogicalClass(object)).getName(), this));
    }
}

