/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

public class StringLiteralNode
extends RubyNode {
    private final ByteList bytes;
    private final int codeRange;

    public StringLiteralNode(RubyContext context, SourceSection sourceSection, ByteList bytes, int codeRange) {
        super(context, sourceSection);
        assert (bytes != null);
        this.bytes = bytes;
        this.codeRange = codeRange;
    }

    public DynamicObject execute(VirtualFrame frame) {
        DynamicObject string = Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), this.bytes.dup(), this.codeRange, null);
        return string;
    }
}

