/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ThreadExitException;
import org.jruby.truffle.runtime.layouts.Layouts;

public class TopLevelRaiseHandler
extends RubyNode {
    @Node.Child
    private RubyNode body;

    public TopLevelRaiseHandler(RubyContext context, SourceSection sourceSection, RubyNode body) {
        super(context, sourceSection);
        this.body = body;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            return this.body.execute(frame);
        }
        catch (RaiseException e) {
            this.handleException(e);
        }
        catch (ThreadExitException threadExitException) {
            // empty catch block
        }
        return this.nil();
    }

    @CompilerDirectives.TruffleBoundary
    private void handleException(RaiseException e) {
        Object rubyException = e.getRubyException();
        BacktraceFormatter.createDefaultFormatter(this.getContext()).printBacktrace((DynamicObject)rubyException, Layouts.EXCEPTION.getBacktrace((DynamicObject)rubyException));
        System.exit(1);
    }
}

