/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.jruby.RubyThread;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.FiberNodes;
import org.jruby.truffle.nodes.core.InterruptMode;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.ReturnException;
import org.jruby.truffle.runtime.control.ThreadExitException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.subsystems.FiberManager;
import org.jruby.truffle.runtime.subsystems.SafepointAction;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

@CoreClass(name="Thread")
public abstract class ThreadNodes {
    public static DynamicObject createRubyThread(DynamicObject rubyClass) {
        DynamicObject objectClass = Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(rubyClass)).getContext().getCoreLibrary().getObjectClass();
        DynamicObject object = Layouts.THREAD.createThread(Layouts.CLASS.getInstanceFactory(rubyClass), null, null, new CountDownLatch(1), Layouts.BASIC_OBJECT.createBasicObject(Layouts.CLASS.getInstanceFactory(objectClass)), new ArrayList<Lock>(), false, InterruptMode.IMMEDIATE, null, RubyThread.Status.RUN, null, null, new AtomicBoolean(false), 0);
        Layouts.THREAD.setFiberManagerUnsafe(object, new FiberManager(object));
        return object;
    }

    public static void initialize(final DynamicObject thread, RubyContext context, Node currentNode, final Object[] arguments, final DynamicObject block) {
        assert (RubyGuards.isRubyThread(thread));
        assert (RubyGuards.isRubyProc(block));
        String info = Layouts.PROC.getSharedMethodInfo(block).getSourceSection().getShortDescription();
        ThreadNodes.initialize(thread, context, currentNode, info, new Runnable(){

            @Override
            public void run() {
                Layouts.THREAD.setValue(thread, ProcNodes.rootCall(block, arguments));
            }
        });
    }

    public static void initialize(final DynamicObject thread, final RubyContext context, final Node currentNode, final String info, final Runnable task) {
        assert (RubyGuards.isRubyThread(thread));
        new Thread(new Runnable(){

            @Override
            public void run() {
                ThreadNodes.run(thread, context, currentNode, info, task);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(DynamicObject thread, RubyContext context, Node currentNode, String info, Runnable task) {
        assert (RubyGuards.isRubyThread(thread));
        String name = "Ruby Thread@" + info;
        Layouts.THREAD.setName(thread, name);
        Thread.currentThread().setName(name);
        ThreadNodes.start(thread);
        try {
            DynamicObject fiber = Layouts.THREAD.getFiberManager(thread).getRootFiber();
            FiberNodes.run(fiber, task);
        }
        catch (ThreadExitException e) {
            Layouts.THREAD.setValue(thread, context.getCoreLibrary().getNilObject());
            return;
        }
        catch (RaiseException e) {
            Layouts.THREAD.setException(thread, e.getRubyException());
        }
        catch (ReturnException e) {
            Layouts.THREAD.setException(thread, context.getCoreLibrary().unexpectedReturn(currentNode));
        }
        finally {
            ThreadNodes.cleanup(thread);
        }
    }

    public static void start(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        Layouts.THREAD.setThread(thread, Thread.currentThread());
        Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getMetaClass(thread)).getContext().getThreadManager().registerThread(thread);
    }

    public static void cleanup(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        Layouts.THREAD.setStatus(thread, RubyThread.Status.ABORTING);
        Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getMetaClass(thread)).getContext().getThreadManager().unregisterThread(thread);
        Layouts.THREAD.setStatus(thread, RubyThread.Status.DEAD);
        Layouts.THREAD.setThread(thread, null);
        assert (RubyGuards.isRubyThread(thread));
        for (Lock lock : Layouts.THREAD.getOwnedLocks(thread)) {
            lock.unlock();
        }
        Layouts.THREAD.getFinishedLatch(thread).countDown();
    }

    public static void shutdown(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        Layouts.THREAD.getFiberManager(thread).shutdown();
        throw new ThreadExitException();
    }

    @CoreMethod(names={"list"}, onSingleton=true)
    public static abstract class ListNode
    extends CoreMethodArrayArgumentsNode {
        public ListNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject list() {
            DynamicObject[] threads = this.getContext().getThreadManager().getThreads();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), threads, threads.length);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return ThreadNodes.createRubyThread(rubyClass);
        }
    }

    @CoreMethod(names={"abort_on_exception="}, required=1)
    public static abstract class SetAbortOnExceptionNode
    extends CoreMethodArrayArgumentsNode {
        public SetAbortOnExceptionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject setAbortOnException(DynamicObject self, boolean abortOnException) {
            Layouts.THREAD.setAbortOnException(self, abortOnException);
            return this.nil();
        }
    }

    @CoreMethod(names={"abort_on_exception"})
    public static abstract class AbortOnExceptionNode
    extends CoreMethodArrayArgumentsNode {
        public AbortOnExceptionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean abortOnException(DynamicObject self) {
            return Layouts.THREAD.getAbortOnException(self);
        }
    }

    @CoreMethod(names={"wakeup", "run"})
    public static abstract class WakeupNode
    extends CoreMethodArrayArgumentsNode {
        public WakeupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject wakeup(DynamicObject thread) {
            if (Layouts.THREAD.getStatus(thread) == RubyThread.Status.DEAD) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("killed thread", this));
            }
            Layouts.THREAD.getWakeUp(thread).set(true);
            Thread t = Layouts.THREAD.getThread(thread);
            if (t != null) {
                t.interrupt();
            }
            return thread;
        }
    }

    @CoreMethod(names={"value"})
    public static abstract class ValueNode
    extends CoreMethodArrayArgumentsNode {
        public ValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object value(DynamicObject self) {
            JoinNode.doJoin(this, self);
            return Layouts.THREAD.getValue(self);
        }
    }

    @CoreMethod(names={"stop?"})
    public static abstract class StopNode
    extends CoreMethodArrayArgumentsNode {
        public StopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean stop(DynamicObject self) {
            return Layouts.THREAD.getStatus(self) == RubyThread.Status.DEAD || Layouts.THREAD.getStatus(self) == RubyThread.Status.SLEEP;
        }
    }

    @CoreMethod(names={"status"})
    public static abstract class StatusNode
    extends CoreMethodArrayArgumentsNode {
        public StatusNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object status(DynamicObject self) {
            if (Layouts.THREAD.getStatus(self) == RubyThread.Status.DEAD) {
                if (Layouts.THREAD.getException(self) != null) {
                    return this.nil();
                }
                return false;
            }
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), Layouts.THREAD.getStatus((DynamicObject)self).bytes, 0, null);
        }
    }

    @CoreMethod(names={"pass"}, onSingleton=true)
    public static abstract class PassNode
    extends CoreMethodArrayArgumentsNode {
        public PassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject pass(VirtualFrame frame) {
            Thread.yield();
            return this.nil();
        }
    }

    @CoreMethod(names={"main"}, onSingleton=true)
    public static abstract class MainNode
    extends CoreMethodArrayArgumentsNode {
        public MainNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject main() {
            return this.getContext().getThreadManager().getRootThread();
        }
    }

    @CoreMethod(names={"join"}, optional=1)
    public static abstract class JoinNode
    extends CoreMethodArrayArgumentsNode {
        public JoinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject join(DynamicObject thread, NotProvided timeout) {
            JoinNode.doJoin(this, thread);
            return thread;
        }

        @Specialization(guards={"isNil(nil)"})
        public DynamicObject join(DynamicObject thread, Object nil) {
            return this.join(thread, NotProvided.INSTANCE);
        }

        @Specialization
        public Object join(DynamicObject thread, int timeout) {
            return this.joinMillis(thread, timeout * 1000);
        }

        @Specialization
        public Object join(DynamicObject thread, double timeout) {
            return this.joinMillis(thread, (int)(timeout * 1000.0));
        }

        private Object joinMillis(DynamicObject self, int timeoutInMillis) {
            if (this.doJoinMillis(self, timeoutInMillis)) {
                return self;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        public static void doJoin(RubyNode currentNode, final DynamicObject thread) {
            currentNode.getContext().getThreadManager().runUntilResult(currentNode, new ThreadManager.BlockingAction<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    Layouts.THREAD.getFinishedLatch(thread).await();
                    return true;
                }
            });
            if (Layouts.THREAD.getException(thread) != null) {
                throw new RaiseException(Layouts.THREAD.getException(thread));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean doJoinMillis(final DynamicObject thread, final int timeoutInMillis) {
            final long start = System.currentTimeMillis();
            boolean joined = this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    long now = System.currentTimeMillis();
                    long waited = now - start;
                    if (waited >= (long)timeoutInMillis) {
                        return Layouts.THREAD.getFinishedLatch(thread).getCount() == 0L;
                    }
                    return Layouts.THREAD.getFinishedLatch(thread).await((long)timeoutInMillis - waited, TimeUnit.MILLISECONDS);
                }
            });
            if (joined && Layouts.THREAD.getException(thread) != null) {
                throw new RaiseException(Layouts.THREAD.getException(thread));
            }
            return joined;
        }
    }

    @CoreMethod(names={"initialize"}, rest=true, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyProc(block)"})
        public DynamicObject initialize(DynamicObject thread, Object[] arguments, DynamicObject block) {
            ThreadNodes.initialize(thread, this.getContext(), (Node)this, arguments, block);
            return this.nil();
        }
    }

    @CoreMethod(names={"handle_interrupt"}, required=2, needsBlock=true, visibility=Visibility.PRIVATE)
    public static abstract class HandleInterruptNode
    extends YieldingCoreMethodNode {
        private final DynamicObject immediateSymbol = this.getContext().getSymbol("immediate");
        private final DynamicObject onBlockingSymbol = this.getContext().getSymbol("on_blocking");
        private final DynamicObject neverSymbol = this.getContext().getSymbol("never");

        public HandleInterruptNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isRubyClass(exceptionClass)", "isRubySymbol(timing)", "isRubyProc(block)"})
        public Object handle_interrupt(VirtualFrame frame, DynamicObject self, DynamicObject exceptionClass, DynamicObject timing, DynamicObject block) {
            InterruptMode newInterruptMode = this.symbolToInterruptMode(timing);
            InterruptMode oldInterruptMode = Layouts.THREAD.getInterruptMode(self);
            Layouts.THREAD.setInterruptMode(self, newInterruptMode);
            try {
                Object object = this.yield(frame, block, new Object[0]);
                return object;
            }
            finally {
                Layouts.THREAD.setInterruptMode(self, oldInterruptMode);
            }
        }

        private InterruptMode symbolToInterruptMode(DynamicObject symbol) {
            if (symbol == this.immediateSymbol) {
                return InterruptMode.IMMEDIATE;
            }
            if (symbol == this.onBlockingSymbol) {
                return InterruptMode.ON_BLOCKING;
            }
            if (symbol == this.neverSymbol) {
                return InterruptMode.NEVER;
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("invalid timing symbol", this));
        }
    }

    @CoreMethod(names={"kill", "exit", "terminate"})
    public static abstract class KillNode
    extends CoreMethodArrayArgumentsNode {
        public KillNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject kill(DynamicObject rubyThread) {
            Thread toKill = Layouts.THREAD.getThread(rubyThread);
            this.getContext().getSafepointManager().pauseThreadAndExecuteLater(toKill, this, new SafepointAction(){

                @Override
                public void run(DynamicObject currentThread, Node currentNode) {
                    ThreadNodes.shutdown(currentThread);
                }
            });
            return rubyThread;
        }
    }

    @CoreMethod(names={"current"}, onSingleton=true)
    public static abstract class CurrentNode
    extends CoreMethodArrayArgumentsNode {
        public CurrentNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject current() {
            return this.getContext().getThreadManager().getCurrentThread();
        }
    }

    @CoreMethod(names={"alive?"})
    public static abstract class AliveNode
    extends CoreMethodArrayArgumentsNode {
        public AliveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean alive(DynamicObject thread) {
            return Layouts.THREAD.getStatus(thread) != RubyThread.Status.ABORTING && Layouts.THREAD.getStatus(thread) != RubyThread.Status.DEAD;
        }
    }
}

